/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.xmp.XmpDirectory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.fczx.live.data.AssignSegmentVo;
import com.geoway.ue.common.util.Path;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FczxLiveTool {
    private static final Logger log = LoggerFactory.getLogger(FczxLiveTool.class);

    public static String getJobIdFromVideo(String video) {
        int len = video.length();
        return video.substring(0, len - 32);
    }

    public static String buildLiveRecordRes(String bizId, String prefix, Date time) {
        String fmtTime = DateUtil.format((Date)time, (String)"yyyyMMddHHmmss");
        String name = "GW_" + fmtTime + ".mp4";
        return Path.joinPath((String)"/", (String[])new String[]{prefix, bizId.replaceAll("-", ""), name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> readAttachExif(InputStream stream) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)stream);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Directory directory : metadata.getDirectories()) {
                double focalLength;
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String desc = tag.getDescription();
                    map.put(tagName, desc);
                }
                if (directory instanceof ExifDirectoryBase && directory.containsTag(37386) && (focalLength = directory.getDouble(37386)) <= 16.0) {
                    map.put("photoType", 1);
                }
                if (directory instanceof Mp4Directory) {
                    if (directory.containsTag(101)) {
                        map.put("createTime", directory.getDate(101));
                    }
                    if (directory.containsTag(260)) {
                        map.put("duration", directory.getRational(260).doubleValue());
                    }
                }
                if (!(directory instanceof XmpDirectory)) continue;
                map.putAll(((XmpDirectory)directory).getXmpProperties());
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u7167\u7247exif\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)stream);
        }
        return null;
    }

    public static String getJobIdFromSrsParam(String urlSuffix) {
        String[] params;
        HashMap<String, String> data = new HashMap<String, String>();
        for (String param : params = urlSuffix.replace("?", "").split("&")) {
            String[] item = param.split("=");
            data.put(item[0], item[1]);
        }
        return (String)data.get("jobId");
    }

    public static void responseError(HttpServletResponse response, String error) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            response.setStatus(500);
            IoUtil.copy((InputStream)new ByteArrayInputStream(error.getBytes(StandardCharsets.UTF_8)), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    public static void responseJsonData(HttpServletResponse response, Object data) {
        try {
            String json = new ObjectMapper().writeValueAsString(data);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            IoUtil.copy((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    public static String buildVideoCutName(AssignSegmentVo param) {
        String original = param.getObjectKey();
        String name = FileUtil.getPrefix((String)FileUtil.getName((String)original));
        String file = "VIDEO_CUT/" + name + "_" + param.getTime() + "_" + param.getRange();
        return original.replace(name, file);
    }
}

