/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.controller;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.data.agora.AgoraAcquire;
import com.geoway.fczx.live.data.agora.AgoraConvert;
import com.geoway.fczx.live.data.agora.AgoraGoogleRes;
import com.geoway.fczx.live.data.agora.AgoraRecordStatus;
import com.geoway.fczx.live.data.agora.AgoraStartRecordRes;
import com.geoway.fczx.live.data.agora.AgoraStopRecordRes;
import com.geoway.fczx.live.thirdapi.agora.AgoraRestService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Api(tags={"\u58f0\u7f51\u6d4b\u8bd5\u63a5\u53e3"}, hidden=true)
@RestController
@RequestMapping(value={"/api/agora/v1"})
public class AgoraTestController {
    @Resource
    private AgoraRestService agoraRestService;

    @ApiOperation(value="\u83b7\u53d6\u9891\u9053\u5217\u8868")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/list/channel"}, produces={"application/json;charset=UTF-8"}, consumes={"application/json"})
    public ResponseEntity<BaseResponse> listChannel(@RequestBody(required=false) Map<String, Object> param) {
        Object res = this.agoraRestService.listChannel(param);
        return res == null ? BaseResponse.error((String)"\u9891\u9053\u5217\u8868\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e34\u65f6\u51ed\u8bc1", notes="uid: 0 \u63a8\u6d41\u4e3b\u64ad 1 \u5f55\u5236\u7528\u6237  >2\u89c2\u4f17")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/make/token"})
    public ResponseEntity<BaseResponse> makeToken(String channelName, Integer uid) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{channelName, uid})) {
            return BaseResponse.error((String)"channel\u6216uid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String res = this.agoraRestService.makeToken(channelName, uid.toString());
        return res == null ? BaseResponse.error((String)"\u83b7\u53d6\u4e34\u65f6Token\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u5236\u8d44\u6e90")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/create/channel"})
    public ResponseEntity<BaseResponse> acquireRecord(String channelName) {
        AgoraAcquire res = this.agoraRestService.acquireRecord(channelName);
        return res == null ? BaseResponse.error((String)"\u83b7\u53d6\u5f55\u5236\u8d44\u6e90\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u5f00\u59cb\u89c6\u9891\u5f55\u5236")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/start/record"})
    public ResponseEntity<BaseResponse> startRecord(String channelName, String resourceId) {
        AgoraStartRecordRes res;
        if (ObjectUtil.isEmpty((Object)channelName)) {
            return BaseResponse.error((String)"channel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)resourceId)) {
            AgoraAcquire acquire = this.agoraRestService.acquireRecord(channelName);
            resourceId = acquire.getResourceId();
        }
        return (res = this.agoraRestService.startRecord(channelName, resourceId, "handle")) == null ? BaseResponse.error((String)"\u5f00\u59cb\u89c6\u9891\u5f55\u5236\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u505c\u6b62\u89c6\u9891\u5f55\u5236")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/stop/record"})
    public ResponseEntity<BaseResponse> stopRecord(String channelName, String resourceId, String sid) {
        AgoraStopRecordRes res;
        if (ObjectUtil.isEmpty((Object)channelName) || ObjectUtil.isEmpty((Object)sid)) {
            return BaseResponse.error((String)"sid\u6216channel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)resourceId)) {
            AgoraAcquire acquire = this.agoraRestService.acquireRecord(channelName);
            resourceId = acquire.getResourceId();
        }
        return (res = this.agoraRestService.stopRecord(channelName, resourceId, sid)) == null ? BaseResponse.error((String)"\u505c\u6b62\u89c6\u9891\u5f55\u5236\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u5236\u72b6\u6001")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/record/status"})
    public ResponseEntity<BaseResponse> queryRecordState(String channelName, String resourceId, String sid) {
        AgoraRecordStatus res;
        if (ObjectUtil.isEmpty((Object)channelName) || ObjectUtil.isEmpty((Object)sid)) {
            return BaseResponse.error((String)"sid\u6216channel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)resourceId)) {
            AgoraAcquire acquire = this.agoraRestService.acquireRecord(channelName);
            resourceId = acquire.getResourceId();
        }
        return (res = this.agoraRestService.queryRecordState(resourceId, sid)) == null ? BaseResponse.error((String)"\u83b7\u53d6\u5f55\u5236\u72b6\u6001\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u521b\u5efa\u63a8\u6d41\u8f6c\u7801")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/convert"})
    public ResponseEntity<BaseResponse> createConvert(String channel, String rtmp) {
        if (ObjectUtil.isEmpty((Object)channel) || ObjectUtil.isEmpty((Object)rtmp)) {
            return BaseResponse.error((String)"rtmp\u6216channel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgoraGoogleRes res = this.agoraRestService.createConvert(channel, rtmp);
        return res == null ? BaseResponse.error((String)"\u521b\u5efa\u8f6c\u7801\u5668\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u83b7\u53d6\u9891\u9053\u8f6c\u7801")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/convert"})
    public ResponseEntity<BaseResponse> queryConverter(String channel) {
        if (ObjectUtil.isEmpty((Object)channel)) {
            return BaseResponse.error((String)"channel\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<AgoraConvert> res = this.agoraRestService.queryConverter(channel);
        return res == null ? BaseResponse.error((String)"\u83b7\u53d6\u9891\u9053\u8f6c\u7801\u5931\u8d25") : ObjectResponse.ok(res);
    }

    @ApiOperation(value="\u66f4\u65b0\u63a8\u6d41\u8f6c\u7801")
    @ApiOperationSupport(order=9)
    @PatchMapping(value={"/convert"})
    public ResponseEntity<BaseResponse> updateConvert(String convertId, String rtmp) {
        if (ObjectUtil.isEmpty((Object)convertId) || ObjectUtil.isEmpty((Object)rtmp)) {
            return BaseResponse.error((String)"rtmp\u6216convertId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgoraGoogleRes res = this.agoraRestService.updateConvert(convertId, rtmp);
        return res == null ? BaseResponse.error((String)"\u66f4\u65b0\u63a8\u6d41\u8f6c\u7801\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u66f4\u65b0\u63a8\u6d41\u8f6c\u7801")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/convert/patch"})
    public ResponseEntity<BaseResponse> updateConvert2(String convertId, String rtmp) {
        if (ObjectUtil.isEmpty((Object)convertId) || ObjectUtil.isEmpty((Object)rtmp)) {
            return BaseResponse.error((String)"rtmp\u6216convertId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgoraGoogleRes res = this.agoraRestService.updateConvert(convertId, rtmp);
        return res == null ? BaseResponse.error((String)"\u66f4\u65b0\u63a8\u6d41\u8f6c\u7801\u5931\u8d25") : ObjectResponse.ok((Object)res);
    }

    @ApiOperation(value="\u5220\u9664\u63a8\u6d41\u8f6c\u7801")
    @ApiOperationSupport(order=10)
    @DeleteMapping(value={"/convert"})
    public ResponseEntity<BaseResponse> removeConvert(String convertId) {
        if (ObjectUtil.isEmpty((Object)convertId)) {
            return BaseResponse.error((String)"convertId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean res = this.agoraRestService.removeConvert(convertId);
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u63a8\u6d41\u8f6c\u7801\u5931\u8d25");
    }

    @ApiOperation(value="\u5220\u9664\u63a8\u6d41\u8f6c\u7801")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/convert/delete"})
    public ResponseEntity<BaseResponse> removeConvert2(String convertId) {
        if (ObjectUtil.isEmpty((Object)convertId)) {
            return BaseResponse.error((String)"convertId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean res = this.agoraRestService.removeConvert(convertId);
        return res ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u63a8\u6d41\u8f6c\u7801\u5931\u8d25");
    }
}

