/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@ApiModel(value="\u98de\u673a\u5b9e\u65f6\u4f4d\u7f6e")
public class BaseTrackInfo {
    @ApiModelProperty(value="\u7ecf\u5ea6")
    private Double lng;
    @ApiModelProperty(value="\u7eac\u5ea6")
    private Double lat;
    @ApiModelProperty(value="\u9ad8\u7a0b")
    private Double elevation;
    @ApiModelProperty(value="\u76f8\u5bf9\u9ad8\u7a0b")
    private Double rth;
    @ApiModelProperty(value="\u4e0a\u62a5\u65f6\u95f4")
    private Long timestamp;
    @ApiModelProperty(value="\u65b9\u4f4d\u89d2\uff0c\u6b63\u5317\u662f0\uff0c\u987a\u65f6\u9488")
    private Double attitudeHead;
    @ApiModelProperty(value="\u4fef\u4ef0\u8f74\u89d2\u5ea6")
    private Double attitudePitch;
    @ApiModelProperty(value="\u6a2a\u6eda\u8f74\u89d2\u5ea6")
    private Double attitudeRoll;
    @ApiModelProperty(value="\u76f8\u673a\u4e91\u53f0\u89d2\uff0c\u76f8\u673a\u6c34\u5e73\u65f6\u662f0\uff0c\u5782\u76f4\u5411\u4e0b\u662f-90")
    private Double gimbalPitch;
    @ApiModelProperty(value="\u4e91\u53f0\u6a2a\u6eda\u8f74\u89d2\u5ea6")
    private Double gimbalRoll;
    @ApiModelProperty(value="\u4e91\u53f0\u504f\u822a\u8f74\u89d2\u5ea6")
    private Double gimbalYaw;
    @ApiModelProperty(value="\u53d8\u7126\u500d\u6570", hidden=true)
    private Double zoomFactor = 1.0;

    public Map<String, String> convertMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("lng", this.lng.toString());
        map.put("lat", this.lat.toString());
        map.put("elevation", this.elevation.toString());
        map.put("rth", this.rth.toString());
        map.put("timestamp", this.timestamp.toString());
        map.put("attitudeHead", this.attitudeHead.toString());
        map.put("attitudePitch", this.attitudePitch.toString());
        map.put("attitudeRoll", this.attitudeRoll.toString());
        map.put("gimbalPitch", this.gimbalPitch.toString());
        map.put("gimbalRoll", this.gimbalRoll.toString());
        map.put("gimbalYaw", this.gimbalYaw.toString());
        map.put("zoomFactor", this.zoomFactor.toString());
        return map;
    }

    public static BaseTrackInfo convertTrack(JSONObject json) {
        BaseTrackInfo data = new BaseTrackInfo();
        data.setLng(json.getDouble((Object)"lng"));
        data.setLat(json.getDouble((Object)"lat"));
        data.setElevation(json.getDouble((Object)"elevation"));
        data.setRth(json.getDouble((Object)"rth"));
        data.setTimestamp(json.getLong((Object)"timestamp"));
        data.setAttitudeHead(json.getDouble((Object)"attitudeHead"));
        if (ObjectUtil.isEmpty((Object)data.getAttitudeHead())) {
            data.setAttitudeHead(json.getDouble((Object)"attitudeHead".toLowerCase()));
        }
        data.setAttitudePitch(json.getDouble((Object)"attitudePitch"));
        if (ObjectUtil.isEmpty((Object)data.getAttitudePitch())) {
            data.setAttitudePitch(json.getDouble((Object)"attitudePitch".toLowerCase()));
        }
        data.setAttitudeRoll(json.getDouble((Object)"attitudeRoll"));
        if (ObjectUtil.isEmpty((Object)data.getAttitudeRoll())) {
            data.setAttitudeRoll(json.getDouble((Object)"attitudeRoll".toLowerCase()));
        }
        data.setGimbalPitch(json.getDouble((Object)"gimbalPitch"));
        if (ObjectUtil.isEmpty((Object)data.getGimbalPitch())) {
            data.setGimbalPitch(json.getDouble((Object)"gimbalPitch".toLowerCase()));
        }
        data.setGimbalRoll(json.getDouble((Object)"gimbalRoll"));
        if (ObjectUtil.isEmpty((Object)data.getGimbalRoll())) {
            data.setGimbalRoll(json.getDouble((Object)"gimbalRoll".toLowerCase()));
        }
        data.setGimbalYaw(json.getDouble((Object)"gimbalYaw"));
        if (ObjectUtil.isEmpty((Object)data.getGimbalYaw())) {
            data.setGimbalYaw(json.getDouble((Object)"gimbalYaw".toLowerCase()));
        }
        data.setZoomFactor(json.getDouble((Object)"zoomFactor"));
        if (ObjectUtil.isEmpty((Object)data.getGimbalYaw())) {
            data.setZoomFactor(json.getDouble((Object)"zoomFactor".toLowerCase()));
        }
        return data;
    }

    public static BaseTrackInfo buildTrack(Map<String, Object> exif, Date time) {
        if (exif.isEmpty()) {
            return null;
        }
        JSONObject json = new JSONObject(exif);
        BaseTrackInfo trackInfo = new BaseTrackInfo();
        trackInfo.setAttitudePitch(json.getDouble((Object)"drone-dji:FlightPitchDegree"));
        trackInfo.setAttitudeRoll(json.getDouble((Object)"drone-dji:FlightRollDegree"));
        trackInfo.setAttitudeHead(json.getDouble((Object)"drone-dji:FlightYawDegree"));
        trackInfo.setGimbalPitch(json.getDouble((Object)"drone-dji:GimbalPitchDegree"));
        trackInfo.setGimbalRoll(json.getDouble((Object)"drone-dji:GimbalRollDegree"));
        trackInfo.setElevation(json.getDouble((Object)"drone-dji:AbsoluteAltitude"));
        trackInfo.setGimbalYaw(json.getDouble((Object)"drone-dji:GimbalYawDegree"));
        trackInfo.setRth(json.getDouble((Object)"drone-dji:RelativeAltitude"));
        trackInfo.setZoomFactor(json.getDouble((Object)"Digital Zoom Ratio"));
        trackInfo.setLat(json.getDouble((Object)"drone-dji:GpsLatitude"));
        trackInfo.setLng(json.getDouble((Object)"drone-dji:GpsLongitude"));
        trackInfo.setTimestamp(time.getTime());
        return trackInfo;
    }

    public String buildDjiXmp() {
        return "<x:xmpmeta xmlns:x=\"adobe:ns:meta/\" x:xmptk=\"Adobe XMP Core 6.1.11\">  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">    <rdf:Description rdf:about=\"DJI Meta Data\" xmlns:drone-dji=\"http://www.dji.com/drone-dji/1.0/\">      <drone-dji:AbsoluteAltitude>" + this.elevation + "</drone-dji:AbsoluteAltitude>      <drone-dji:FlightPitchDegree>" + this.attitudePitch + "</drone-dji:FlightPitchDegree>      <drone-dji:FlightRollDegree>" + this.attitudeRoll + "</drone-dji:FlightRollDegree>      <drone-dji:FlightYawDegree>" + this.attitudeHead + "</drone-dji:FlightYawDegree>      <drone-dji:GimbalPitchDegree>" + this.gimbalPitch + "</drone-dji:GimbalPitchDegree>      <drone-dji:GimbalRollDegree>" + this.gimbalRoll + "</drone-dji:GimbalRollDegree>      <drone-dji:GimbalYawDegree>" + this.gimbalYaw + "</drone-dji:GimbalYawDegree>      <drone-dji:GpsLatitude>" + this.lat + "</drone-dji:GpsLatitude>      <drone-dji:GpsLongitude>" + this.lng + "</drone-dji:GpsLongitude>      <drone-dji:RelativeAltitude>" + this.rth + "</drone-dji:RelativeAltitude>    </rdf:Description>  </rdf:RDF></x:xmpmeta>";
    }

    public Double getLng() {
        return this.lng;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getElevation() {
        return this.elevation;
    }

    public Double getRth() {
        return this.rth;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Double getAttitudeHead() {
        return this.attitudeHead;
    }

    public Double getAttitudePitch() {
        return this.attitudePitch;
    }

    public Double getAttitudeRoll() {
        return this.attitudeRoll;
    }

    public Double getGimbalPitch() {
        return this.gimbalPitch;
    }

    public Double getGimbalRoll() {
        return this.gimbalRoll;
    }

    public Double getGimbalYaw() {
        return this.gimbalYaw;
    }

    public Double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public void setRth(Double rth) {
        this.rth = rth;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAttitudeHead(Double attitudeHead) {
        this.attitudeHead = attitudeHead;
    }

    public void setAttitudePitch(Double attitudePitch) {
        this.attitudePitch = attitudePitch;
    }

    public void setAttitudeRoll(Double attitudeRoll) {
        this.attitudeRoll = attitudeRoll;
    }

    public void setGimbalPitch(Double gimbalPitch) {
        this.gimbalPitch = gimbalPitch;
    }

    public void setGimbalRoll(Double gimbalRoll) {
        this.gimbalRoll = gimbalRoll;
    }

    public void setGimbalYaw(Double gimbalYaw) {
        this.gimbalYaw = gimbalYaw;
    }

    public void setZoomFactor(Double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTrackInfo)) {
            return false;
        }
        BaseTrackInfo other = (BaseTrackInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$lng = this.getLng();
        Double other$lng = other.getLng();
        if (this$lng == null ? other$lng != null : !((Object)this$lng).equals(other$lng)) {
            return false;
        }
        Double this$lat = this.getLat();
        Double other$lat = other.getLat();
        if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
            return false;
        }
        Double this$elevation = this.getElevation();
        Double other$elevation = other.getElevation();
        if (this$elevation == null ? other$elevation != null : !((Object)this$elevation).equals(other$elevation)) {
            return false;
        }
        Double this$rth = this.getRth();
        Double other$rth = other.getRth();
        if (this$rth == null ? other$rth != null : !((Object)this$rth).equals(other$rth)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Double this$attitudeHead = this.getAttitudeHead();
        Double other$attitudeHead = other.getAttitudeHead();
        if (this$attitudeHead == null ? other$attitudeHead != null : !((Object)this$attitudeHead).equals(other$attitudeHead)) {
            return false;
        }
        Double this$attitudePitch = this.getAttitudePitch();
        Double other$attitudePitch = other.getAttitudePitch();
        if (this$attitudePitch == null ? other$attitudePitch != null : !((Object)this$attitudePitch).equals(other$attitudePitch)) {
            return false;
        }
        Double this$attitudeRoll = this.getAttitudeRoll();
        Double other$attitudeRoll = other.getAttitudeRoll();
        if (this$attitudeRoll == null ? other$attitudeRoll != null : !((Object)this$attitudeRoll).equals(other$attitudeRoll)) {
            return false;
        }
        Double this$gimbalPitch = this.getGimbalPitch();
        Double other$gimbalPitch = other.getGimbalPitch();
        if (this$gimbalPitch == null ? other$gimbalPitch != null : !((Object)this$gimbalPitch).equals(other$gimbalPitch)) {
            return false;
        }
        Double this$gimbalRoll = this.getGimbalRoll();
        Double other$gimbalRoll = other.getGimbalRoll();
        if (this$gimbalRoll == null ? other$gimbalRoll != null : !((Object)this$gimbalRoll).equals(other$gimbalRoll)) {
            return false;
        }
        Double this$gimbalYaw = this.getGimbalYaw();
        Double other$gimbalYaw = other.getGimbalYaw();
        if (this$gimbalYaw == null ? other$gimbalYaw != null : !((Object)this$gimbalYaw).equals(other$gimbalYaw)) {
            return false;
        }
        Double this$zoomFactor = this.getZoomFactor();
        Double other$zoomFactor = other.getZoomFactor();
        return !(this$zoomFactor == null ? other$zoomFactor != null : !((Object)this$zoomFactor).equals(other$zoomFactor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseTrackInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $lng = this.getLng();
        result = result * 59 + ($lng == null ? 43 : ((Object)$lng).hashCode());
        Double $lat = this.getLat();
        result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
        Double $elevation = this.getElevation();
        result = result * 59 + ($elevation == null ? 43 : ((Object)$elevation).hashCode());
        Double $rth = this.getRth();
        result = result * 59 + ($rth == null ? 43 : ((Object)$rth).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Double $attitudeHead = this.getAttitudeHead();
        result = result * 59 + ($attitudeHead == null ? 43 : ((Object)$attitudeHead).hashCode());
        Double $attitudePitch = this.getAttitudePitch();
        result = result * 59 + ($attitudePitch == null ? 43 : ((Object)$attitudePitch).hashCode());
        Double $attitudeRoll = this.getAttitudeRoll();
        result = result * 59 + ($attitudeRoll == null ? 43 : ((Object)$attitudeRoll).hashCode());
        Double $gimbalPitch = this.getGimbalPitch();
        result = result * 59 + ($gimbalPitch == null ? 43 : ((Object)$gimbalPitch).hashCode());
        Double $gimbalRoll = this.getGimbalRoll();
        result = result * 59 + ($gimbalRoll == null ? 43 : ((Object)$gimbalRoll).hashCode());
        Double $gimbalYaw = this.getGimbalYaw();
        result = result * 59 + ($gimbalYaw == null ? 43 : ((Object)$gimbalYaw).hashCode());
        Double $zoomFactor = this.getZoomFactor();
        result = result * 59 + ($zoomFactor == null ? 43 : ((Object)$zoomFactor).hashCode());
        return result;
    }

    public String toString() {
        return "BaseTrackInfo(lng=" + this.getLng() + ", lat=" + this.getLat() + ", elevation=" + this.getElevation() + ", rth=" + this.getRth() + ", timestamp=" + this.getTimestamp() + ", attitudeHead=" + this.getAttitudeHead() + ", attitudePitch=" + this.getAttitudePitch() + ", attitudeRoll=" + this.getAttitudeRoll() + ", gimbalPitch=" + this.getGimbalPitch() + ", gimbalRoll=" + this.getGimbalRoll() + ", gimbalYaw=" + this.getGimbalYaw() + ", zoomFactor=" + this.getZoomFactor() + ")";
    }
}

