/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data.mqtt;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.constant.LiveConstant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Connector {
    private boolean enable = true;
    private Boolean bridge_mode;
    private Boolean clean_start;
    private String connect_timeout;
    private Integer enable_pipelining;
    private Map<String, String> headers;
    private String name;
    private String description;
    private String clientid_prefix;
    private Integer pool_size;
    private Integer max_inflight;
    private String keepalive;
    private String pool_type;
    private String type;
    private String url;
    private String server;
    private String username;
    private String password;
    private String proto_ver;
    private String retry_interval;
    private List<?> tags;
    private Map<String, Object> resource_opts;
    private Map<String, Object> ssl;

    public Connector(String name, String url) {
        this.name = name;
        this.url = url;
        this.type = "http";
        this.pool_size = 8;
        this.ssl = Connector.simpleSsl();
        this.pool_type = "random";
        this.connect_timeout = "15s";
        this.enable_pipelining = 100;
        this.headers = LiveConstant.HEADER;
        this.resource_opts = Connector.simpleOpts();
    }

    public Connector(String name, String url, String workspaceId) {
        this.name = name;
        this.url = url;
        this.type = "http";
        this.pool_size = 8;
        this.ssl = Connector.simpleSsl();
        this.pool_type = "random";
        this.connect_timeout = "15s";
        this.enable_pipelining = 100;
        this.headers = LiveConstant.HEADER;
        if (ObjectUtil.isNotEmpty((Object)workspaceId)) {
            this.headers.put("x_tenant_id", workspaceId);
        }
        this.resource_opts = Connector.simpleOpts();
    }

    public Connector(String name, String prefix, String server, String username, String password) {
        this.name = name;
        this.type = "mqtt";
        this.pool_size = 8;
        this.proto_ver = "v3";
        this.server = server;
        this.max_inflight = 32;
        this.username = username;
        this.password = password;
        this.keepalive = "300s";
        this.retry_interval = "15s";
        this.clientid_prefix = prefix;
        this.bridge_mode = false;
        this.clean_start = true;
        this.ssl = Connector.simpleMqttSsl();
        this.resource_opts = Connector.simpleMqttOpts();
    }

    private static Map<String, Object> simpleMqttSsl() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("enable", false);
        data.put("verify", "verify_peer");
        return data;
    }

    private static Map<String, Object> simpleMqttOpts() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("health_check_interval", "15s");
        data.put("start_timeout", "5s");
        return data;
    }

    private static Map<String, Object> simpleSsl() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("ciphers", Collections.EMPTY_LIST);
        data.put("depth", 10);
        data.put("enable", false);
        data.put("hibernate_after", "5s");
        data.put("log_level", "notice");
        data.put("reuse_sessions", true);
        data.put("secure_renegotiate", true);
        data.put("verify", "verify_none");
        data.put("versions", Arrays.asList("tlsv1.3", "tlsv1.2"));
        return data;
    }

    private static Map<String, Object> simpleOpts() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("health_check_interval", "15s");
        data.put("start_after_created", true);
        data.put("start_timeout", "5s");
        return data;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Boolean getBridge_mode() {
        return this.bridge_mode;
    }

    public Boolean getClean_start() {
        return this.clean_start;
    }

    public String getConnect_timeout() {
        return this.connect_timeout;
    }

    public Integer getEnable_pipelining() {
        return this.enable_pipelining;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClientid_prefix() {
        return this.clientid_prefix;
    }

    public Integer getPool_size() {
        return this.pool_size;
    }

    public Integer getMax_inflight() {
        return this.max_inflight;
    }

    public String getKeepalive() {
        return this.keepalive;
    }

    public String getPool_type() {
        return this.pool_type;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProto_ver() {
        return this.proto_ver;
    }

    public String getRetry_interval() {
        return this.retry_interval;
    }

    public List<?> getTags() {
        return this.tags;
    }

    public Map<String, Object> getResource_opts() {
        return this.resource_opts;
    }

    public Map<String, Object> getSsl() {
        return this.ssl;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setBridge_mode(Boolean bridge_mode) {
        this.bridge_mode = bridge_mode;
    }

    public void setClean_start(Boolean clean_start) {
        this.clean_start = clean_start;
    }

    public void setConnect_timeout(String connect_timeout) {
        this.connect_timeout = connect_timeout;
    }

    public void setEnable_pipelining(Integer enable_pipelining) {
        this.enable_pipelining = enable_pipelining;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClientid_prefix(String clientid_prefix) {
        this.clientid_prefix = clientid_prefix;
    }

    public void setPool_size(Integer pool_size) {
        this.pool_size = pool_size;
    }

    public void setMax_inflight(Integer max_inflight) {
        this.max_inflight = max_inflight;
    }

    public void setKeepalive(String keepalive) {
        this.keepalive = keepalive;
    }

    public void setPool_type(String pool_type) {
        this.pool_type = pool_type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProto_ver(String proto_ver) {
        this.proto_ver = proto_ver;
    }

    public void setRetry_interval(String retry_interval) {
        this.retry_interval = retry_interval;
    }

    public void setTags(List<?> tags) {
        this.tags = tags;
    }

    public void setResource_opts(Map<String, Object> resource_opts) {
        this.resource_opts = resource_opts;
    }

    public void setSsl(Map<String, Object> ssl) {
        this.ssl = ssl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        Boolean this$bridge_mode = this.getBridge_mode();
        Boolean other$bridge_mode = other.getBridge_mode();
        if (this$bridge_mode == null ? other$bridge_mode != null : !((Object)this$bridge_mode).equals(other$bridge_mode)) {
            return false;
        }
        Boolean this$clean_start = this.getClean_start();
        Boolean other$clean_start = other.getClean_start();
        if (this$clean_start == null ? other$clean_start != null : !((Object)this$clean_start).equals(other$clean_start)) {
            return false;
        }
        Integer this$enable_pipelining = this.getEnable_pipelining();
        Integer other$enable_pipelining = other.getEnable_pipelining();
        if (this$enable_pipelining == null ? other$enable_pipelining != null : !((Object)this$enable_pipelining).equals(other$enable_pipelining)) {
            return false;
        }
        Integer this$pool_size = this.getPool_size();
        Integer other$pool_size = other.getPool_size();
        if (this$pool_size == null ? other$pool_size != null : !((Object)this$pool_size).equals(other$pool_size)) {
            return false;
        }
        Integer this$max_inflight = this.getMax_inflight();
        Integer other$max_inflight = other.getMax_inflight();
        if (this$max_inflight == null ? other$max_inflight != null : !((Object)this$max_inflight).equals(other$max_inflight)) {
            return false;
        }
        String this$connect_timeout = this.getConnect_timeout();
        String other$connect_timeout = other.getConnect_timeout();
        if (this$connect_timeout == null ? other$connect_timeout != null : !this$connect_timeout.equals(other$connect_timeout)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$clientid_prefix = this.getClientid_prefix();
        String other$clientid_prefix = other.getClientid_prefix();
        if (this$clientid_prefix == null ? other$clientid_prefix != null : !this$clientid_prefix.equals(other$clientid_prefix)) {
            return false;
        }
        String this$keepalive = this.getKeepalive();
        String other$keepalive = other.getKeepalive();
        if (this$keepalive == null ? other$keepalive != null : !this$keepalive.equals(other$keepalive)) {
            return false;
        }
        String this$pool_type = this.getPool_type();
        String other$pool_type = other.getPool_type();
        if (this$pool_type == null ? other$pool_type != null : !this$pool_type.equals(other$pool_type)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$proto_ver = this.getProto_ver();
        String other$proto_ver = other.getProto_ver();
        if (this$proto_ver == null ? other$proto_ver != null : !this$proto_ver.equals(other$proto_ver)) {
            return false;
        }
        String this$retry_interval = this.getRetry_interval();
        String other$retry_interval = other.getRetry_interval();
        if (this$retry_interval == null ? other$retry_interval != null : !this$retry_interval.equals(other$retry_interval)) {
            return false;
        }
        List<?> this$tags = this.getTags();
        List<?> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, Object> this$resource_opts = this.getResource_opts();
        Map<String, Object> other$resource_opts = other.getResource_opts();
        if (this$resource_opts == null ? other$resource_opts != null : !((Object)this$resource_opts).equals(other$resource_opts)) {
            return false;
        }
        Map<String, Object> this$ssl = this.getSsl();
        Map<String, Object> other$ssl = other.getSsl();
        return !(this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Connector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        Boolean $bridge_mode = this.getBridge_mode();
        result = result * 59 + ($bridge_mode == null ? 43 : ((Object)$bridge_mode).hashCode());
        Boolean $clean_start = this.getClean_start();
        result = result * 59 + ($clean_start == null ? 43 : ((Object)$clean_start).hashCode());
        Integer $enable_pipelining = this.getEnable_pipelining();
        result = result * 59 + ($enable_pipelining == null ? 43 : ((Object)$enable_pipelining).hashCode());
        Integer $pool_size = this.getPool_size();
        result = result * 59 + ($pool_size == null ? 43 : ((Object)$pool_size).hashCode());
        Integer $max_inflight = this.getMax_inflight();
        result = result * 59 + ($max_inflight == null ? 43 : ((Object)$max_inflight).hashCode());
        String $connect_timeout = this.getConnect_timeout();
        result = result * 59 + ($connect_timeout == null ? 43 : $connect_timeout.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $clientid_prefix = this.getClientid_prefix();
        result = result * 59 + ($clientid_prefix == null ? 43 : $clientid_prefix.hashCode());
        String $keepalive = this.getKeepalive();
        result = result * 59 + ($keepalive == null ? 43 : $keepalive.hashCode());
        String $pool_type = this.getPool_type();
        result = result * 59 + ($pool_type == null ? 43 : $pool_type.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $proto_ver = this.getProto_ver();
        result = result * 59 + ($proto_ver == null ? 43 : $proto_ver.hashCode());
        String $retry_interval = this.getRetry_interval();
        result = result * 59 + ($retry_interval == null ? 43 : $retry_interval.hashCode());
        List<?> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, Object> $resource_opts = this.getResource_opts();
        result = result * 59 + ($resource_opts == null ? 43 : ((Object)$resource_opts).hashCode());
        Map<String, Object> $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        return result;
    }

    public String toString() {
        return "Connector(enable=" + this.isEnable() + ", bridge_mode=" + this.getBridge_mode() + ", clean_start=" + this.getClean_start() + ", connect_timeout=" + this.getConnect_timeout() + ", enable_pipelining=" + this.getEnable_pipelining() + ", headers=" + this.getHeaders() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", clientid_prefix=" + this.getClientid_prefix() + ", pool_size=" + this.getPool_size() + ", max_inflight=" + this.getMax_inflight() + ", keepalive=" + this.getKeepalive() + ", pool_type=" + this.getPool_type() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", server=" + this.getServer() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", proto_ver=" + this.getProto_ver() + ", retry_interval=" + this.getRetry_interval() + ", tags=" + this.getTags() + ", resource_opts=" + this.getResource_opts() + ", ssl=" + this.getSsl() + ")";
    }
}

