/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.service;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class LiveRecordRedisService {
    @Resource(name="liveRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    public void set(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public String getStr(String key) {
        String object = (String)this.redisTemplate.opsForValue().get((Object)key);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (String)objectMapper.readValue(object, String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("redis\u53cd\u5e8f\u5217\u5316\u9519\u8bef");
        }
    }

    public <T> T getBean(String key, Class<T> beanClass) {
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        return (T)JSONUtil.toBean((String)json, beanClass);
    }

    public void setWithExpire(String key, String value, long expire) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, expire, TimeUnit.SECONDS);
    }

    public boolean checkExist(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean del(String key) {
        return this.checkExist(key) && this.redisTemplate.delete((Object)key) != false;
    }

    public Set<String> getAllKeys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }
}

