/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.storage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.ThumbnailVo;
import com.geoway.fczx.live.data.WatermarkVo;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.ue.common.util.Path;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PartEtag;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsServiceHandler
extends AbstractStoreHandler<ObsObject> {
    private static final Logger log = LoggerFactory.getLogger(ObsServiceHandler.class);
    private ObsClient obsClient;
    private HuaweiObsProperties properties;

    public ObsServiceHandler(HuaweiObsProperties properties) {
        this.properties = properties;
        this.obsClient = new ObsClient(properties.getAccessKey(), properties.getSecretKey(), properties.getEndpoint());
    }

    private ObsClient buildClient() {
        return new ObsClient(this.properties.getAccessKey(), this.properties.getSecretKey(), this.properties.getEndpoint());
    }

    private ObsClient buildOutsideClient() {
        if (ObjectUtil.isNotEmpty((Object)this.properties.getOutside())) {
            return new ObsClient(this.properties.getAccessKey(), this.properties.getSecretKey(), this.properties.getOutside());
        }
        return this.buildClient();
    }

    private void shutdownClient(ObsClient client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getBucketDomain(String bucket) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public URL getObjectUrl(String bucket, String objectKey, Map<String, Object> param, String rename) {
        URL url = null;
        ObsClient buildClient = this.buildOutsideClient();
        try {
            TemporarySignatureRequest request = new TemporarySignatureRequest();
            if (ObjectUtil.isNotEmpty(param)) {
                request.setQueryParams(param);
            }
            if (ObjectUtil.isNotEmpty((Object)rename)) {
                request.getHeaders().put("response-content-disposition", "attachment;filename=\"" + URLEncoder.encode(rename, "UTF-8") + "\"");
            }
            request.setBucketName(bucket);
            request.setObjectKey(objectKey);
            request.setRequestDate(new Date());
            request.setExpires(this.properties.getExpire().longValue());
            TemporarySignatureResponse response = buildClient.createTemporarySignature(request);
            url = new URL(response.getSignedUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.shutdownClient(buildClient);
        }
        return url;
    }

    @Override
    public Boolean existObject(String bucket, String objectKey) {
        return this.obsClient.doesObjectExist(bucket, objectKey);
    }

    @Override
    public Boolean renameObject(String bucket, String objectKey, String newObjectKey) {
        try {
            this.obsClient.copyObject(bucket, objectKey, bucket, newObjectKey);
            this.obsClient.deleteObject(bucket, objectKey);
            return true;
        }
        catch (Exception e) {
            log.info("rename file [" + objectKey + "] failed : " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean deleteObject(String bucket, String objectKey) {
        return this.obsClient.deleteObject(bucket, objectKey).isDeleteMarker();
    }

    @Override
    public InputStream getObjectStream(String bucket, String objectKey) {
        return this.obsClient.getObject(bucket, objectKey).getObjectContent();
    }

    @Override
    public ObsObject getObject(String bucket, String objectKey) {
        return this.obsClient.getObject(bucket, objectKey);
    }

    @Override
    public Map<String, Object> getObjectMeta(ObsObject object) {
        return object.getMetadata().getAllMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getObjectMeta(String bucket, String objectKey) {
        ObsClient ossClient = this.buildClient();
        try {
            Map map = ossClient.getObject(bucket, objectKey).getMetadata().getAllMetadata();
            return map;
        }
        finally {
            this.shutdownClient(ossClient);
        }
    }

    @Override
    public void addObjectMeta(String bucket, String objectKey, Map<String, String> meta) {
        if (!this.obsClient.doesObjectExist(bucket, objectKey)) {
            throw new RuntimeException("The file not found.");
        }
        SetObjectMetadataRequest request = new SetObjectMetadataRequest();
        request.setObjectKey(objectKey);
        request.setBucketName(bucket);
        request.addAllUserMetadata(meta);
        this.obsClient.setObjectMetadata(request);
    }

    @Override
    public Long getObjectLength(ObsObject object) {
        return object.getMetadata().getContentLength();
    }

    @Override
    public InputStream getObjectInStream(ObsObject object) {
        return object.getObjectContent();
    }

    @Override
    public void putObject(String bucket, String objectKey, InputStream input) {
        if (this.obsClient.doesObjectExist(bucket, objectKey)) {
            throw new RuntimeException("The filename already exists.");
        }
        this.obsClient.putObject(bucket, objectKey, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putObjectBlock(final String bucket, final String objectKey, String localFile) {
        ObsClient client = this.buildClient();
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(20);
            final File largeFile = new File(localFile);
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucket, objectKey);
            InitiateMultipartUploadResult result = this.obsClient.initiateMultipartUpload(request);
            final String uploadId = result.getUploadId();
            log.info("UploadPart{}", (Object)("\t" + uploadId + "\n"));
            long partSize = 0x6400000L;
            long fileSize = largeFile.length();
            long partCount = fileSize % partSize == 0L ? fileSize / partSize : fileSize / partSize + 1L;
            final List partEtags = Collections.synchronizedList(new ArrayList());
            int i = 0;
            while ((long)i < partCount) {
                final long offset = (long)i * partSize;
                final long currPartSize = (long)(i + 1) == partCount ? fileSize - offset : partSize;
                final int partNumber = i + 1;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        UploadPartRequest uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(bucket);
                        uploadPartRequest.setObjectKey(objectKey);
                        uploadPartRequest.setUploadId(uploadId);
                        uploadPartRequest.setFile(largeFile);
                        uploadPartRequest.setPartSize(Long.valueOf(currPartSize));
                        uploadPartRequest.setOffset(offset);
                        uploadPartRequest.setPartNumber(partNumber);
                        try {
                            UploadPartResult uploadPartResult = ObsServiceHandler.this.obsClient.uploadPart(uploadPartRequest);
                            log.error("UploadPart{}", (Object)("Part#" + partNumber + " done\n"));
                            partEtags.add(new PartEtag(uploadPartResult.getEtag(), Integer.valueOf(uploadPartResult.getPartNumber())));
                        }
                        catch (ObsException e) {
                            log.error("UploadPart{}{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                });
                ++i;
            }
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                try {
                    executorService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error("UploadPart{}{}", (Object)e.getMessage(), (Object)e);
                }
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucket, objectKey, uploadId, partEtags);
            this.obsClient.completeMultipartUpload(completeMultipartUploadRequest);
        }
        finally {
            this.shutdownClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> uploadDir(String bucket, String relative, String filePath) {
        List files = FileUtil.loopFiles((String)filePath);
        if (ObjectUtil.isEmpty((Object)files)) {
            log.error("\u8be5\u76ee\u5f55{}\u4e0b\u672a\u627e\u5230\u6587\u4ef6", (Object)filePath);
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        ObsClient buildClient = this.buildClient();
        try {
            String filepath = filePath.replaceAll("\\\\", "/");
            for (File file : files) {
                HashMap<String, Object> fileMeta = new HashMap<String, Object>();
                String filename = file.getAbsolutePath().replaceAll("\\\\", "/");
                String relate = filename.replace(filepath + "/", "");
                String objectKey = Path.joinPath((String)"/", (String[])new String[]{relative, relate});
                buildClient.putObject(bucket, objectKey, file);
                fileMeta.put("objectKey", objectKey);
                fileMeta.put("fileSize", file.length());
                fileMeta.put("fileName", FileUtil.getName((String)objectKey));
                map.put(relate, fileMeta);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5939\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.shutdownClient(buildClient);
        }
        return map;
    }

    @Override
    public void putObjectWithMeta(String bucket, String objectKey, InputStream input, Map<String, String> meta) {
        if (this.obsClient.doesObjectExist(bucket, objectKey)) {
            throw new RuntimeException("The filename already exists.");
        }
        ObjectMetadata metadata = new ObjectMetadata();
        for (Map.Entry<String, String> m : meta.entrySet()) {
            metadata.addUserMetadata(m.getKey(), m.getValue());
        }
        this.obsClient.putObject(bucket, objectKey, input, metadata);
    }

    @Override
    public void getAttachThumb(String bucket, String objectKey, ThumbnailVo data, HttpServletResponse response) {
        int width = 400;
        int height = 300;
        if (ObjectUtil.isNotEmpty((Object)data.getWidth())) {
            width = Integer.parseInt(data.getWidth());
        }
        if (ObjectUtil.isNotEmpty((Object)data.getHeight())) {
            height = Integer.parseInt(data.getHeight());
        }
        try {
            boolean flag;
            Map<String, Object> map = FczxLiveTool.readAttachExif(this.getObjectStream(bucket, objectKey));
            boolean bl = flag = map != null && ObjectUtil.notEqual((Object)"pano", (Object)map.get("Windows XP Keywords"));
            if (flag) {
                InputStream thumb = this.getAttachThumb(bucket, objectKey, data);
                IOUtils.copy((InputStream)thumb, (OutputStream)response.getOutputStream());
            } else {
                Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).size(width, height).toOutputStream((OutputStream)response.getOutputStream());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38");
        }
    }

    @Override
    public void getWatermark(String bucket, String objectKey, WatermarkVo data, HttpServletResponse response) {
        try {
            InputStream water = this.getWatermark(bucket, objectKey, data);
            IOUtils.copy((InputStream)water, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6obs\u6c34\u5370\u56fe\u4fe1\u606f\u5931\u8d25:{}", (Object)e.toString());
        }
    }

    @Override
    public InputStream getAttachThumb(String bucket, String objectKey, ThumbnailVo data) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("x-image-process", data.convertArgs(true));
            URL url = this.getObjectUrl(bucket, objectKey, param, null);
            URLConnection conn = url.openConnection();
            return conn.getInputStream();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6obs\u7f29\u7565\u56fe\u4fe1\u606f\u5931\u8d25:{}", (Object)e.toString());
            return null;
        }
    }

    @Override
    public InputStream getWatermark(String bucket, String objectKey, WatermarkVo data) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("x-image-process", data.convertArgs());
            URL url = this.getObjectUrl(bucket, objectKey, param, null);
            URLConnection conn = url.openConnection();
            return conn.getInputStream();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6obs\u6c34\u5370\u56fe\u4fe1\u606f\u5931\u8d25:{}", (Object)e.toString());
            return null;
        }
    }

    @Override
    public Long getBucketStorage(String bucket) {
        try {
            BucketStorageInfo storageInfo = this.obsClient.getBucketStorageInfo(bucket);
            if (storageInfo != null) {
                return storageInfo.getSize();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u534e\u4e3a\u4e91obs\u5b58\u50a8\u6876{}\u7528\u91cf\u4fe1\u606f\u5931\u8d25", (Object)bucket);
        }
        return null;
    }

    @Override
    public Boolean createVideoShot(String bucket, String objectKey) {
        boolean flag = this.obsClient.doesObjectExist(bucket, objectKey);
        if (flag) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("x-image-process", "vframe/jpeg/offset/1");
            URL url = this.getObjectUrl(bucket, objectKey, param, null);
            try {
                System.out.println(url.toURI().toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return false;
    }

    @Override
    public Boolean createImageThumb(String bucket, String objectKey, String thumbName, Integer width, Integer height, Map<String, String> meta) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).size(width.intValue(), height.intValue()).toOutputStream((OutputStream)outputStream);
            if (ObjectUtil.isNotEmpty(meta)) {
                this.putObjectWithMeta(bucket, thumbName, new ByteArrayInputStream(outputStream.toByteArray()), meta);
            } else {
                this.putObject(bucket, thumbName, new ByteArrayInputStream(outputStream.toByteArray()));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void downloadFiles(String name, String bucket, List<String> files, String relative, HttpServletResponse response) throws Exception {
        ObsClient ossClient = this.buildClient();
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (String file : files) {
                int len;
                String filename = FileUtil.getName((String)file);
                if (ObjectUtil.isNotEmpty((Object)relative)) {
                    int len2 = file.indexOf(relative);
                    if (len2 < 0) {
                        len2 = 0;
                    }
                    filename = file.substring(len2 + 1 + relative.length());
                }
                InputStream inputStream = ossClient.getObject(bucket, file).getObjectContent();
                zipOutputStream.putNextEntry(new ZipEntry(filename));
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            this.shutdownClient(ossClient);
            log.debug("\u4e0b\u8f7d\u5b8c\u6210{}", files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecordVideo> listObjects(String bucket, String relative, List<String> suffix) {
        ArrayList<RecordVideo> datalist = new ArrayList<RecordVideo>();
        ObsClient ossClient = this.buildClient();
        try {
            ListObjectsRequest request = new ListObjectsRequest();
            request.setPrefix(relative);
            request.setBucketName(bucket);
            ObjectListing list = ossClient.listObjects(request);
            list.getObjects().forEach(item -> {
                RecordVideo video = new RecordVideo(item.getObjectKey(), item.getMetadata().getLastModified(), item.getMetadata().getContentLength());
                video.setMetadata(item.getMetadata().getAllMetadata());
                datalist.add(video);
            });
        }
        finally {
            this.shutdownClient(ossClient);
        }
        datalist.removeIf(data -> {
            String fmt = FileUtil.getSuffix((String)data.getObjectKey());
            String[] num = data.getObjectKey().split("/");
            String[] need = relative.split("/");
            return !ObjectUtil.contains((Object)suffix, (Object)fmt) || ObjectUtil.notEqual((Object)num.length, (Object)(need.length + 1));
        });
        for (RecordVideo data2 : datalist) {
            data2.setMetadata(this.getObject(bucket, data2.getObjectKey()).getMetadata().getAllMetadata());
        }
        return datalist.stream().sorted(Comparator.comparing(RecordVideo::getCreateTime)).collect(Collectors.toList());
    }

    @Override
    public void refreshClient() {
        this.shutdownClient(this.obsClient);
        this.obsClient = this.buildOutsideClient();
    }
}

