/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.stream;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.agora.AgoraAcquire;
import com.geoway.fczx.live.data.agora.AgoraCallback;
import com.geoway.fczx.live.data.agora.AgoraConvert;
import com.geoway.fczx.live.data.agora.AgoraGoogleRes;
import com.geoway.fczx.live.data.agora.AgoraStartRecordRes;
import com.geoway.fczx.live.data.agora.AgoraStopRecordRes;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.enmus.AgoraRecordMethod;
import com.geoway.fczx.live.enmus.LiveProvider;
import com.geoway.fczx.live.handler.AbstractLiveHandler;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.thirdapi.agora.AgoraRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.HttpClientErrorException;

public class AgoraLiveServiceHandler
extends AbstractLiveHandler<AgoraCallback> {
    private static final Logger log = LoggerFactory.getLogger(AgoraLiveServiceHandler.class);
    @Autowired
    private AgoraRestService agoraRestService;

    public AgoraLiveServiceHandler(AbstractStoreHandler storeService) {
        super(storeService);
    }

    @Override
    public OpRes<LiveRecordVo> startVideoRecord(YxRecordDto data) {
        if (ObjectUtil.isEmpty((Object)data.getAgoraRecordMethod())) {
            data.setAgoraRecordMethod(this.liveProperties.getAgoraRecordMethod().getMethod());
        }
        if (ObjectUtil.equal((Object)AgoraRecordMethod.local.getMethod(), (Object)data.getAgoraRecordMethod())) {
            return super.startVideoRecord(data);
        }
        if (ObjectUtil.equal((Object)AgoraRecordMethod.server.getMethod(), (Object)data.getAgoraRecordMethod())) {
            data.setAgoraRecordMethod(AgoraRecordMethod.local.getMethod());
            return this.agoraRestService.startRecordLocal(data);
        }
        data.setCid(data.getDroneSn());
        AgoraAcquire acquire = this.agoraRestService.acquireRecord(data.getCid());
        if (acquire == null) {
            return new OpRes("\u83b7\u53d6\u4e91\u7aef\u5f55\u5236\u8d44\u6e90\u5931\u8d25", null, false);
        }
        AgoraStartRecordRes res = this.agoraRestService.startRecord(data.getCid(), acquire.getResourceId(), data.getFilename().replaceAll("-", ""));
        if (res == null) {
            return new OpRes("\u4e0b\u53d1\u89c6\u9891\u5f55\u5236\u8bbe\u7f6e\u5931\u8d25", null, false);
        }
        LiveRecordVo liveParam = new LiveRecordVo(data.getFilename(), data.getDroneSn(), new Date());
        liveParam.setResId(acquire.getResourceId());
        liveParam.setSid(res.getSid());
        this.redisService.setWithExpire("record:" + data.getDroneSn(), JSONUtil.toJsonStr((Object)liveParam), this.liveProperties.getMaxPushDuration().intValue());
        return new OpRes(null, (Object)liveParam, true);
    }

    @Override
    public OpRes<Object> stopVideoRecord(YxRecordDto data) {
        String droneSn = data.getDroneSn();
        if (ObjectUtil.isEmpty((Object)data.getAgoraRecordMethod())) {
            data.setAgoraRecordMethod(this.liveProperties.getAgoraRecordMethod().getMethod());
        }
        if (!this.redisService.checkExist("record:" + droneSn)) {
            return new OpRes("\u672a\u627e\u5230\u5f55\u5236\u4fe1\u606f\u6216\u89c6\u9891\u5df2\u7ed3\u675f\u5f55\u5236", null, false);
        }
        if (ObjectUtil.equal((Object)AgoraRecordMethod.local.getMethod(), (Object)data.getAgoraRecordMethod())) {
            super.stopVideoRecord(data);
        } else {
            block9: {
                if (ObjectUtil.equal((Object)AgoraRecordMethod.server.getMethod(), (Object)data.getAgoraRecordMethod())) {
                    data.setAgoraRecordMethod(AgoraRecordMethod.local.getMethod());
                    return this.agoraRestService.stopRecordLocal(data);
                }
                LiveRecordVo record = this.redisService.getBean("record:" + droneSn, LiveRecordVo.class);
                if (record != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{record.getResId(), record.getSid()})) {
                    AgoraAcquire acquire = this.agoraRestService.acquireRecord(record.getAircraftSn());
                    try {
                        AgoraStopRecordRes res = this.agoraRestService.stopRecord(acquire.getCname(), record.getResId(), record.getSid());
                        if (res == null) {
                            return new OpRes("\u505c\u6b62\u4e91\u7aef\u5f55\u5236\u5931\u8d25", null, false);
                        }
                    }
                    catch (HttpClientErrorException e) {
                        if (ObjectUtil.equal((Object)e.getRawStatusCode(), (Object)404)) break block9;
                        return new OpRes("\u505c\u6b62\u4e91\u7aef\u5f55\u5236\u5f02\u5e38", null, false);
                    }
                }
            }
            this.redisService.del("record:" + droneSn);
        }
        return new OpRes("\u672a\u627e\u5230\u5f55\u5236\u4fe1\u606f\u6216\u89c6\u9891\u5df2\u7ed3\u675f\u5f55\u5236", null, true);
    }

    @Override
    public OpRes<JSONObject> saveVideoRecord(AgoraCallback data) {
        boolean flag;
        boolean bl = flag = data.getPayload() != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{data.getPayload(), data.getPayload().getDetails(), data.getPayload().getDetails().getFileList()});
        if (!flag) {
            return new OpRes("\u672a\u53d1\u73b0\u89c6\u9891\u539f\u4ef6\u4fe1\u606f", null, false);
        }
        JSONObject media = data.ConvertMediaFile(this.obsProperties.getObjectDirPrefix());
        return new OpRes(null, (Object)media, true);
    }

    @Override
    public YxChannel openAiLiveStream(String deviceSn, int duration, String params) {
        if (ObjectUtil.isEmpty((Object)this.liveProperties.getRtmpUrl())) {
            log.error("\u672a\u8bbe\u7f6ecdn\u6216rtmp\u63a8\u6d41\u5730\u5740");
            return null;
        }
        String key = "rtmpai:" + deviceSn;
        String channelName = "AI_" + deviceSn;
        if (this.redisService.checkExist(key) && this.redisService.getExpire(key) > 0L) {
            return this.redisService.getBean(key, YxChannel.class);
        }
        YxChannel channel = new YxChannel();
        channel.setProvider(LiveProvider.agora.getType());
        channel.setName(channelName);
        channel.setPushUrl(this.liveProperties.getRtmpUrl() + channelName);
        channel.setRtcPullUrl(this.liveProperties.getRtcUrl() + channelName);
        channel.setRtmpPullUrl(this.liveProperties.getRtmpUrl() + channelName);
        channel.setHttpPullUrl(this.liveProperties.getCdnUrl() + channelName + ".flv");
        if (!this.redisService.checkExist(key)) {
            this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), duration);
        }
        return channel;
    }

    @Override
    public OpRes<Boolean> removeAiLiveStream(String deviceSn) {
        if (ObjectUtil.isEmpty((Object)this.liveProperties.getRtmpUrl())) {
            return new OpRes("\u672a\u8bbe\u7f6ecdn\u6216rtmp\u63a8\u6d41\u5730\u5740", (Object)false, false);
        }
        List<AgoraConvert> data = this.agoraRestService.queryConverter(deviceSn);
        if (data == null) {
            return new OpRes("\u83b7\u53d6\u65c1\u8def\u63a8\u6d41\u8f6c\u7801\u5668\u5931\u8d25", (Object)false, false);
        }
        if (!data.isEmpty()) {
            log.info("\u65c1\u8def\u63a8\u6d41\u8f6c\u7801\u5668{}", data);
            data.forEach(e -> {
                if (ObjectUtil.isNotEmpty((Object)e.getConverterId())) {
                    new Thread(() -> this.agoraRestService.removeConvert(e.getConverterId())).start();
                }
                if (ObjectUtil.isNotEmpty((Object)e.getId())) {
                    new Thread(() -> this.agoraRestService.removeConvert(e.getId())).start();
                }
            });
        }
        return new OpRes(null, (Object)true, true);
    }

    @Override
    public List<RecordVideo> dealRecordTime(List<RecordVideo> list) {
        for (RecordVideo data : list) {
            boolean flag;
            HashMap<String, Object> map = (HashMap<String, Object>)data.getMetadata();
            boolean bl = flag = map != null && map.containsKey("startrecordtime");
            if (ObjectUtil.equal((Object)((Object)this.liveProperties.getAgoraRecordMethod()), (Object)((Object)AgoraRecordMethod.cloud))) {
                if (flag) continue;
                String m3u8 = data.getObjectKey().replace(".mp4", "");
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.storeService.getObjectStream(this.obsProperties.getBucket(), m3u8.substring(0, m3u8.lastIndexOf("_")) + ".m3u8")));
                float duration = 0.0f;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String ts;
                        if (ObjectUtil.isNotEmpty((Object)line) && line.contains(".ts")) {
                            String[] arr = line.replace(".ts", "").split("_");
                            if (arr.length != 3) continue;
                            if (map == null) {
                                map = new HashMap();
                            }
                            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                            if (!map.containsKey("startrecordtime")) {
                                map.put("startrecordtime", "" + DateUtil.offsetHour((Date)format.parse(arr[2]), (int)8).getTime());
                            }
                            data.setMetadata(map);
                            continue;
                        }
                        if (!ObjectUtil.isNotEmpty((Object)line) || !line.startsWith("#EXTINF:") || !ObjectUtil.isNotEmpty((Object)(ts = line.replace("#EXTINF:", "")))) continue;
                        duration += Float.parseFloat(ts);
                    }
                    map.put("duration", "" + duration * 1000.0f);
                    IoUtil.close((Closeable)reader);
                    continue;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    throw new RuntimeException("\u8bfb\u53d6\u8f68\u8ff9\u6587\u4ef6\u5931\u8d25");
                }
            }
            if (flag) continue;
            Map<String, Object> meta = this.storeService.getObjectMeta(this.obsProperties.getBucket(), data.getObjectKey());
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            for (String key : meta.keySet()) {
                map.put(key, meta.get(key));
            }
            data.setMetadata(map);
        }
        return list;
    }

    @Override
    public OpRes<String> getLivePullUrl(String deviceSn) {
        if (ObjectUtil.isEmpty((Object)this.liveProperties.getRtmpUrl())) {
            return new OpRes("\u672a\u8bbe\u7f6ecdn\u6216rtmp\u63a8\u6d41\u5730\u5740", null, false);
        }
        List<AgoraConvert> data = this.agoraRestService.queryConverter(deviceSn);
        if (data == null) {
            return new OpRes("\u83b7\u53d6\u65c1\u8def\u63a8\u6d41\u8f6c\u7801\u5668\u5931\u8d25", null, false);
        }
        if (!data.isEmpty()) {
            return new OpRes(null, (Object)data.get(0).getRtmpUrl(), true);
        }
        String pushUrl = this.liveProperties.getRtmpUrl() + deviceSn;
        AgoraGoogleRes res = this.agoraRestService.createConvert(deviceSn, pushUrl);
        if (res == null) {
            return new OpRes("\u521b\u5efa\u65c1\u8def\u63a8\u6d41\u8f6c\u7801\u5668\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)pushUrl, true);
    }
}

