/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.stream;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.srs.SrsRecordCallDto;
import com.geoway.fczx.live.data.srs.SrsRecordSetting;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.enmus.LiveProvider;
import com.geoway.fczx.live.handler.AbstractLiveHandler;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.thirdapi.srs.SrsRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SrsLiveServiceHandler
extends AbstractLiveHandler<SrsRecordCallDto> {
    private static final Logger log = LoggerFactory.getLogger(SrsLiveServiceHandler.class);
    @Autowired
    private SrsRestService srsRestService;

    public SrsLiveServiceHandler(AbstractStoreHandler abstractStoreHandler) {
        super(abstractStoreHandler);
    }

    @Override
    public OpRes<LiveRecordVo> startVideoRecord(YxRecordDto data) {
        if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableSecure())) {
            boolean flag;
            SrsRecordSetting setting = this.srsRestService.queryGlobs();
            if (!setting.isAll() && !(flag = this.srsRestService.resetRecord(true))) {
                return new OpRes("\u4e0b\u53d1\u89c6\u9891\u5f55\u5236\u8bbe\u7f6e\u5931\u8d25", null, false);
            }
            YxChannel live = this.redisService.getBean("rtmp:" + data.getDroneSn(), YxChannel.class);
            boolean flag2 = this.srsRestService.pullToPush(live.getHttpPullUrl(), data.getFilename());
            if (!flag2) {
                return new OpRes("SRS\u62c9\u6d41\u8f6c\u63a8\u5931\u8d25", null, false);
            }
            setting.getGlobs().add("/live/job/" + data.getFilename());
            flag2 = this.srsRestService.resetGlobs(setting.getGlobs());
            if (!flag2) {
                return new OpRes("SRS\u5f00\u59cb\u5f55\u5236\u5931\u8d25", null, false);
            }
        }
        LiveRecordVo liveParam = new LiveRecordVo(data.getFilename(), data.getDeviceSn(), new Date());
        this.redisService.setWithExpire("record:" + data.getDroneSn(), JSONUtil.toJsonStr((Object)liveParam), this.liveProperties.getMaxPushDuration().intValue());
        return new OpRes(null, (Object)liveParam, true);
    }

    @Override
    public OpRes<Object> stopVideoRecord(YxRecordDto data) {
        String droneSn = data.getDroneSn();
        if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableSecure())) {
            LiveRecordVo recordVo = this.redisService.getBean("record:" + droneSn, LiveRecordVo.class);
            if (recordVo != null && ObjectUtil.isNotEmpty((Object)recordVo.getBizId())) {
                SrsRecordSetting setting = this.srsRestService.queryGlobs();
                setting.getGlobs().remove("/live/job/" + recordVo.getBizId());
                boolean flag = this.srsRestService.resetGlobs(setting.getGlobs());
                if (flag) {
                    return new OpRes("", (Object)true, true);
                }
                return new OpRes("\u505c\u6b62\u5f55\u50cf\u5931\u8d25", null, false);
            }
            return new OpRes("\u8bbe\u5907\u672a\u5904\u4e8e\u5f55\u5236\u72b6\u6001", null, false);
        }
        this.redisService.del("record:" + droneSn);
        return new OpRes("\u505c\u6b62\u63a8\u6d41\u5373\u53ef\u505c\u6b62\u5f55\u5236", null, false);
    }

    @Override
    public OpRes<JSONObject> saveVideoRecord(SrsRecordCallDto data) {
        if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableSecure())) {
            if (ObjectUtil.notEqual((Object)data.getAction(), (Object)"on_record_end")) {
                return new OpRes("\u975e\u4efb\u52a1\u5f55\u5236\u89c6\u9891\u6d88\u606f\uff0c\u4e0d\u505a\u4fe1\u606f\u4fdd\u5b58", null, false);
            }
        } else if (!ObjectUtil.contains((Object)data.getParam(), (Object)"jobId=")) {
            return new OpRes("\u975e\u4efb\u52a1\u5f55\u5236\u89c6\u9891\uff0c\u4e0d\u505a\u4fe1\u606f\u4fdd\u5b58", null, false);
        }
        JSONObject media = null;
        URL url = null;
        try {
            if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableSecure())) {
                if (ObjectUtil.isEmpty((Object)data.getArtifact_url())) {
                    return new OpRes("\u672a\u53d1\u73b0\u89c6\u9891\u539f\u4ef6\u4fe1\u606f", null, false);
                }
                url = new URL(data.getArtifact_url());
                media = data.ConvertMediaFile(this.obsProperties.getObjectDirPrefix());
            } else {
                if (ObjectUtil.isEmpty((Object)data.getFile())) {
                    return new OpRes("\u672a\u53d1\u73b0\u89c6\u9891\u539f\u4ef6\u4fe1\u606f", null, false);
                }
                url = new URL(this.liveProperties.getServerUrl() + this.getRelativeFile(data.getFile()));
                media = data.ConvertMediaFileN(this.obsProperties.getObjectDirPrefix());
            }
            this.storeService.putObject(this.obsProperties.getBucket(), media.getStr((Object)"objectKey"), url.openStream());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u89c6\u9891\u81f3obs\u5931\u8d25", (Throwable)e);
            return new OpRes("\u4fdd\u5b58\u89c6\u9891\u81f3\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)media, true);
    }

    @Override
    public YxChannel openAiLiveStream(String deviceSn, int duration, String params) {
        String channelName = "AI_" + deviceSn;
        YxChannel channel = new YxChannel();
        channel.setProvider(LiveProvider.srs.getType());
        channel.setHttpPullUrl(this.liveProperties.getServerUrl() + channelName + ".flv");
        channel.setRtcPullUrl(this.liveProperties.getRtcUrl() + channelName);
        String key = "rtmpai:" + deviceSn;
        if (!this.redisService.checkExist(key)) {
            this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), duration);
        }
        return channel;
    }

    @Override
    public OpRes<Boolean> removeAiLiveStream(String deviceSn) {
        return new OpRes(null, (Object)true, true);
    }

    private String getRelativeFile(String file) {
        return file.substring(file.indexOf("live") + 5);
    }
}

