/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.analysis;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.data.gwai.GwAiMessage;
import com.geoway.fczx.live.data.property.AnalysisApiProperties;
import com.geoway.fczx.live.enmus.AnalysisModelType;
import com.geoway.fczx.live.enmus.AnalysisProvider;
import com.geoway.fczx.live.handler.AbstractAiEventHandler;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="geoway")
public class GwAiRabbitHandler {
    private static final Logger log = LoggerFactory.getLogger(GwAiRabbitHandler.class);
    @Autowired(required=false)
    private AbstractAiEventHandler aiEventHandler;
    @Resource
    private AnalysisApiProperties properties;

    @RabbitListener(containerFactory="analysisListenerContainerFactory", queues={"#{aiDynamicQueue.name}"})
    public void receiveAIMessage(String message) {
        try {
            GwAiMessage data;
            if (this.aiEventHandler != null && ObjectUtil.isNotEmpty((Object)message) && ObjectUtil.isNotEmpty((Object)(data = (GwAiMessage)JSONUtil.parseObj((String)message).toBean(GwAiMessage.class)))) {
                switch (data.getMsgType()) {
                    case clue: {
                        log.info("\u63a8\u9001\u7ebf\u7d22\u6d88\u606f{}", (Object)message);
                        this.handerClue(data);
                        break;
                    }
                    case stop: {
                        log.debug("\u63a8\u9001stop\u6d88\u606f{}", (Object)message);
                        this.handerStop(data);
                        break;
                    }
                    case start: {
                        log.debug("\u63a8\u9001start\u6d88\u606f{}", (Object)message);
                        this.handerStart(data);
                        break;
                    }
                    case finish: {
                        log.debug("\u63a8\u9001finish\u6d88\u606f{}", (Object)message);
                        this.handerFinish(data);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void handerClue(GwAiMessage message) {
        VideoAnalysis param;
        if (message != null && message.obtainBizJson() != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{(param = message.obtainBizJson()).getDockSn(), param.getJobId()}) && ObjectUtil.isAllNotEmpty((Object[])new Object[]{message.getTimeStr(), message.getLocation()})) {
            JSONObject data = new JSONObject((Object)message);
            boolean flag = message.getLocation().stream().anyMatch(e -> ObjectUtil.compare((Comparable)e.getProb(), (Comparable)this.properties.getMinProbOfBus()) >= 0);
            if (flag) {
                boolean file = true;
                String name = "\u89c6\u9891\u6587\u4ef6";
                if (ObjectUtil.isEmpty((Object)param.getFileUrl())) {
                    name = "\u5b9e\u65f6\u89c6\u9891\u6d41";
                    file = false;
                } else if (ObjectUtil.isNotEmpty((Object)param.getFileUrl())) {
                    message.setObjectKey(param.getFileUrl().substring(param.getFileUrl().indexOf("objectKey=") + 10));
                }
                if (ObjectUtil.isNotEmpty((Object)param.getStartRecordTime())) {
                    message.setDiscoveryTime(new Date(param.getStartRecordTime() + Long.parseLong(message.getTimeStr()) / 1000L));
                } else if (BooleanUtil.isFalse((Boolean)file)) {
                    message.setDiscoveryTime(new Date(Long.parseLong(message.getTimeStr())));
                } else {
                    log.debug("\u7ebf\u7d22\u8bc6\u522b\u65f6\u95f4\u65e0\u6cd5\u83b7\u53d6");
                    return;
                }
                AnalysisModelType model = AnalysisModelType.byName(message.getLocation().get(0).getType().replace("-", "_"));
                message.setIsFile(file);
                message.setTargets((Set)data.getByPath("location.type", Set.class));
                message.setVideoParam(param);
                message.setClueType(model.getDesc());
                message.setDescription(String.format("%s\u6293\u53d6%s%d\u6761\uff0c\u53ef\u80fd\u6027\u5206\u522b\u4e3a%s\u3002", name, model.getDesc(), message.getLocation().size(), data.getByPath("location.prob")));
                message.setProvider(AnalysisProvider.geoway);
                this.aiEventHandler.handResult(message);
            }
        }
    }

    private void handerStop(GwAiMessage message) {
    }

    private void handerStart(GwAiMessage message) {
    }

    private void handerFinish(GwAiMessage message) {
    }
}

