/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.analysis;

import cn.hutool.core.util.BooleanUtil;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.handler.AbstractAnalysisHandler;
import com.geoway.fczx.live.thirdapi.gwai.GwAiRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class GwAiServiceHandler
extends AbstractAnalysisHandler {
    private static final Logger log = LoggerFactory.getLogger(GwAiServiceHandler.class);
    @Autowired
    private GwAiRestService gwAiRestService;
    @Resource
    private Environment environment;

    @Override
    public List<?> getTaskList(String url, Map<String, Object> params) {
        OpRes<List<?>> list = this.gwAiRestService.videoAnalysisList(url, params);
        return list.isOpRes() ? (List)list.getData() : Collections.emptyList();
    }

    @Override
    public OpRes<Boolean> analysisVideoStart(String url, VideoAnalysis data) {
        return this.gwAiRestService.videoAnalysisPush(url, data.convertMap());
    }

    @Override
    public OpRes<Boolean> analysisVideoStop(String url, VideoAnalysis data) {
        if (BooleanUtil.isFalse((Boolean)((Boolean)this.environment.getProperty("com.geoway.fczx.debug.gwai-del-replace-stop", Boolean.class)))) {
            return this.gwAiRestService.videoAnalysisStop(url, data.buildAiId());
        }
        return this.gwAiRestService.videoAnalysisDelete(url, data.buildAiId());
    }
}

