/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.analysis;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.data.gwai.NbAiMessage;
import com.geoway.fczx.live.data.property.AnalysisApiProperties;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.enmus.AnalysisModelType;
import com.geoway.fczx.live.enmus.AnalysisProvider;
import com.geoway.fczx.live.handler.AbstractAiEventHandler;
import com.geoway.fczx.live.service.LiveRecordRedisService;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="internal")
public class NbAiRabbitHandler {
    private static final Logger log = LoggerFactory.getLogger(NbAiRabbitHandler.class);
    @Autowired(required=false)
    private AbstractAiEventHandler aiEventHandler;
    @Autowired
    private LiveRecordRedisService redisService;
    @Resource
    private AnalysisApiProperties properties;
    @Resource
    private LiveApiProperties liveProperties;

    @RabbitListener(containerFactory="analysisListenerContainerFactory", queues={"#{@environment.getProperty('com.geoway.fczx.analysis.ai-consumer-queue')}"})
    public void receiveAIMessage(String message) {
        try {
            NbAiMessage data;
            if (this.aiEventHandler != null && ObjectUtil.isNotEmpty((Object)message) && (data = (NbAiMessage)JSONUtil.parseObj((String)message).toBean(NbAiMessage.class)) != null) {
                switch (data.getMsgType()) {
                    case clue: {
                        log.info("\u63a8\u9001\u7ebf\u7d22\u6d88\u606f{}", (Object)message);
                        this.handerClue(data);
                        break;
                    }
                    case stop: {
                        log.debug("\u63a8\u9001stop\u6d88\u606f{}", (Object)message);
                        this.handerStop(data);
                        break;
                    }
                    case start: {
                        log.debug("\u63a8\u9001start\u6d88\u606f{}", (Object)message);
                        this.handerStart(data);
                        break;
                    }
                    case finish: {
                        log.debug("\u63a8\u9001finish\u6d88\u606f{}", (Object)message);
                        this.handerFinish(data);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void handerClue(NbAiMessage message) {
        VideoAnalysis param;
        if (message != null && message.getBizData() != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{(param = message.getBizData()).getDockSn(), param.getJobId()}) && ObjectUtil.isAllNotEmpty((Object[])new Object[]{message.getTime(), message.getClues()})) {
            JSONObject data = new JSONObject((Object)message);
            boolean flag = message.getClues().stream().anyMatch(e -> ObjectUtil.compare((Comparable)e.getProb(), (Comparable)this.properties.getMinProbOfBus()) >= 0);
            if (flag) {
                boolean file = true;
                String name = "\u89c6\u9891\u6587\u4ef6";
                if (ObjectUtil.isEmpty((Object)param.getFileUrl())) {
                    name = "\u5b9e\u65f6\u89c6\u9891\u6d41";
                    file = false;
                } else if (ObjectUtil.isNotEmpty((Object)param.getFileUrl())) {
                    message.setObjectKey(param.getFileUrl().substring(param.getFileUrl().indexOf("objectKey=") + 10));
                }
                if (ObjectUtil.isNotEmpty((Object)param.getStartRecordTime())) {
                    message.setDiscoveryTime(new Date(param.getStartRecordTime() + message.getTime() / 1000L));
                } else if (BooleanUtil.isFalse((Boolean)file)) {
                    message.setDiscoveryTime(new Date(message.getTime() / 1000L));
                } else {
                    log.debug("\u7ebf\u7d22\u8bc6\u522b\u65f6\u95f4\u65e0\u6cd5\u83b7\u53d6");
                    return;
                }
                AnalysisModelType model = AnalysisModelType.byName(message.getClues().get(0).getType().replace("-", "_"));
                message.setIsFile(file);
                message.setTargets((Set)data.getByPath("location.type", Set.class));
                message.setVideoParam(param);
                message.setClueType(model.getDesc());
                message.setDescription(String.format("%s\u6293\u53d6%s%d\u6761\uff0c\u53ef\u80fd\u6027\u5206\u522b\u4e3a%s\u3002", name, model.getDesc(), message.getClues().size(), data.getByPath("location.prob")));
                message.setProvider(AnalysisProvider.internal);
                this.aiEventHandler.handResult(message);
            }
        }
    }

    private void handerStop(NbAiMessage message) {
        this.handerFinish(message);
    }

    private void handerStart(NbAiMessage message) {
        String key;
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{message.getBizData(), message.getOutVideo()}) && this.redisService.checkExist(key = "rtmpai:" + message.getBizData().buildAiId())) {
            YxChannel channel = this.redisService.getBean(key, YxChannel.class);
            this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), this.liveProperties.getMaxPushDuration().intValue());
            this.aiEventHandler.handStartEvent(channel);
        }
    }

    private void handerFinish(NbAiMessage message) {
        String key;
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{message.getBizData(), message.getVideoPath()}) && this.redisService.checkExist(key = "rtmpai:" + message.getBizData().buildAiId())) {
            this.aiEventHandler.handStopEvent(message.getBizData());
        }
    }
}

