/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.analysis;

import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.VideoAnalysis;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.handler.AbstractAnalysisHandler;
import com.geoway.fczx.live.service.LiveRecordRedisService;
import com.geoway.fczx.live.thirdapi.gwai.NbAiRestService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NbAiServiceHandler
extends AbstractAnalysisHandler {
    private static final Logger log = LoggerFactory.getLogger(NbAiServiceHandler.class);
    private static final Integer WAIT_AI_RESULT = 180;
    @Autowired
    private NbAiRestService nbAiRestService;
    @Autowired
    private LiveRecordRedisService redisService;

    @Override
    public List<?> getTaskList(String url, Map<String, Object> params) {
        throw new RuntimeException("\u8be5\u65b9\u6cd5\u6682\u672a\u5b9e\u73b0");
    }

    @Override
    public OpRes<Boolean> analysisVideoStart(String url, VideoAnalysis data) {
        String key;
        OpRes<String> res = this.nbAiRestService.videoAnalysisPush(url, data.convertNbMap());
        if (res.isOpRes() && this.redisService.checkExist(key = "rtmpai:" + data.buildAiId())) {
            YxChannel channel = this.redisService.getBean(key, YxChannel.class);
            channel.setCid((String)res.getData());
            this.redisService.setWithExpire(key, JSONUtil.toJsonStr((Object)channel), WAIT_AI_RESULT.intValue());
        }
        return new OpRes(res.getErrorDesc(), (Object)res.isOpRes(), res.isOpRes());
    }

    @Override
    public OpRes<Boolean> analysisVideoStop(String url, VideoAnalysis data) {
        String key = "rtmpai:" + data.buildAiId();
        if (this.redisService.checkExist(key)) {
            YxChannel channel = this.redisService.getBean(key, YxChannel.class);
            return this.nbAiRestService.videoAnalysisStop(url, channel.getCid());
        }
        return new OpRes(null, (Object)true, true);
    }
}

