/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.enmus.AnalysisModelType;
import com.geoway.fczx.live.enmus.AnalysisProvider;
import com.geoway.fczx.live.util.FczxLiveTool;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@ApiModel(value="\u89c6\u9891\u5206\u6790\u53c2\u6570\u5b9e\u4f53\u7c7b")
public class VideoAnalysis {
    @ApiModelProperty(hidden=true)
    private String name;
    @ApiModelProperty(value="\u673a\u573a\u8bbe\u5907SN", required=true)
    private String dockSn;
    @ApiModelProperty(value="\u4efb\u52a1\u6807\u8bc6", required=true)
    private String jobId;
    @ApiModelProperty(value="\u98de\u673a\u8bbe\u5907SN")
    private String droneSn;
    @ApiModelProperty(value="\u89c6\u9891\u5f00\u59cb\u8bb0\u5f55\u65f6\u95f4")
    private Long startRecordTime;
    @ApiModelProperty(value="\u6587\u4ef6\u8bbf\u95ee\u8def\u5f84")
    private String fileUrl;
    @ApiModelProperty(value="\u6587\u4ef6\u540d\u79f0")
    private String fileName;
    @ApiModelProperty(value="\u89c6\u9891\u6d41\u5730\u5740", notes="\u53ef\u4ee5\u662f\u5728\u7ebf\u89c6\u9891\u6d41\u548c\u79bb\u7ebfmp4", hidden=true)
    private String ifsaddress;
    @ApiModelProperty(value="\u6d41\u5a92\u4f53\u670d\u52a1", hidden=true)
    private String ofsaddress;
    @ApiModelProperty(value="\u8bc6\u522b\u9608\u503c", hidden=true)
    private Float thresthod;
    @ApiModelProperty(value="\u76ee\u6807\u8bc6\u522b\u7c7b\u578b,\u76ee\u524d\u6709 water,gongchengche,gongchengche_ir,tuiduitu,smokefire\u7b49", notes="\u5fc5\u987b\u8ddfffmpeg\\bin\\config\\ Interpret_param.json\u4e2d\u7684\u4fdd\u6301\u4e00\u81f4", required=true)
    private List<String> target;
    @ApiModelProperty(value="\u662f\u5426\u4fdd\u5b58\u76ee\u6807\u8bc6\u522b\u51fa\u6765\u7684\u5e27\u4e3a\u56fe\u7247 0\u4e0d\u4fdd\u5b58 1\u4fdd\u5b58", hidden=true)
    private String saveKeyFrame = "1";
    @ApiModelProperty(value="\u8bbe\u7f6e\u4fdd\u5b58\u56fe\u7247\u7684\u65f6\u95f4\u95f4\u9694\uff0c\u9ed8\u8ba460", hidden=true)
    private String saveKeyFrameInterval;
    @ApiModelProperty(value="\u662f\u5426\u4fdd\u5b58\u5f55\u5236\u8fc7\u7a0b\uff0c0\u4e0d\u4fdd\u5b58\uff1b1\u4fdd\u5b58", hidden=true)
    private String saveVideo = "1";
    @ApiModelProperty(value="\u8bc6\u522b\u5e27\u8ddf\u5b9e\u65f6\u6d41\u76f8\u5dee\u591a\u5c11\u5e27\u4e4b\u5185\u8fdb\u884c\u7ed8\u5236", hidden=true)
    private String frameDrawIntervalMultiple;
    @ApiModelProperty(value="\u6bcf\u9694\u591a\u5c11\u5e27\u8fdb\u884c\u89e3\u8bd1\u5904\u7406", hidden=true)
    private String frameIntepretInterval;
    @ApiModelProperty(value="\u5728\u7ebf\u89c6\u9891\u6d41\u4e2d\u65ad\u591a\u4e45\u540e\u81ea\u52a8\u7ed3\u675f\u4efb\u52a1", hidden=true)
    private String interruptTimeout;
    @ApiModelProperty(value="\u4e1a\u52a1\u6269\u5c55\u6570\u636e", hidden=true)
    private String bizData;

    public VideoAnalysis(String dockSn, String jobId, List<String> target) {
        this.dockSn = dockSn;
        this.jobId = jobId;
        this.target = target;
    }

    public VideoAnalysis(String dockSn) {
        this.dockSn = dockSn;
    }

    public Map<String, Object> convertMap() {
        this.checkAiType(AnalysisProvider.geoway);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.buildAiId());
        map.put("ifsaddress", this.ifsaddress);
        map.put("ofsaddress", this.ofsaddress);
        ArrayList list = new ArrayList();
        this.target.forEach(type -> {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("target", AnalysisModelType.byName(type).getGeoway());
            list.add(item);
        });
        if (ObjectUtil.isEmpty((Object)this.bizData)) {
            this.bizData = new JSONObject((Object)this).toString();
        }
        map.put("bizData", this.bizData);
        map.put("save_video", this.saveVideo);
        map.put("save_key_frame", this.saveKeyFrame);
        map.put("interrupt_timeout", this.interruptTimeout);
        map.put("save_key_frame_interval", this.saveKeyFrameInterval);
        map.put("Interpret_param", list);
        return map;
    }

    public Map<String, Object> convertNbMap() {
        this.checkAiType(AnalysisProvider.internal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.buildAiId());
        map.put("in_video", this.ifsaddress);
        map.put("out_stream", this.ofsaddress);
        ArrayList list = new ArrayList();
        this.target.forEach(type -> {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("target", AnalysisModelType.byName(type).getInternal());
            list.add(item);
        });
        map.put("interpret_param", list);
        if (ObjectUtil.isEmpty((Object)this.bizData)) {
            this.bizData = new JSONObject((Object)this).toString();
        }
        map.put("biz_data", JSONUtil.parse((Object)this.bizData));
        if (ObjectUtil.isNotEmpty((Object)this.interruptTimeout)) {
            map.put("interrupt_timeout", Integer.parseInt(this.interruptTimeout));
        }
        if (ObjectUtil.isNotEmpty((Object)this.fileUrl)) {
            map.put("in_video", FczxLiveTool.getRedirectUrl(this.fileUrl));
        }
        map.put("save_video", ObjectUtil.equal((Object)this.saveVideo, (Object)"1"));
        map.put("save_key_frame", ObjectUtil.equal((Object)this.saveKeyFrame, (Object)"1"));
        map.put("in_type", ObjectUtil.isNotEmpty((Object)this.fileUrl) ? "mp4" : "rtmp");
        map.put("save_key_frame_interval", ObjectUtil.isNotEmpty((Object)this.saveKeyFrameInterval) ? Integer.parseInt(this.saveKeyFrameInterval) : 5);
        return map;
    }

    public Map<String, Object> converCmlcMap() {
        this.checkAiType(AnalysisProvider.cmlc);
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Map> request = new HashMap<String, Map>();
        HashMap<String, Object> reference = new HashMap<String, Object>();
        map.put("plugin_task_id", this.buildAiId());
        map.put("plugin_args", "116");
        map.put("request", request);
        request.put("input", MapUtil.builder().put((Object)"rtmp", (Object)this.ifsaddress).build());
        request.put("output", MapUtil.builder().put((Object)"rtmp", (Object)this.ofsaddress).build());
        request.put("reference", reference);
        reference.put("model", AnalysisModelType.byName(this.target.get(0)).getCmlc());
        reference.put("promt", AnalysisModelType.byName(this.target.get(0)).getCmlc());
        reference.put("thresthod", this.thresthod);
        reference.put("pixel_w", 1920);
        reference.put("pixel_h", 1440);
        reference.put("ai_type", Collections.singletonList("vehicle"));
        reference.put("plugin_args", 116);
        return map;
    }

    private void checkAiType(AnalysisProvider provider) {
        this.target.forEach(type -> {
            AnalysisModelType model = AnalysisModelType.byName(type);
            switch (provider) {
                case internal: {
                    if (!ObjectUtil.isEmpty((Object)model.getInternal())) break;
                    throw new RuntimeException("\u672a\u77e5AI\u8bc6\u522b\u7c7b\u578b");
                }
                case geoway: {
                    if (!ObjectUtil.isEmpty((Object)model.getGeoway())) break;
                    throw new RuntimeException("\u672a\u77e5AI\u8bc6\u522b\u7c7b\u578b");
                }
                case cmlc: {
                    if (ObjectUtil.isEmpty((Object)model.getCmlc())) {
                        throw new RuntimeException("\u672a\u77e5\u4e2d\u79fbAI\u8bc6\u522b\u7c7b\u578b");
                    }
                    if (!ObjectUtil.isNotEmpty((Object)this.fileUrl)) break;
                    throw new RuntimeException("\u4e2d\u79fbAI\u6682\u4e0d\u652f\u6301\u6587\u4ef6\u8bc6\u522b");
                }
            }
        });
    }

    public String buildAiKey() {
        LinkedList<String> name = new LinkedList<String>();
        if (ObjectUtil.isNotEmpty((Object)this.fileUrl)) {
            name.add(this.fileName);
            name.add(this.dockSn);
            name.add(this.jobId);
            return "file_" + SM3.create().digestHex(String.join((CharSequence)"", name));
        }
        name.add(this.dockSn);
        name.add(this.jobId);
        return "live_" + SM3.create().digestHex(String.join((CharSequence)"", name));
    }

    public String buildAiId() {
        LinkedList<String> name = new LinkedList<String>();
        if (ObjectUtil.isNotEmpty((Object)this.fileUrl)) {
            name.add(this.fileName);
            name.add(this.dockSn);
            name.add(this.jobId);
            return "file_" + SM3.create().digestHex(String.join((CharSequence)"", name));
        }
        return this.droneSn;
    }

    public String getName() {
        return this.name;
    }

    public String getDockSn() {
        return this.dockSn;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getDroneSn() {
        return this.droneSn;
    }

    public Long getStartRecordTime() {
        return this.startRecordTime;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getIfsaddress() {
        return this.ifsaddress;
    }

    public String getOfsaddress() {
        return this.ofsaddress;
    }

    public Float getThresthod() {
        return this.thresthod;
    }

    public List<String> getTarget() {
        return this.target;
    }

    public String getSaveKeyFrame() {
        return this.saveKeyFrame;
    }

    public String getSaveKeyFrameInterval() {
        return this.saveKeyFrameInterval;
    }

    public String getSaveVideo() {
        return this.saveVideo;
    }

    public String getFrameDrawIntervalMultiple() {
        return this.frameDrawIntervalMultiple;
    }

    public String getFrameIntepretInterval() {
        return this.frameIntepretInterval;
    }

    public String getInterruptTimeout() {
        return this.interruptTimeout;
    }

    public String getBizData() {
        return this.bizData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDockSn(String dockSn) {
        this.dockSn = dockSn;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setDroneSn(String droneSn) {
        this.droneSn = droneSn;
    }

    public void setStartRecordTime(Long startRecordTime) {
        this.startRecordTime = startRecordTime;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setIfsaddress(String ifsaddress) {
        this.ifsaddress = ifsaddress;
    }

    public void setOfsaddress(String ofsaddress) {
        this.ofsaddress = ofsaddress;
    }

    public void setThresthod(Float thresthod) {
        this.thresthod = thresthod;
    }

    public void setTarget(List<String> target) {
        this.target = target;
    }

    public void setSaveKeyFrame(String saveKeyFrame) {
        this.saveKeyFrame = saveKeyFrame;
    }

    public void setSaveKeyFrameInterval(String saveKeyFrameInterval) {
        this.saveKeyFrameInterval = saveKeyFrameInterval;
    }

    public void setSaveVideo(String saveVideo) {
        this.saveVideo = saveVideo;
    }

    public void setFrameDrawIntervalMultiple(String frameDrawIntervalMultiple) {
        this.frameDrawIntervalMultiple = frameDrawIntervalMultiple;
    }

    public void setFrameIntepretInterval(String frameIntepretInterval) {
        this.frameIntepretInterval = frameIntepretInterval;
    }

    public void setInterruptTimeout(String interruptTimeout) {
        this.interruptTimeout = interruptTimeout;
    }

    public void setBizData(String bizData) {
        this.bizData = bizData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoAnalysis)) {
            return false;
        }
        VideoAnalysis other = (VideoAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startRecordTime = this.getStartRecordTime();
        Long other$startRecordTime = other.getStartRecordTime();
        if (this$startRecordTime == null ? other$startRecordTime != null : !((Object)this$startRecordTime).equals(other$startRecordTime)) {
            return false;
        }
        Float this$thresthod = this.getThresthod();
        Float other$thresthod = other.getThresthod();
        if (this$thresthod == null ? other$thresthod != null : !((Object)this$thresthod).equals(other$thresthod)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$dockSn = this.getDockSn();
        String other$dockSn = other.getDockSn();
        if (this$dockSn == null ? other$dockSn != null : !this$dockSn.equals(other$dockSn)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$droneSn = this.getDroneSn();
        String other$droneSn = other.getDroneSn();
        if (this$droneSn == null ? other$droneSn != null : !this$droneSn.equals(other$droneSn)) {
            return false;
        }
        String this$fileUrl = this.getFileUrl();
        String other$fileUrl = other.getFileUrl();
        if (this$fileUrl == null ? other$fileUrl != null : !this$fileUrl.equals(other$fileUrl)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$ifsaddress = this.getIfsaddress();
        String other$ifsaddress = other.getIfsaddress();
        if (this$ifsaddress == null ? other$ifsaddress != null : !this$ifsaddress.equals(other$ifsaddress)) {
            return false;
        }
        String this$ofsaddress = this.getOfsaddress();
        String other$ofsaddress = other.getOfsaddress();
        if (this$ofsaddress == null ? other$ofsaddress != null : !this$ofsaddress.equals(other$ofsaddress)) {
            return false;
        }
        List<String> this$target = this.getTarget();
        List<String> other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        String this$saveKeyFrame = this.getSaveKeyFrame();
        String other$saveKeyFrame = other.getSaveKeyFrame();
        if (this$saveKeyFrame == null ? other$saveKeyFrame != null : !this$saveKeyFrame.equals(other$saveKeyFrame)) {
            return false;
        }
        String this$saveKeyFrameInterval = this.getSaveKeyFrameInterval();
        String other$saveKeyFrameInterval = other.getSaveKeyFrameInterval();
        if (this$saveKeyFrameInterval == null ? other$saveKeyFrameInterval != null : !this$saveKeyFrameInterval.equals(other$saveKeyFrameInterval)) {
            return false;
        }
        String this$saveVideo = this.getSaveVideo();
        String other$saveVideo = other.getSaveVideo();
        if (this$saveVideo == null ? other$saveVideo != null : !this$saveVideo.equals(other$saveVideo)) {
            return false;
        }
        String this$frameDrawIntervalMultiple = this.getFrameDrawIntervalMultiple();
        String other$frameDrawIntervalMultiple = other.getFrameDrawIntervalMultiple();
        if (this$frameDrawIntervalMultiple == null ? other$frameDrawIntervalMultiple != null : !this$frameDrawIntervalMultiple.equals(other$frameDrawIntervalMultiple)) {
            return false;
        }
        String this$frameIntepretInterval = this.getFrameIntepretInterval();
        String other$frameIntepretInterval = other.getFrameIntepretInterval();
        if (this$frameIntepretInterval == null ? other$frameIntepretInterval != null : !this$frameIntepretInterval.equals(other$frameIntepretInterval)) {
            return false;
        }
        String this$interruptTimeout = this.getInterruptTimeout();
        String other$interruptTimeout = other.getInterruptTimeout();
        if (this$interruptTimeout == null ? other$interruptTimeout != null : !this$interruptTimeout.equals(other$interruptTimeout)) {
            return false;
        }
        String this$bizData = this.getBizData();
        String other$bizData = other.getBizData();
        return !(this$bizData == null ? other$bizData != null : !this$bizData.equals(other$bizData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startRecordTime = this.getStartRecordTime();
        result = result * 59 + ($startRecordTime == null ? 43 : ((Object)$startRecordTime).hashCode());
        Float $thresthod = this.getThresthod();
        result = result * 59 + ($thresthod == null ? 43 : ((Object)$thresthod).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $dockSn = this.getDockSn();
        result = result * 59 + ($dockSn == null ? 43 : $dockSn.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $droneSn = this.getDroneSn();
        result = result * 59 + ($droneSn == null ? 43 : $droneSn.hashCode());
        String $fileUrl = this.getFileUrl();
        result = result * 59 + ($fileUrl == null ? 43 : $fileUrl.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $ifsaddress = this.getIfsaddress();
        result = result * 59 + ($ifsaddress == null ? 43 : $ifsaddress.hashCode());
        String $ofsaddress = this.getOfsaddress();
        result = result * 59 + ($ofsaddress == null ? 43 : $ofsaddress.hashCode());
        List<String> $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        String $saveKeyFrame = this.getSaveKeyFrame();
        result = result * 59 + ($saveKeyFrame == null ? 43 : $saveKeyFrame.hashCode());
        String $saveKeyFrameInterval = this.getSaveKeyFrameInterval();
        result = result * 59 + ($saveKeyFrameInterval == null ? 43 : $saveKeyFrameInterval.hashCode());
        String $saveVideo = this.getSaveVideo();
        result = result * 59 + ($saveVideo == null ? 43 : $saveVideo.hashCode());
        String $frameDrawIntervalMultiple = this.getFrameDrawIntervalMultiple();
        result = result * 59 + ($frameDrawIntervalMultiple == null ? 43 : $frameDrawIntervalMultiple.hashCode());
        String $frameIntepretInterval = this.getFrameIntepretInterval();
        result = result * 59 + ($frameIntepretInterval == null ? 43 : $frameIntepretInterval.hashCode());
        String $interruptTimeout = this.getInterruptTimeout();
        result = result * 59 + ($interruptTimeout == null ? 43 : $interruptTimeout.hashCode());
        String $bizData = this.getBizData();
        result = result * 59 + ($bizData == null ? 43 : $bizData.hashCode());
        return result;
    }

    public String toString() {
        return "VideoAnalysis(name=" + this.getName() + ", dockSn=" + this.getDockSn() + ", jobId=" + this.getJobId() + ", droneSn=" + this.getDroneSn() + ", startRecordTime=" + this.getStartRecordTime() + ", fileUrl=" + this.getFileUrl() + ", fileName=" + this.getFileName() + ", ifsaddress=" + this.getIfsaddress() + ", ofsaddress=" + this.getOfsaddress() + ", thresthod=" + this.getThresthod() + ", target=" + this.getTarget() + ", saveKeyFrame=" + this.getSaveKeyFrame() + ", saveKeyFrameInterval=" + this.getSaveKeyFrameInterval() + ", saveVideo=" + this.getSaveVideo() + ", frameDrawIntervalMultiple=" + this.getFrameDrawIntervalMultiple() + ", frameIntepretInterval=" + this.getFrameIntepretInterval() + ", interruptTimeout=" + this.getInterruptTimeout() + ", bizData=" + this.getBizData() + ")";
    }

    public VideoAnalysis() {
    }

    public VideoAnalysis(String name, String dockSn, String jobId, String droneSn, Long startRecordTime, String fileUrl, String fileName, String ifsaddress, String ofsaddress, Float thresthod, List<String> target, String saveKeyFrame, String saveKeyFrameInterval, String saveVideo, String frameDrawIntervalMultiple, String frameIntepretInterval, String interruptTimeout, String bizData) {
        this.name = name;
        this.dockSn = dockSn;
        this.jobId = jobId;
        this.droneSn = droneSn;
        this.startRecordTime = startRecordTime;
        this.fileUrl = fileUrl;
        this.fileName = fileName;
        this.ifsaddress = ifsaddress;
        this.ofsaddress = ofsaddress;
        this.thresthod = thresthod;
        this.target = target;
        this.saveKeyFrame = saveKeyFrame;
        this.saveKeyFrameInterval = saveKeyFrameInterval;
        this.saveVideo = saveVideo;
        this.frameDrawIntervalMultiple = frameDrawIntervalMultiple;
        this.frameIntepretInterval = frameIntepretInterval;
        this.interruptTimeout = interruptTimeout;
        this.bizData = bizData;
    }
}

