/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data.mqtt;

import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectorAction {
    private String name;
    private List<?> tags;
    private String connector;
    private String description;
    private String type;
    private boolean enable = true;
    private Map<String, Object> resource_opts;
    private Map<String, Object> parameters;

    private static Map<String, Object> simpleParams() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accept", "application/json");
        header.put("cache-control", "no-cache");
        header.put("connection", "keep-alive");
        header.put("keep-alive", "timeout=5");
        data.put("method", "post");
        data.put("headers", header);
        data.put("max_retries", 2);
        return data;
    }

    private static Map<String, Object> simpleParams(Map<String, String> header, String path, String body) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        data.put("body", body);
        data.put("method", "post");
        data.put("max_retries", 2);
        data.put("headers", header);
        return data;
    }

    private static Map<String, Object> simpleOpts() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("health_check_interval", "15s");
        data.put("inflight_window", 100);
        data.put("max_buffer_bytes", "256MB");
        data.put("query_mode", "async");
        data.put("request_ttl", "45s");
        data.put("worker_pool_size", 16);
        return data;
    }

    public ConnectorAction(String name) {
        this.name = name;
        this.type = "http";
        this.connector = name;
        this.resource_opts = ConnectorAction.simpleOpts();
        this.parameters = ConnectorAction.simpleParams();
    }

    public ConnectorAction(String connector, String name, String path, String body) {
        this.name = name;
        this.type = "http";
        this.connector = connector;
        this.resource_opts = ConnectorAction.simpleOpts();
        this.parameters = ConnectorAction.simpleParams(MapUtil.empty(), path, body);
    }

    public String getName() {
        return this.name;
    }

    public List<?> getTags() {
        return this.tags;
    }

    public String getConnector() {
        return this.connector;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Map<String, Object> getResource_opts() {
        return this.resource_opts;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTags(List<?> tags) {
        this.tags = tags;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setResource_opts(Map<String, Object> resource_opts) {
        this.resource_opts = resource_opts;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorAction)) {
            return false;
        }
        ConnectorAction other = (ConnectorAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<?> this$tags = this.getTags();
        List<?> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$connector = this.getConnector();
        String other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$resource_opts = this.getResource_opts();
        Map<String, Object> other$resource_opts = other.getResource_opts();
        if (this$resource_opts == null ? other$resource_opts != null : !((Object)this$resource_opts).equals(other$resource_opts)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectorAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<?> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $resource_opts = this.getResource_opts();
        result = result * 59 + ($resource_opts == null ? 43 : ((Object)$resource_opts).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectorAction(name=" + this.getName() + ", tags=" + this.getTags() + ", connector=" + this.getConnector() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", enable=" + this.isEnable() + ", resource_opts=" + this.getResource_opts() + ", parameters=" + this.getParameters() + ")";
    }
}

