/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.data.mqtt;

import cn.hutool.core.map.MapUtil;
import com.geoway.fczx.live.data.mqtt.FlowAction;
import com.geoway.fczx.live.data.mqtt.FlowActionArgs;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FlowRule {
    public static final String HTTP_HK_FMT = "http:%s";
    public static final String MQTT_HK_FMT = "mqtt:%s";
    public static final String CLUE_CREATE_FMT = "select payload from \"%s\"";
    public static final String JOUAV_ACCESS_FMT = "select * from \"$bridges/mqtt:%s\",\"$bridges/mqtt:%s\",\"$bridges/mqtt:%s\"";
    private String id;
    private String sql;
    private String name;
    private Boolean enable;
    private String description;
    private List<?> actions;

    public static FlowRule simpleFlowRule(String payload, String droneSn, String jobId, String ruleId) {
        FlowRule rule = new FlowRule();
        FlowAction action = new FlowAction();
        FlowActionArgs args = new FlowActionArgs();
        rule.setSql(String.format("SELECT\n payload.tid as tid,\n payload.timestamp as timestamp,\n payload.data.\"%s\".gimbal_pitch as gimbalPitch,\n payload.data.\"%s\".gimbal_roll as gimbalRoll,\n payload.data.\"%s\".gimbal_yaw as gimbalYaw,\n payload.data.\"%s\".zoom_factor as zoomFactor,\n payload.data.attitude_head as attitudeHead,\n payload.data.attitude_roll as attitudeRoll,\n payload.data.attitude_pitch as attitudePitch,\n payload.data.longitude as lng,\n payload.data.latitude as lat,\n payload.data.elevation as rth,\n payload.data.height as elevation\nFROM\n \"thing/product/%s/osd\"", payload, payload, payload, payload, droneSn));
        rule.setActions(Collections.singletonList(action));
        rule.setId(ruleId);
        rule.setDescription(jobId);
        action.setFunction("republish");
        action.setArgs(args);
        args.setQos(0);
        args.setPayload("");
        args.setUser_properties("");
        args.setTopic(String.format("real_location/%s", droneSn));
        return rule;
    }

    public static FlowRule simpleListenRule(String listenId, String tenant, String description, String format) {
        String sql = String.format(CLUE_CREATE_FMT, String.format(format, tenant));
        FlowRule rule = new FlowRule();
        rule.setSql(sql);
        rule.setId(listenId);
        rule.setDescription(description);
        rule.setActions(Collections.singletonList(String.format(HTTP_HK_FMT, listenId)));
        return rule;
    }

    public static FlowRule simpleListenRule(String listenId) {
        String sql = "SELECT replace(topic, '/mission/', '') as action, payload as data FROM \"/mission/+\"";
        FlowRule rule = new FlowRule();
        rule.setSql(sql);
        rule.setId(listenId);
        rule.setDescription("\u7eb5\u6a2a\u4efb\u52a1\u6d88\u606f\u8ba2\u9605");
        rule.setActions(Collections.singletonList(String.format(HTTP_HK_FMT, listenId)));
        return rule;
    }

    public static FlowRule simpleAccessRule(String accessId, String jo, String jopc, String mission) {
        String sql = String.format(JOUAV_ACCESS_FMT, jo, jopc, mission);
        HashMap<String, Object> action = new HashMap<String, Object>();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("mqtt_properties", MapUtil.empty());
        args.put("user_properties", "");
        args.put("payload", "${payload}");
        args.put("topic", "${topic}");
        args.put("retain", false);
        args.put("qos", 0);
        action.put("args", args);
        action.put("function", "republish");
        FlowRule rule = new FlowRule();
        rule.setSql(sql);
        rule.setId(accessId);
        rule.setDescription("\u7eb5\u6a2a\u8f6c\u63a5OSD\u8702\u5de2");
        rule.setActions(Collections.singletonList(action));
        return rule;
    }

    public static FlowRule simpleLogRule(String action, String name, String sql) {
        FlowRule rule = new FlowRule();
        rule.setSql(sql);
        rule.setId(name);
        rule.setActions(Collections.singletonList(String.format(HTTP_HK_FMT, action)));
        return rule;
    }

    public String getId() {
        return this.id;
    }

    public String getSql() {
        return this.sql;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getDescription() {
        return this.description;
    }

    public List<?> getActions() {
        return this.actions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setActions(List<?> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowRule)) {
            return false;
        }
        FlowRule other = (FlowRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<?> this$actions = this.getActions();
        List<?> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<?> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    public String toString() {
        return "FlowRule(id=" + this.getId() + ", sql=" + this.getSql() + ", name=" + this.getName() + ", enable=" + this.getEnable() + ", description=" + this.getDescription() + ", actions=" + this.getActions() + ")";
    }
}

