/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.rabbitmq;

import com.geoway.fczx.live.rabbitmq.AiDynamicQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"})
public class AnalysisRbDeclare {
    private static final Logger log = LoggerFactory.getLogger(AnalysisRbDeclare.class);

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="cmlc")
    public Queue zyaiQueue(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin) {
        Queue queue = new Queue("aiVideo", true);
        queue.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return queue;
    }

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="cmlc")
    public DirectExchange zyaiDirectExchange(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin) {
        DirectExchange exchange = new DirectExchange("aiVideoExchange", true, false);
        exchange.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return exchange;
    }

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="cmlc")
    public Binding zyaiExchangeBindingAndQueue(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin, Queue zyaiQueue, DirectExchange zyaiDirectExchange) {
        Binding binding = BindingBuilder.bind((Queue)zyaiQueue).to(zyaiDirectExchange).withQueueName();
        binding.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return binding;
    }

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="geoway")
    public Queue gwaiQueue(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin, AiDynamicQueue dynamicQueue) {
        log.info("Create and bind queue:{}", (Object)dynamicQueue.getName());
        Queue queue = new Queue(dynamicQueue.getName(), false, false, true);
        queue.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return queue;
    }

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="geoway")
    public DirectExchange gwaiDirectExchange(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin) {
        DirectExchange exchange = new DirectExchange("exchange.gwVideoStreamProcess", true, false);
        exchange.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return exchange;
    }

    @Bean
    @ConditionalOnProperty(prefix="com.geoway.fczx.analysis", name={"provider"}, havingValue="geoway")
    public Binding gwaiExchangeBindingAndQueue(@Qualifier(value="analysisRabbitAdmin") RabbitAdmin analysisRabbitAdmin, Queue gwaiQueue, DirectExchange gwaiDirectExchange) {
        Binding binding = BindingBuilder.bind((Queue)gwaiQueue).to(gwaiDirectExchange).with("gwVideoStreamProcess.warning");
        binding.setAdminsThatShouldDeclare(new Object[]{analysisRabbitAdmin});
        return binding;
    }
}

