/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.storage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.ThumbnailVo;
import com.geoway.fczx.live.data.WatermarkVo;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.ue.common.util.Path;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioServiceHandler
extends AbstractStoreHandler<StatObjectResponse> {
    private static final Logger log = LoggerFactory.getLogger(MinioServiceHandler.class);
    private MinioClient client;
    private HuaweiObsProperties properties;

    public MinioServiceHandler(HuaweiObsProperties properties) {
        this.properties = properties;
        this.client = MinioClient.builder().endpoint(properties.getEndpoint()).credentials(properties.getAccessKey(), properties.getSecretKey()).region(properties.getRegion()).build();
    }

    private AmazonS3 buildAwsClient(String endpoint) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.properties.getAccessKey(), this.properties.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, this.properties.getRegion()))).build();
    }

    private void shutdownClient(AmazonS3 client) {
        if (client != null) {
            client.shutdown();
        }
    }

    @Override
    public String getBucketDomain(String bucket) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getObjectUrl(String bucket, String objectKey, Map<String, Object> params, String rename) {
        AmazonS3 buildClient = this.buildAwsClient(this.properties.getOutside());
        try {
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucket, objectKey, HttpMethod.GET);
            request.setExpiration(new Date(System.currentTimeMillis() + this.properties.getExpire() * 1000L));
            for (Map.Entry<String, Object> param : params.entrySet()) {
                request.addRequestParameter(param.getKey(), (String)param.getValue());
            }
            if (ObjectUtil.isNotEmpty((Object)rename)) {
                ResponseHeaderOverrides headerOverrides = new ResponseHeaderOverrides();
                headerOverrides.setContentDisposition(String.format("attachment;filename=\"%s\"", rename));
                request.setResponseHeaders(headerOverrides);
            }
            URL uRL = buildClient.generatePresignedUrl(request);
            return uRL;
        }
        finally {
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public Boolean existObject(String bucket, String objectKey) {
        try {
            StatObjectResponse response = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
            return Objects.nonNull(response);
        }
        catch (Exception e) {
            log.debug("file [" + objectKey + "] does not exist : " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean renameObject(String bucket, String objectKey, String newObjectKey) {
        try {
            this.client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(bucket)).object(newObjectKey)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucket)).object(objectKey)).build()).build());
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
            return true;
        }
        catch (Exception e) {
            log.info("rename file [" + objectKey + "] failed : " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean deleteObject(String bucket, String objectKey) {
        try {
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
        }
        catch (Exception e) {
            log.error("Failed to delete file.", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteDir(String bucket, String prefix) {
        AmazonS3 buildClient = this.buildAwsClient(this.properties.getEndpoint());
        try {
            ObjectListing result;
            ListObjectsRequest request = new ListObjectsRequest();
            request.setPrefix(prefix);
            request.setBucketName(bucket);
            do {
                result = buildClient.listObjects(request);
                request.setMarker(result.getNextMarker());
            } while (result.isTruncated());
            List resultObjects = result.getObjectSummaries();
            if (ObjectUtil.isNotEmpty((Object)resultObjects)) {
                String[] objectKeys = (String[])resultObjects.stream().map(S3ObjectSummary::getKey).toArray();
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucket).withKeys(objectKeys);
                DeleteObjectsResult deleteObjectsResult = buildClient.deleteObjects(deleteObjectsRequest);
                log.debug("minio deleteObjectsResult:\n{}", (Object)deleteObjectsResult);
            }
        }
        finally {
            this.shutdownClient(buildClient);
        }
        return true;
    }

    @Override
    public InputStream getObjectStream(String bucket, String objectKey) {
        try {
            return this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
        }
        catch (Exception e) {
            log.error("Failed to get file.", (Throwable)e);
            return null;
        }
    }

    @Override
    public StatObjectResponse getObject(String bucket, String objectKey) {
        try {
            StatObjectResponse response = this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(objectKey)).build());
            return Objects.nonNull(response) ? response : null;
        }
        catch (Exception e) {
            log.error("Failed to obtain file exist info.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getObjectMeta(StatObjectResponse object) {
        if (ObjectUtil.isNotEmpty((Object)object)) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.putAll(object.userMetadata());
            return metadata;
        }
        return null;
    }

    @Override
    public Map<String, Object> getObjectMeta(String bucket, String objectKey) {
        return this.getObjectMeta(this.getObject(bucket, objectKey));
    }

    @Override
    public void addObjectMeta(String bucket, String objectKey, Map<String, String> meta) {
        if (!this.existObject(bucket, objectKey).booleanValue()) {
            throw new RuntimeException("The file not found.");
        }
        try {
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).userMetadata(meta)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Long getObjectLength(StatObjectResponse object) {
        if (ObjectUtil.isNotEmpty((Object)object)) {
            return object.size();
        }
        return 0L;
    }

    @Override
    public Long getBucketStorage(String bucket) {
        try {
            List list = this.client.listBuckets();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 0L;
    }

    @Override
    public InputStream getObjectInStream(StatObjectResponse object) {
        if (ObjectUtil.isNotEmpty((Object)object)) {
            return this.getObjectStream(object.bucket(), object.object());
        }
        return null;
    }

    @Override
    public void putObject(String bucket, String objectKey, InputStream input) {
        this.putObjectWithMeta(bucket, objectKey, input, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putObjectBlock(String bucket, String objectKey, String localFile) {
        AmazonS3 buildClient = this.buildAwsClient(this.properties.getEndpoint());
        TransferManager tm = TransferManagerBuilder.standard().withS3Client(buildClient).build();
        try {
            Upload upload = tm.upload(bucket, objectKey, new File(localFile));
            upload.waitForCompletion();
        }
        catch (Exception e) {
            log.error("put object block failed.", (Throwable)e);
        }
        finally {
            tm.shutdownNow();
            this.shutdownClient(buildClient);
        }
    }

    @Override
    public Map<String, Map<String, Object>> uploadDir(String bucket, String relative, String filePath) {
        List files = FileUtil.loopFiles((String)filePath);
        if (ObjectUtil.isEmpty((Object)files)) {
            log.error("\u8be5\u76ee\u5f55{}\u4e0b\u672a\u627e\u5230\u6587\u4ef6", (Object)filePath);
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        try {
            String filepath = filePath.replaceAll("\\\\", "/");
            for (File file : files) {
                HashMap<String, Object> fileMeta = new HashMap<String, Object>();
                String filename = file.getAbsolutePath().replaceAll("\\\\", "/");
                String relate = filename.replace(filepath + "/", "");
                String objectKey = Path.joinPath((String)"/", (String[])new String[]{relative, relate});
                this.putObject(bucket, objectKey, FileUtil.getInputStream((File)file));
                fileMeta.put("objectKey", objectKey);
                fileMeta.put("fileSize", file.length());
                fileMeta.put("fileName", FileUtil.getName((String)objectKey));
                map.put(relate, fileMeta);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5939\u5f02\u5e38", (Throwable)e);
        }
        return map;
    }

    @Override
    public void putObjectWithMeta(String bucket, String objectKey, InputStream input, Map<String, String> meta) {
        if (this.existObject(bucket, objectKey).booleanValue()) {
            throw new RuntimeException("The filename already exists.");
        }
        try {
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).userMetadata(meta)).stream(input, (long)input.available(), 0L).build());
        }
        catch (Exception e) {
            log.error("failed put file", (Throwable)e);
            throw new RuntimeException("failed put file");
        }
    }

    @Override
    public void getAttachThumb(String bucket, String objectKey, ThumbnailVo data, HttpServletResponse response) {
        int width = 400;
        int height = 300;
        if (ObjectUtil.isNotEmpty((Object)data.getWidth())) {
            width = Integer.parseInt(data.getWidth());
        }
        if (ObjectUtil.isNotEmpty((Object)data.getHeight())) {
            height = Integer.parseInt(data.getHeight());
        }
        try {
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).size(width, height).toOutputStream((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u7f29\u7565\u56fe\u5f02\u5e38");
        }
    }

    @Override
    public void getWatermark(String bucket, String objectKey, WatermarkVo data, HttpServletResponse response) {
        try {
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).watermark(data.convertParams()).toOutputStream((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6c34\u5370\u56fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u6c34\u5370\u56fe\u5f02\u5e38");
        }
    }

    @Override
    public InputStream getAttachThumb(String bucket, String objectKey, ThumbnailVo data) {
        log.error("minio\u6ca1\u6709\u5185\u7f6e\u7f29\u7565\u56fe\u65b9\u6cd5");
        return null;
    }

    @Override
    public InputStream getWatermark(String bucket, String objectKey, WatermarkVo data) {
        log.error("minio\u6ca1\u6709\u5185\u7f6e\u6c34\u5370\u56fe\u65b9\u6cd5");
        return null;
    }

    @Override
    public Boolean createVideoShot(String bucket, String objectKey) {
        return false;
    }

    @Override
    public Boolean createImageThumb(String bucket, String objectKey, String thumbName, Integer width, Integer height, Map<String, String> meta) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{this.getObjectStream(bucket, objectKey)}).size(width.intValue(), height.intValue()).toOutputStream((OutputStream)outputStream);
            if (ObjectUtil.isNotEmpty(meta)) {
                this.putObjectWithMeta(bucket, thumbName, new ByteArrayInputStream(outputStream.toByteArray()), meta);
            } else {
                this.putObject(bucket, thumbName, new ByteArrayInputStream(outputStream.toByteArray()));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void downloadFiles(String name, String bucket, List<String> files, String relative, HttpServletResponse response) throws Exception {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (String file : files) {
                int len;
                String filename = FileUtil.getName((String)file);
                if (ObjectUtil.isNotEmpty((Object)relative)) {
                    int len2 = file.indexOf(relative);
                    if (len2 < 0) {
                        len2 = 0;
                    }
                    filename = file.substring(len2 + 1 + relative.length());
                }
                GetObjectResponse inputStream = this.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(file)).build());
                zipOutputStream.putNextEntry(new ZipEntry(filename));
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            log.debug("\u4e0b\u8f7d\u5b8c\u6210{}", files);
        }
    }

    @Override
    public List<RecordVideo> listObjects(String bucket, String relative, List<String> suffix) {
        ArrayList<RecordVideo> datalist = new ArrayList<RecordVideo>();
        ListObjectsArgs params = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(relative.endsWith("/") ? relative : relative.concat("/")).recursive(false).build();
        Iterable list = this.client.listObjects(params);
        list.forEach(item -> {
            try {
                if (!((Item)item.get()).isDir()) {
                    RecordVideo video = new RecordVideo(((Item)item.get()).objectName(), Date.from(((Item)item.get()).lastModified().toInstant()), ((Item)item.get()).size());
                    video.setMetadata(this.getObject(bucket, ((Item)item.get()).objectName()).userMetadata());
                    datalist.add(video);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        datalist.removeIf(data -> {
            String fmt = FileUtil.getSuffix((String)data.getObjectKey());
            return !ObjectUtil.contains((Object)suffix, (Object)fmt);
        });
        return datalist.stream().sorted(Comparator.comparing(RecordVideo::getCreateTime)).collect(Collectors.toList());
    }

    @Override
    public void refreshClient() {
    }
}

