/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.stream;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.live.data.LiveRecordVo;
import com.geoway.fczx.live.data.RecordVideo;
import com.geoway.fczx.live.data.property.HuaweiObsProperties;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxRecordDto;
import com.geoway.fczx.live.enmus.LiveProvider;
import com.geoway.fczx.live.handler.AbstractStoreHandler;
import com.geoway.fczx.live.handler.LiveRecordThreadHandler;
import com.geoway.fczx.live.service.LiveRecordRedisService;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FfmpegLiveServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(FfmpegLiveServiceHandler.class);
    @Autowired
    protected LiveRecordRedisService redisService;
    @Autowired
    protected HuaweiObsProperties obsProperties;
    @Autowired
    protected LiveApiProperties liveProperties;
    protected AbstractStoreHandler storeService;

    public FfmpegLiveServiceHandler(AbstractStoreHandler storeService) {
        this.storeService = storeService;
    }

    public OpRes<LiveRecordVo> startVideoRecord(YxRecordDto data) {
        String flightId = data.getFilename();
        if (ObjectUtil.isEmpty((Object)flightId)) {
            flightId = IdUtil.randomUUID();
        }
        LiveRecordVo liveParam = new LiveRecordVo(flightId, data.getDroneSn(), new Date());
        String prefix = this.obsProperties.getObjectDirPrefix();
        if (this.redisService.checkExist("tenant_device:" + data.getDroneSn())) {
            prefix = this.redisService.get("tenant_device:" + data.getDroneSn()) + "/" + prefix;
        }
        LiveRecordThreadHandler liveRecord = new LiveRecordThreadHandler(liveParam, prefix, this.liveProperties.getMaxPushDuration());
        if (ObjectUtil.isNotEmpty((Object)data.getAgoraRecordMethod())) {
            liveRecord.setType(LiveProvider.agora.getType());
        }
        liveRecord.start();
        return new OpRes(null, (Object)liveParam, true);
    }

    public OpRes<Object> stopVideoRecord(YxRecordDto data) {
        String droneSn = data.getDroneSn();
        LiveRecordVo liveParam = this.redisService.getBean("record:" + droneSn, LiveRecordVo.class);
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{liveParam, liveParam.getBizId()})) {
            this.redisService.del("record:" + droneSn);
            String prefix = this.obsProperties.getObjectDirPrefix();
            if (this.redisService.checkExist("tenant_device:" + droneSn)) {
                prefix = this.redisService.get("tenant_device:" + data.getDroneSn()) + "/" + prefix;
            }
            String recordRes = FczxLiveTool.buildLiveRecordRes(liveParam.getBizId(), prefix, liveParam.getRecordTime());
            liveParam.setObsKey(recordRes);
            return new OpRes(null, (Object)liveParam, true);
        }
        this.redisService.del("record:" + droneSn);
        return new OpRes("\u8bbe\u5907\u5f53\u524d\u4e0d\u5904\u4e8e\u5f55\u5236\u72b6\u6001", null, false);
    }

    public List<RecordVideo> dealRecordTime(List<RecordVideo> list) {
        log.error("\u6682\u672a\u5b9e\u73b0");
        return null;
    }

    public OpRes<String> getLivePullUrl(String deviceSn, Boolean transcode) {
        if (!this.redisService.checkExist("rtmp:")) {
            return new OpRes("\u672a\u5f00\u542f\u76f4\u64ad\u63a8\u6d41\uff0c\u65e0\u6cd5\u83b7\u53d6\u62c9\u6d41\u5730\u5740", null, false);
        }
        YxChannel live = this.redisService.getBean("rtmp:" + deviceSn, YxChannel.class);
        return new OpRes(null, (Object)live.getRtmpPullUrl(), true);
    }
}

