/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.emqx;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.mqtt.Connector;
import com.geoway.fczx.live.data.mqtt.ConnectorAction;
import com.geoway.fczx.live.data.mqtt.FlowRule;
import com.geoway.fczx.live.data.mqtt.LogTrace;
import com.geoway.fczx.live.data.mqtt.Source;
import com.geoway.fczx.live.data.property.EmqxProperties;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class EmqxRestService {
    private static final Logger log = LoggerFactory.getLogger(EmqxRestService.class);
    @Resource
    private RestTemplate liveApiRest;
    private static final String getTokenUrl = "/api/v5/login";
    private static final String logTraceUrl = "/api/v5/trace";
    private static final String stopTraceUrl = "/api/v5/trace/{trace}/stop";
    private static final String removeTraceUrl = "/api/v5/trace/{trace}";
    private static final String removeClientUrl = "/api/v5/clients/{clientId}";
    private static final String createConnectUrl = "/api/v5/connectors";
    private static final String createActionUrl = "/api/v5/actions";
    private static final String createSourceUrl = "/api/v5/sources";
    private static final String createFlowRuleUrl = "/api/v5/rules";
    private static final String removeFlowRuleUrl = "/api/v5/rules/{ruleId}";
    private static final String removeActionUrl = "/api/v5/actions/{action}";
    private static final String removeSourceUrl = "/api/v5/sources/{source}";
    private static final String removeConnectUrl = "/api/v5/connectors/{connector}";
    private static final String downTraceUrl = "/api/v5/trace/{trace}/download";

    public String getToken(EmqxProperties properties) {
        String url = properties.getServerApiUrl().concat(getTokenUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> basic = new HashMap<String, String>();
        basic.put("username", properties.getServerApiKey());
        basic.put("password", properties.getServerApiSecret());
        HttpEntity params = new HttpEntity(basic, (MultiValueMap)headers);
        ResponseEntity res = this.liveApiRest.postForEntity(url, (Object)params, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u767b\u9646\u51ed\u8bc1\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"token");
    }

    public Object logTrace(EmqxProperties properties) {
        try {
            String url = properties.getServerApiUrl().concat(logTraceUrl);
            ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u83b7\u53d6\u65e5\u5fd7\u8ffd\u8e2a\u5217\u8868\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseArray((String)((String)res.getBody()));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65e5\u5fd7\u8ffd\u8e2a\u5217\u8868\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public List<FlowRule> existRuleById(EmqxProperties properties, String ruleId) {
        try {
            String url = properties.getServerApiUrl().concat("/api/v5/rules?like_id=" + ruleId);
            ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u67e5\u770b\u662f\u5426\u5b58\u5728\u89c4\u5219\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody())).getJSONArray((Object)"data").toList(FlowRule.class);
        }
        catch (Exception e) {
            log.error("\u67e5\u770b\u662f\u5426\u5b58\u5728\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object createRealRule(EmqxProperties properties, FlowRule rule) {
        try {
            String url = properties.getServerApiUrl().concat(createFlowRuleUrl);
            ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(rule, this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.CREATED)) {
                    return JSONUtil.parseObj((String)((String)res.getBody()));
                }
                log.error("\u521b\u5efa\u89c4\u5219\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody()));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String createConnect(EmqxProperties properties, Connector connector) {
        try {
            String url = properties.getServerApiUrl().concat(createConnectUrl);
            ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(connector, this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.CREATED)) {
                    return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
                }
                log.error("\u521b\u5efa\u8fde\u63a5\u5668\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8fde\u63a5\u5668\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object existConnect(EmqxProperties properties, String connectId) {
        try {
            String url = properties.getServerApiUrl().concat("/api/v5/connectors/" + connectId);
            ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u67e5\u770b\u662f\u5426\u5b58\u5728\u8fde\u63a5\u5668\u5931\u8d25{}", res.getBody());
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody()));
        }
        catch (HttpClientErrorException.NotFound e) {
            log.error("\u4e0d\u5b58\u5728{}\u8fde\u63a5\u5668", (Object)connectId);
            return null;
        }
        catch (Exception e) {
            log.error("\u67e5\u770b\u662f\u5426\u5b58\u5728\u8fde\u63a5\u5668\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String createSource(EmqxProperties properties, Source source) {
        try {
            String url = properties.getServerApiUrl().concat(createSourceUrl);
            ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(source, this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.CREATED)) {
                    return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
                }
                log.error("\u521b\u5efa\u8f93\u5165\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8f93\u5165\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String createAction(EmqxProperties properties, ConnectorAction connector) {
        try {
            String url = properties.getServerApiUrl().concat(createActionUrl);
            ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(connector, this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.CREATED)) {
                    return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
                }
                log.error("\u521b\u5efa\u52a8\u4f5c\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody())).getStr((Object)"status");
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u52a8\u4f5c\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object createTrace(EmqxProperties properties, LogTrace trace) {
        try {
            String url = properties.getServerApiUrl().concat(logTraceUrl);
            ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(trace, this.getToken(properties)), String.class, new Object[0]);
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.CONFLICT)) {
                    return true;
                }
                log.error("\u521b\u5efa\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody()));
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void removeFlowRule(EmqxProperties properties, String ruleId) {
        try {
            String url = properties.getServerApiUrl().concat(removeFlowRuleUrl);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{ruleId});
        }
        catch (HttpClientErrorException.NotFound e) {
            log.error("\u5220\u9664\u6d41\u7a0b\u89c4\u5219\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d41\u7a0b\u89c4\u5219\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeAction(EmqxProperties properties, String action) {
        try {
            String url = properties.getServerApiUrl().concat(removeActionUrl);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{action});
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u52a8\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeSource(EmqxProperties properties, String source) {
        try {
            String url = properties.getServerApiUrl().concat(removeSourceUrl).concat(source);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{source});
        }
        catch (HttpClientErrorException.NotFound e) {
            log.error("\u5220\u9664\u8f93\u5165\u6210\u529f", (Throwable)e);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8f93\u5165\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeConnect(EmqxProperties properties, String connector) {
        try {
            String url = properties.getServerApiUrl().concat(removeConnectUrl);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{connector});
        }
        catch (HttpClientErrorException.NotFound e) {
            log.debug("\u5220\u9664\u8fde\u63a5\u5668\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8fde\u63a5\u5668\u5931\u8d25", (Throwable)e);
        }
    }

    public Object stopTrace(EmqxProperties properties, String trace) {
        try {
            String url = properties.getServerApiUrl().concat(stopTraceUrl);
            ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.PUT, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{trace});
            boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u505c\u6b62\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((String)((String)res.getBody()));
        }
        catch (Exception e) {
            log.error("\u505c\u6b62\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u505c\u6b62\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25");
        }
    }

    public void removeTrace(EmqxProperties properties, String trace) {
        try {
            String url = properties.getServerApiUrl().concat(removeTraceUrl);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{trace});
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5220\u9664\u65e5\u5fd7\u8ffd\u8e2a\u5931\u8d25");
        }
    }

    public void removeClient(EmqxProperties properties, String clientId) {
        try {
            String url = properties.getServerApiUrl().concat(removeClientUrl);
            this.liveApiRest.exchange(url, HttpMethod.DELETE, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), String.class, new Object[]{clientId});
        }
        catch (Exception e) {
            log.error("\u5220\u9664MQTT\u5ba2\u6237\u7aef\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5220\u9664MQTT\u5ba2\u6237\u7aef\u5931\u8d25");
        }
    }

    public void downloadTrace(EmqxProperties properties, String trace, OutputStream out) {
        String url = properties.getServerApiUrl().concat(downTraceUrl);
        try {
            ResponseEntity res = this.liveApiRest.exchange(url, HttpMethod.GET, this.buildHttpParams(MapUtil.empty(), this.getToken(properties)), byte[].class, new Object[]{trace});
            IoUtil.write((OutputStream)out, (boolean)true, (byte[])((byte[])res.getBody()));
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u4e0b\u8f7d\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private <T> HttpEntity<T> buildHttpParams(T params, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + token);
        return new HttpEntity(params, (MultiValueMap)headers);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        return ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK);
    }
}

