/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.srs;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.srs.SrsRecordSetting;
import com.geoway.fczx.live.data.srs.SrsStreamFile;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.enmus.LiveProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SrsRestService {
    private static final Logger log = LoggerFactory.getLogger(SrsRestService.class);
    @Resource
    private RestTemplate liveApiRest;
    @Resource
    private LiveApiProperties liveProperties;
    private static final String channelListUrl = "terraform/v1/live/room/list";
    private static final String querySecretUrl = "terraform/v1/hooks/srs/secret/query";
    private static final String updateSecretUrl = "terraform/v1/hooks/srs/secret/update";
    private static final String submitStreamUrl = "terraform/v1/ffmpeg/camera/stream-url";
    private static final String sourceStreamUrl = "terraform/v1/ffmpeg/camera/source";
    private static final String secretStreamUrl = "terraform/v1/ffmpeg/camera/secret";
    private static final String queryGlobsUrl = "terraform/v1/hooks/record/query";
    private static final String resetGlobsUrl = "terraform/v1/hooks/record/globs";
    private static final String applyRecordUrl = "terraform/v1/hooks/record/apply";
    private static final String applyHookUrl = "terraform/v1/mgmt/hooks/apply";
    private static final String endRecordUrl = "terraform/v1/hooks/record/end";
    private static final String queryRecordUrl = "terraform/v1/hooks/record/files";

    public Object listRoom(Map<String, Object> params) {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(channelListUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u76f4\u64ad\u623f\u95f4\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.rooms");
    }

    public boolean pullToPush(String httpPullUrl, String filename) {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(submitStreamUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.of((Object)"url", (Object)httpPullUrl)), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u63d0\u4ea4\u89c6\u9891\u6e90\u5931\u8d25{}", (Object)res);
            return false;
        }
        SrsStreamFile file = (SrsStreamFile)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", SrsStreamFile.class);
        if (file != null) {
            file.setType("stream");
            file.setSize(0L);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("platform", "wx");
            params.put("files", Collections.singletonList(file));
            url = this.liveProperties.getServerUrl().replace("/live", "").concat(sourceStreamUrl);
            res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
            flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u63d0\u4ea4\u89c6\u9891\u6e90\u5931\u8d25{}", (Object)res);
                return false;
            }
            JSONArray files = (JSONArray)JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)JSONConfig.create().setIgnoreNullValue(true)).getByPath("data.files", JSONArray.class);
            url = this.liveProperties.getServerUrl().replace("/live", "").concat(secretStreamUrl);
            params.put("files", files);
            params.put("action", "update");
            params.put("custom", true);
            params.put("enabled", false);
            params.put("extraAudio", "");
            params.put("label", filename);
            params.put("server", this.liveProperties.getRtmpUrl() + "job/");
            params.put("secret", filename + "?secret=" + this.querySecret());
            res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
            flag = this.resolveResultBool((ResponseEntity<String>)res);
            if (!flag) {
                log.error("\u62c9\u6d41\u8f6c\u63a8\u76f4\u64ad\u95f4\u521b\u5efa\u5931\u8d25{}", (Object)res);
                return false;
            }
            return true;
        }
        return false;
    }

    public String querySecret() {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(querySecretUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.empty()), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u63a8\u6d41\u5bc6\u94a5\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (String)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data.publish", String.class);
    }

    public SrsRecordSetting queryGlobs() {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(queryGlobsUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.empty()), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u63a8\u6d41\u5bc6\u94a5\u5931\u8d25{}", (Object)res);
            return null;
        }
        return (SrsRecordSetting)JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data", SrsRecordSetting.class);
    }

    public boolean updateSecret(String secret) {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(updateSecretUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.of((Object)"secret", (Object)secret)), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u63a8\u6d41\u5bc6\u94a5\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public YxChannel createChannel(String deviceSn) {
        String push = deviceSn;
        if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableSecure())) {
            push = push + "?secret=" + this.querySecret();
        }
        YxChannel channel = new YxChannel();
        channel.setCid(deviceSn);
        channel.setProvider(LiveProvider.srs.getType());
        channel.setPushUrl(this.liveProperties.getRtmpUrl() + push);
        channel.setRtcPullUrl(this.liveProperties.getRtcUrl() + deviceSn);
        channel.setHttpPullUrl(this.liveProperties.getServerUrl() + deviceSn + ".flv");
        channel.setHlsPullUrl(this.liveProperties.getServerUrl() + deviceSn + ".m3u8");
        return channel;
    }

    public boolean resetGlobs(Set<String> globs) {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(resetGlobsUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.of((Object)"globs", globs)), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u91cd\u7f6e\u5f55\u5236\u89c4\u5219\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public boolean resetRecord(boolean all) {
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(applyRecordUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(MapUtil.of((Object)"all", (Object)all)), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u4fee\u6539\u5f55\u5236\u72b6\u6001\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public Object resetHook(String callback, String opaque, boolean all) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("target", callback);
        params.put("opaque", opaque);
        params.put("all", all);
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(applyHookUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u8bbe\u7f6e\u56de\u8c03\u5730\u5740\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public Object endRecord(String uuid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("uuid", uuid);
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(endRecordUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u505c\u6b62\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return false;
        }
        return true;
    }

    public Object queryRecordFile(String stream) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stream", stream);
        String url = this.liveProperties.getServerUrl().replace("/live", "").concat(queryRecordUrl);
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u505c\u6b62\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody())).get((Object)"data");
    }

    private HttpEntity<Map<String, Object>> buildHttpParams(Map<String, Object> params) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.liveProperties.getAppSecret());
        return new HttpEntity(params, (MultiValueMap)headers);
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 0;
        }
        return false;
    }
}

