/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.yidong;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.chinamobile.cmss.CloudVideoAPISDK;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yidong.YdChannel;
import com.geoway.fczx.live.data.yidong.YdResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class YdRestService {
    private static final Logger log = LoggerFactory.getLogger(YdRestService.class);
    @Resource
    private LiveApiProperties liveProperties;
    private final String channelListUrl = "/l2/live/listChannel";
    private final String createChannelUrl = "/l2/live/createChannel";
    private final String channelStatUrl = "/l2/live/getChannel";
    private final String removeChannelUrl = "/l2/live/removeChannel";
    private final String pushAddressUrl = "/l2/addr/getPushUrl";
    private final String pullAddressUrl = "/l2/addr/getPullUrl";
    private final String pullAddressV2Url = "/l2/addr/getPullUrlVerify";

    public JSONArray listChannel(Map<String, Object> params) {
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            String response = miGuAuthCenter.post(this.liveProperties.getServerUrl(), "/l2/live/listChannel", params);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u83b7\u53d6\u76f4\u64ad\u9891\u9053\u5217\u8868\u5931\u8d25{}", (Object)res);
                return null;
            }
            return (JSONArray)JSONUtil.parseObj((Object)res.getBody(), (boolean)true).getByPath("result.content", JSONArray.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u76f4\u64ad\u5217\u8868\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String createChannel(String deviceSn, int record) {
        DateTime expire = DateUtil.offset((Date)new Date(), (DateField)DateField.YEAR, (int)this.liveProperties.getYdLiveValidYear());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("record", record);
        params.put("title", deviceSn);
        params.put("subject", deviceSn);
        params.put("startTime", DateUtil.now().replaceAll("-0", "-"));
        params.put("endTime", DateUtil.formatDateTime((Date)expire).replaceAll("-0", "-"));
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            String response = miGuAuthCenter.post(this.liveProperties.getServerUrl(), "/l2/live/createChannel", params);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u521b\u5efa\u76f4\u64ad\u9891\u9053\u5931\u8d25{}", (Object)res);
                return null;
            }
            return (String)JSONUtil.parseObj((String)res.getBody()).getByPath("result.channelId", String.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u76f4\u64ad\u5217\u8868\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object channelStatus(String cid) {
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            YdChannel channel = new YdChannel();
            channel.setId(cid);
            String response = miGuAuthCenter.get(this.liveProperties.getServerUrl(), "/l2/live/getChannel", (Object)channel);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u83b7\u53d6\u9891\u9053\u8be6\u60c5\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((Object)res.getBody(), (boolean)true).get((Object)"result");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9891\u9053\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public boolean removeChannel(String cid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", cid);
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            String response = miGuAuthCenter.post(this.liveProperties.getServerUrl(), "/l2/live/removeChannel", params);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u5220\u9664\u9891\u9053\u5931\u8d25{}", (Object)res);
            }
            return flag;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9891\u9053\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public Object getPullAddress_v2(String cid) {
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            YdChannel channel = new YdChannel();
            channel.setChannel_id(cid);
            channel.setKeepTime(this.liveProperties.getMaxPushDuration());
            String response = miGuAuthCenter.get(this.liveProperties.getServerUrl(), "/l2/addr/getPullUrlVerify", (Object)channel);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u83b7\u53d6\u9632\u76d7\u62c9\u6d41\u5730\u5740\u5931\u8d25{}", (Object)res);
                return null;
            }
            return JSONUtil.parseObj((Object)res.getBody(), (boolean)true).get((Object)"result");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9632\u76d7\u62c9\u6d41\u5730\u5740\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public JSONArray getPushAddress(String cid) {
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            YdChannel channel = new YdChannel();
            channel.setChannel_id(cid);
            String response = miGuAuthCenter.get(this.liveProperties.getServerUrl(), "/l2/addr/getPushUrl", (Object)channel);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u83b7\u53d6\u9632\u76d7\u63a8\u6d41\u5730\u5740\u5931\u8d25{}", (Object)res);
                return null;
            }
            return (JSONArray)JSONUtil.parseObj((Object)res.getBody(), (boolean)true).getByPath("result.cameraList", JSONArray.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9632\u76d7\u63a8\u6d41\u5730\u5740\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public JSONArray getPullAddress(String cid) {
        CloudVideoAPISDK.MiGuAuthCenter miGuAuthCenter = CloudVideoAPISDK.initV2((int)Integer.parseInt(this.liveProperties.getUid()), (String)this.liveProperties.getAppKey(), (String)this.liveProperties.getAppSecret());
        try {
            YdChannel channel = new YdChannel();
            channel.setChannel_id(cid);
            channel.setKeepTime(this.liveProperties.getMaxPushDuration());
            String response = miGuAuthCenter.get(this.liveProperties.getServerUrl(), "/l2/addr/getPullUrl", (Object)channel);
            YdResponse res = (YdResponse)JSONUtil.toBean((String)response, YdResponse.class);
            boolean flag = this.resolveResultBool(res);
            if (!flag) {
                log.error("\u83b7\u53d6\u62c9\u6d41\u5730\u5740\u5931\u8d25{}", (Object)res);
                return null;
            }
            return (JSONArray)JSONUtil.parseObj((Object)res.getBody(), (boolean)true).getByPath("result.cameraList", JSONArray.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u62c9\u6d41\u5730\u5740\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private boolean resolveResultBool(YdResponse res) {
        if (ObjectUtil.equal((Object)res.getStatusCodeValue(), (Object)200) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return ObjectUtil.equal((Object)res.getYdResponseBody().getRet(), (Object)"0");
        }
        return false;
    }
}

