/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.thirdapi.yunxin;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.property.LiveApiProperties;
import com.geoway.fczx.live.data.yunxin.YxChannel;
import com.geoway.fczx.live.data.yunxin.YxVideoDto;
import com.geoway.fczx.live.util.CheckSumBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class YxRestService {
    private static final Logger log = LoggerFactory.getLogger(YxRestService.class);
    @Resource
    private RestTemplate liveApiRest;
    @Resource
    private LiveApiProperties liveProperties;
    private static final String NONCE = "GEOWAY";
    private static final String APP_KEY = "AppKey";
    private static final String NONCE_KEY = "Nonce";
    private static final String CHECK_SUM = "CheckSum";
    private static final String CUR_TIME = "CurTime";
    private final String againAddressUrl = "app/address";
    private final String channelListUrl = "app/channellist";
    private final String createChannelUrl = "app/channel/create";
    private final String removeChannelUrl = "app/channel/delete";
    private final String channelStatusUrl = "app/live/stream/status";
    private final String channelStatUrl = "app/channelstats";
    private final String recordCallUrl = "app/record/setcallback";
    private final String recordConfigUrl = "app/record/channel/updateConfig";
    private final String queryConfigUrl = "app/record/channel/getConfig";
    private final String startRecordUrl = "app/record/channel/start";
    private final String stopRecordUrl = "app/record/channel/stop";
    private final String setCallSignUrl = "app/callback/setSignKey";
    private final String videoListUrl = "app/videolist";
    private final String videoLifespanUrl = "app/record/getExpire";
    private final String videoInfoUrl = "app/vod/video/get";

    @PostConstruct
    public void initYxService() {
        if (BooleanUtil.isTrue((Boolean)this.liveProperties.getEnableRecordCallback())) {
            if (ObjectUtil.isNotEmpty((Object)this.liveProperties.getRecordCallbackUrl())) {
                this.setSignKey_v1();
                Object res = this.setCallback_v1();
                if (res == null) {
                    log.error("\u8bbe\u7f6e\u89c6\u9891\u5f55\u5236\u56de\u8c03\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u67d0\u4e9b\u529f\u80fd");
                }
            } else {
                throw new RuntimeException("\u5f55\u5236\u56de\u8c03\u5730\u5740\u4e0d\u80fd\u4e3anull");
            }
        }
    }

    public Object statusStream_v2(String deviceSn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("streamName", deviceSn);
        String url = this.liveProperties.getServerUrl().concat("app/live/stream/status");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u6d41\u72b6\u6001\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public YxChannel channelStatus_v1(String cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/channelstats");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u9891\u9053\u72b6\u6001\u5931\u8d25{}", (Object)res);
            return null;
        }
        JSONObject json = JSONUtil.parseObj((String)((String)res.getBody()));
        return (YxChannel)json.get((Object)"ret", YxChannel.class);
    }

    public Object listChannel_v1(Map<String, Object> params) {
        String url = this.liveProperties.getServerUrl().concat("app/channellist");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u76f4\u64ad\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public Object getVideoList_v1(String cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/videolist");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u5f55\u5236\u6587\u4ef6\u5217\u8868\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)JSONConfig.create().setIgnoreNullValue(true));
    }

    public Object getVideoLifespan_v1() {
        String url = this.liveProperties.getServerUrl().concat("app/record/getExpire");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(new HashMap<String, Object>()), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u5f55\u5236\u89c6\u9891\u5b58\u6d3b\u65f6\u95f4\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)JSONConfig.create().setIgnoreNullValue(true));
    }

    public YxVideoDto getVideoInfo_v1(String vid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("vid", vid);
        String url = this.liveProperties.getServerUrl().concat("app/vod/video/get");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u89c6\u9891\u6587\u4ef6\u4fe1\u606f\u5931\u8d25{}", (Object)res);
            return null;
        }
        JSONObject json = JSONUtil.parseObj((String)((String)res.getBody()));
        return (YxVideoDto)json.get((Object)"ret", YxVideoDto.class);
    }

    public YxChannel againAddress_v1(String cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/address");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u91cd\u65b0\u83b7\u53d6\u63a8\u6d41\u5730\u5740\u5931\u8d25{}", (Object)res);
            return null;
        }
        JSONObject json = JSONUtil.parseObj((String)((String)res.getBody()));
        return (YxChannel)json.get((Object)"ret", YxChannel.class);
    }

    public YxChannel createChannel_v1(String deviceSn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", deviceSn);
        params.put("type", 0);
        String url = this.liveProperties.getServerUrl().concat("app/channel/create");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u521b\u5efa\u76f4\u64ad\u9891\u9053\u5931\u8d25{}", (Object)res);
            return null;
        }
        JSONObject json = JSONUtil.parseObj((String)((String)res.getBody()));
        return (YxChannel)json.get((Object)"ret", YxChannel.class);
    }

    public Object removeChannel_v1(String cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/channel/delete");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u5220\u9664\u76f4\u64ad\u9891\u9053\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public Object recordConfig_v1(Map<String, Object> params) {
        String url = this.liveProperties.getServerUrl().concat("app/record/channel/updateConfig");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u8bbe\u7f6e\u5f55\u5236\u914d\u7f6e\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)new JSONConfig().setIgnoreNullValue(true));
    }

    public Object queryConfig_v1(String cid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/record/channel/getConfig");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u67e5\u8be2\u5f55\u5236\u914d\u7f6e\u5931\u8d25{}", (Object)res);
            return null;
        }
        log.error("\u67e5\u8be2\u5f55\u5236\u914d\u7f6e\u5931\u8d25{}", (Object)res);
        return JSONUtil.parseObj((Object)res.getBody(), (JSONConfig)JSONConfig.create().setIgnoreNullValue(true));
    }

    public Object startRecord_v1(String cid) {
        log.debug("\u5f00\u542f\u901a\u9053{}\u76f4\u64ad\u4e2d\u5f55\u5236", (Object)cid);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/record/channel/start");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u5f00\u542f\u76f4\u64ad\u4e2d\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public Object stopRecord_v1(String cid) {
        log.debug("\u5173\u95ed\u901a\u9053{}\u76f4\u64ad\u4e2d\u5f55\u5236", (Object)cid);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        String url = this.liveProperties.getServerUrl().concat("app/record/channel/stop");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\u7ed3\u675f\u76f4\u64ad\u4e2d\u5f55\u5236\u5931\u8d25{}", (Object)res);
            return null;
        }
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public Object setSignKey_v1() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("signKey", this.liveProperties.getCallSignKey());
        String url = this.liveProperties.getServerUrl().concat("app/callback/setSignKey");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\n\t{}\n\t\u8bbe\u7f6e\u56de\u8c03\u7684\u52a0\u7b7e\u79d8\u94a5\u5931\u8d25{}", (Object)url, (Object)res);
            return null;
        }
        log.info("\n\t{}\n\t\u8bbe\u7f6e\u56de\u8c03\u7684\u52a0\u7b7e\u79d8\u94a5\u6210\u529f{}", (Object)url, (Object)res);
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    public Object setCallback_v1() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("recordClk", this.liveProperties.getRecordCallbackUrl());
        String url = this.liveProperties.getServerUrl().concat("app/record/setcallback");
        ResponseEntity res = this.liveApiRest.postForEntity(url, this.buildHttpParams(params), String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (!flag) {
            log.error("\n\t{}\n\t\u8bbe\u7f6e\u89c6\u9891\u5f55\u5236\u56de\u8c03\u5730\u5740\u5931\u8d25{}", (Object)url, (Object)res);
            return null;
        }
        log.info("\n\t{}\n\t\u8bbe\u7f6e\u89c6\u9891\u5f55\u5236\u56de\u8c03\u5730\u5740\u6210\u529f{}", (Object)url, (Object)res);
        return JSONUtil.parseObj((String)((String)res.getBody()));
    }

    private HttpEntity<Map<String, Object>> buildHttpParams(Map<String, Object> params) {
        return new HttpEntity(params, (MultiValueMap)this.buildHttpHeaders());
    }

    private HttpHeaders buildHttpHeaders() {
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        String checkSum = CheckSumBuilder.getCheckSum(this.liveProperties.getAppSecret(), NONCE, curTime);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(NONCE_KEY, NONCE);
        headers.set(CUR_TIME, curTime);
        headers.set(CHECK_SUM, checkSum);
        headers.set(APP_KEY, this.liveProperties.getAppKey());
        return headers;
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 200;
        }
        return false;
    }
}

