/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.live.util;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.IoUtil;
import com.geoway.fczx.live.service.LiveRecordFlagService;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FfmpegTool {
    private static final Logger log = LoggerFactory.getLogger(FfmpegTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream obtainVideoCover(InputStream stream, Map<String, String> metadata) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FfmpegTool.obtainVideoCover(stream, outputStream, metadata);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IoUtil.close((Closeable)stream);
        }
    }

    public static void cutVideoSegment(int beginSecond, int endSecond, String input, String output) {
        FFmpegFrameGrabber grabber = null;
        FFmpegFrameRecorder recorder = null;
        try {
            Frame frame;
            grabber = new FFmpegFrameGrabber(input);
            grabber.start();
            grabber.setVideoFrameNumber((int)(grabber.getFrameRate() * (double)beginSecond) - 1);
            long numFrame = (long)(((double)(endSecond - beginSecond) + 0.5) * grabber.getFrameRate()) * 4L;
            recorder = new FFmpegFrameRecorder(output, grabber.getImageWidth(), grabber.getImageHeight());
            recorder.setFormat("mp4");
            recorder.setVideoCodec(27);
            recorder.setVideoBitrate(grabber.getVideoBitrate());
            recorder.setFrameRate(grabber.getFrameRate());
            recorder.setPixelFormat(0);
            recorder.setAudioChannels(2);
            recorder.start();
            for (long num = 0L; (frame = grabber.grabFrame()) != null && numFrame >= num; ++num) {
                recorder.record(frame);
            }
        }
        catch (Exception e) {
            log.error("\u5207\u5272\u89c6\u9891\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5207\u5272\u89c6\u9891\u5931\u8d25");
        }
        finally {
            try {
                log.info("\u5173\u95ed\u6d41");
                if (grabber != null) {
                    grabber.stop();
                    grabber.close();
                    grabber.release();
                }
                if (recorder != null) {
                    recorder.stop();
                    recorder.close();
                    recorder.release();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static void obtainVideoCover(InputStream stream, OutputStream output, Map<String, String> metadata) {
        FFmpegFrameGrabber grabber = null;
        try {
            grabber = new FFmpegFrameGrabber(stream);
            grabber.start();
            if (metadata != null) {
                FfmpegTool.obtainVideoMeta(grabber, metadata);
            }
            Frame frame = grabber.grabImage();
            Java2DFrameConverter converter = new Java2DFrameConverter();
            BufferedImage image = converter.getBufferedImage(frame);
            frame.close();
            grabber.close();
            ImgUtil.write((Image)image, (String)"jpeg", (OutputStream)output);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c6\u9891\u9996\u5e27\u622a\u56fe\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u89c6\u9891\u9996\u5e27\u622a\u56fe\u5931\u8d25");
        }
        finally {
            try {
                log.info("\u5173\u95ed\u6d41");
                stream.close();
                if (grabber != null) {
                    grabber.close();
                }
                System.gc();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static void obtainLiveToMp4(String live, String output, LiveRecordFlagService handler) {
        FFmpegFrameGrabber grabber = null;
        try {
            Frame frame;
            grabber = new FFmpegFrameGrabber(live);
            grabber.start();
            FrameRecorder recorder = FrameRecorder.createDefault((String)output, (int)grabber.getImageWidth(), (int)grabber.getImageHeight());
            recorder.setFormat("mp4");
            recorder.setFrameRate(grabber.getFrameRate());
            recorder.start();
            boolean flag = true;
            while ((frame = grabber.grabFrame()) != null && flag) {
                recorder.record(frame);
                flag = handler.getLiveRecordFlag();
            }
            recorder.close();
            grabber.close();
        }
        catch (Exception e) {
            log.error("\u89c6\u9891\u76f4\u64ad\u6d41{}\u4fdd\u5b58\u89c6\u9891\u5931\u8d25", (Object)live, (Object)e);
            throw new RuntimeException("\u89c6\u9891\u76f4\u64ad\u6d41\u4fdd\u5b58\u89c6\u9891\u5931\u8d25");
        }
        finally {
            try {
                log.info("\u5173\u95ed\u6d41");
                if (grabber != null) {
                    grabber.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static void obtainVideoMeta(FFmpegFrameGrabber grabber, Map<String, String> map) {
        map.putAll(grabber.getMetadata());
        map.put("duration", "" + (double)grabber.getLengthInTime() / 1000000.0);
        map.put("image_width", "" + grabber.getImageWidth());
        map.put("image_height", "" + grabber.getImageHeight());
    }
}

