/*
 * Decompiled with CFR 0.152.
 */
package io.agora.recording;

import io.agora.recording.RecordingCleanTimer;
import io.agora.recording.RecordingEventHandler;
import io.agora.recording.RecordingSDK;
import io.agora.recording.UserInfo;
import io.agora.recording.common.Common;
import io.agora.recording.common.RecordingConfig;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recording
implements RecordingEventHandler {
    private static final Logger log = LoggerFactory.getLogger(Recording.class);
    private boolean isMixMode = false;
    private int width = 0;
    private int height = 0;
    private int fps = 0;
    private int kbps = 0;
    public String storageDir = "./";
    private long aCount = 0L;
    private long count = 0L;
    private long size = 0L;
    private Common.CHANNEL_PROFILE_TYPE profile_type;
    Vector<Long> m_peers = new Vector();
    private RecordingConfig config = null;
    private RecordingSDK RecordingSDKInstance = null;
    private boolean m_receivingAudio = false;
    private boolean m_receivingVideo = false;
    private HashSet<Long> subscribedVideoUids = new HashSet();
    private HashSet<String> subscribedVideoUserAccount = new HashSet();
    HashMap<String, UserInfo> audioChannels = new HashMap();
    HashMap<String, UserInfo> videoChannels = new HashMap();
    Timer cleanTimer = null;
    private int layoutMode = 0;
    private long maxResolutionUid = -1L;
    private String maxResolutionUserAccount = "";
    private int keepLastFrame = 0;
    public static final int DEFAULT_LAYOUT = 0;
    public static final int BESTFIT_LAYOUT = 1;
    public static final int VERTICALPRESENTATION_LAYOUT = 2;
    private String userAccount = "";
    private long keepMediaTime = 0L;
    private long lastKeepAudioTime = 0L;
    private long lastKeepVideoTime = 0L;
    public long startRecordTime = -1L;
    public long finishRecordTime = -1L;
    public String errorMsg = null;
    public boolean finish = false;

    public Recording(RecordingSDK recording) {
        this.RecordingSDKInstance = recording;
        this.RecordingSDKInstance.registerOberserver(this);
    }

    public void leaveChannel() {
        this.RecordingSDKInstance.leaveChannel();
    }

    public void unRegister() {
        this.RecordingSDKInstance.unRegisterOberserver(this);
    }

    private boolean IsMixMode() {
        return this.isMixMode;
    }

    @Override
    public void onLeaveChannel(int reason) {
    }

    @Override
    public void onError(int error, int stat_code) {
        if (error > Common.ERROR_CODE_TYPE.ERR_OK.getValue()) {
            this.errorMsg = "RecordingSDK onError,error:" + error + ",stat code:" + stat_code;
        }
    }

    @Override
    public void onWarning(int warn) {
        log.info("RecordingSDK onWarning,warn:" + warn);
    }

    @Override
    public void onJoinChannelSuccess(String channelId, long uid) {
        if (this.config.decodeAudio != Common.AUDIO_FORMAT_TYPE.AUDIO_FORMAT_DEFAULT_TYPE) {
            this.cleanTimer.schedule((TimerTask)new RecordingCleanTimer(this), 10000L);
        }
        log.info("RecordingSDK joinChannel success, channelId:" + channelId + ", uid:" + uid);
    }

    @Override
    public void onRejoinChannelSuccess(String channelId, long uid) {
        log.info("onRejoinChannelSuccess, channel id : " + channelId + ", uid: " + uid);
    }

    @Override
    public void onConnectionStateChanged(Common.CONNECTION_STATE_TYPE state, Common.CONNECTION_CHANGED_REASON_TYPE reason) {
    }

    @Override
    public void onRemoteAudioStats(long uid, Common.RemoteAudioStats stats) {
    }

    @Override
    public void onRemoteVideoStats(long uid, Common.RemoteVideoStats stats) {
    }

    @Override
    public void onRecordingStats(Common.RecordingStats stats) {
    }

    @Override
    public void onUserOffline(long uid, int reason) {
        log.info("RecordingSDK onUserOffline uid:" + uid + ",offline reason:" + reason);
        this.m_peers.remove(uid);
        this.SetVideoMixingLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean() {
        Recording recording = this;
        synchronized (recording) {
            long now = System.currentTimeMillis();
            Iterator<Map.Entry<String, UserInfo>> audio_it = this.audioChannels.entrySet().iterator();
            while (audio_it.hasNext()) {
                Map.Entry<String, UserInfo> entry = audio_it.next();
                UserInfo info = entry.getValue();
                if (now - info.last_receive_time <= 3000L) continue;
                try {
                    info.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                audio_it.remove();
            }
            Iterator<Map.Entry<String, UserInfo>> video_it = this.videoChannels.entrySet().iterator();
            while (video_it.hasNext()) {
                Map.Entry<String, UserInfo> entry = video_it.next();
                UserInfo info = entry.getValue();
                if (now - info.last_receive_time <= 3000L) continue;
                try {
                    info.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                video_it.remove();
            }
        }
        this.cleanTimer.schedule((TimerTask)new RecordingCleanTimer(this), 10000L);
    }

    @Override
    public void onUserJoined(long uid, String recordingDir) {
        log.info("onUserJoined uid:" + uid + ",recordingDir:" + recordingDir);
        this.storageDir = recordingDir;
        this.m_peers.add(uid);
        if (this.userAccount.length() > 0) {
            if (this.layoutMode != 2 || this.RecordingSDKInstance.getUidByUserAccount(this.maxResolutionUserAccount) != 0L) {
                this.SetVideoMixingLayout();
            }
        } else {
            this.SetVideoMixingLayout();
        }
    }

    @Override
    public void onLocalUserRegistered(long uid, String userAccount) {
        log.info("onLocalUserRegistered: " + uid + " => " + userAccount);
    }

    @Override
    public void onUserInfoUpdated(long uid, String userAccount) {
        log.info("onUserInfoUpdated: " + uid + " => " + userAccount);
        if (this.subscribedVideoUserAccount.contains(userAccount)) {
            this.subscribedVideoUids.add(uid);
        }
        this.SetVideoMixingLayout();
    }

    @Override
    public void onRemoteVideoStreamStateChanged(long uid, Common.REMOTE_STREAM_STATE state, Common.REMOTE_STREAM_STATE_CHANGED_REASON reason) {
    }

    @Override
    public void onRemoteAudioStreamStateChanged(long uid, Common.REMOTE_STREAM_STATE state, Common.REMOTE_STREAM_STATE_CHANGED_REASON reason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUser(long uid, boolean isAudio, int frameType) {
        String path = this.storageDir + uid;
        String key = Long.toString(uid);
        Recording recording = this;
        synchronized (recording) {
            UserInfo info;
            if (isAudio && !this.audioChannels.containsKey(key) && (frameType == 0 || frameType == 1)) {
                String audioPath = "";
                if (frameType == 0) {
                    audioPath = path + ".pcm";
                } else if (frameType == 1) {
                    audioPath = path + ".aac";
                }
                try {
                    info = new UserInfo();
                    info.fileName = audioPath;
                    info.channel = new FileOutputStream(audioPath, true);
                    info.last_receive_time = System.currentTimeMillis();
                    this.audioChannels.put(key, info);
                }
                catch (FileNotFoundException e) {
                    log.error("Can't find file : " + audioPath);
                }
            }
            if (!(isAudio || this.videoChannels.containsKey(key) || frameType != 0 && frameType != 1 && frameType != 3)) {
                String videoPath = "";
                if (frameType == 0) {
                    videoPath = path + ".yuv";
                } else if (frameType == 1) {
                    videoPath = path + ".h264";
                } else if (frameType == 3) {
                    videoPath = path + ".h265";
                }
                try {
                    info = new UserInfo();
                    info.fileName = videoPath;
                    info.channel = new FileOutputStream(videoPath, true);
                    info.last_receive_time = System.currentTimeMillis();
                    this.videoChannels.put(key, info);
                }
                catch (FileNotFoundException e) {
                    log.info("Can't find file : " + videoPath);
                }
            }
        }
    }

    @Override
    public void onActiveSpeaker(long uid) {
        log.info("User:" + uid + "is speaking");
    }

    @Override
    public void onReceivingStreamStatusChanged(boolean receivingAudio, boolean receivingVideo) {
        log.info("pre receiving audio status is " + this.m_receivingAudio + ", now receiving audio status is " + receivingAudio);
        log.info("pre receiving video status is " + this.m_receivingVideo + ", now receiving video  status is " + receivingVideo);
        this.m_receivingAudio = receivingAudio;
        this.m_receivingVideo = receivingVideo;
    }

    @Override
    public void onConnectionLost() {
        log.info("connection is lost");
    }

    @Override
    public void onConnectionInterrupted() {
        log.info("connection is interrupted");
    }

    @Override
    public void onAudioVolumeIndication(Common.AudioVolumeInfo[] infos) {
        if (infos.length == 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            log.info("User:" + Long.toString(infos[i].uid) + ", audio volume:" + infos[i].volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstRemoteVideoDecoded(long uid, int width, int height, int elapsed) {
        log.info("onFirstRemoteVideoDecoded User:" + Long.toString(uid) + ", width:" + width + ", height:" + height + ", elapsed:" + elapsed);
        Recording recording = this;
        synchronized (recording) {
            if (this.startRecordTime < 0L) {
                this.startRecordTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstRemoteAudioFrame(long uid, int elapsed) {
        log.info("onFirstRemoteAudioFrame User:" + Long.toString(uid) + ", elapsed:" + elapsed);
        Recording recording = this;
        synchronized (recording) {
            if (this.startRecordTime < 0L) {
                this.startRecordTime = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void audioFrameReceived(long uid, Common.AudioFrame frame) {
        byte[] buf = null;
        long size = 0L;
        this.checkUser(uid, true, frame.type.ordinal());
        if (frame.type == Common.AUDIO_FRAME_TYPE.AUDIO_FRAME_RAW_PCM) {
            buf = frame.pcm.pcmBuf;
            size = frame.pcm.pcmBufSize;
        } else if (frame.type == Common.AUDIO_FRAME_TYPE.AUDIO_FRAME_AAC) {
            buf = frame.aac.aacBuf;
            size = frame.aac.aacBufSize;
        } else {
            return;
        }
        this.WriteBytesToFileClassic(uid, buf, size, true);
    }

    @Override
    public void videoFrameReceived(long uid, int type, Common.VideoFrame frame, int rotation) {
        byte[] buf = null;
        long size = 0L;
        this.checkUser(uid, false, type);
        if (type == 0) {
            buf = frame.yuv.buf;
            size = frame.yuv.bufSize;
            if (buf == null) {
                log.info("java demo videoFrameReceived null");
            }
        } else if (type == 1) {
            buf = frame.h264.buf;
            size = frame.h264.bufSize;
        } else {
            if (type == 2) {
                String path = this.storageDir + Long.toString(uid) + "_" + System.currentTimeMillis() + ".jpg";
                buf = frame.jpg.buf;
                size = frame.jpg.bufSize;
                try {
                    FileOutputStream channel = new FileOutputStream(path, true);
                    channel.write(buf, 0, (int)size);
                    channel.close();
                }
                catch (Exception e) {
                    log.info("Error write to " + path);
                }
                log.info("java demovideoFrameReceived,uid:" + uid + ",type:" + type + ",path:" + path);
                return;
            }
            if (type == 3) {
                buf = frame.h265.buf;
                size = frame.h265.bufSize;
            } else {
                if (type == 4) {
                    log.info("java demovideoFrameReceived,uid:" + uid + ",type:" + type + ",jpg_file:" + frame.jpg_file.file_name);
                    return;
                }
                return;
            }
        }
        this.WriteBytesToFileClassic(uid, buf, size, false);
    }

    @Override
    public void recordingPathCallBack(String path) {
        this.storageDir = path;
    }

    private int SetVideoMixingLayout() {
        int max_peers;
        Common ei = new Common();
        Common.VideoMixingLayout layout = ei.new Common.VideoMixingLayout();
        layout.keepLastFrame = this.keepLastFrame;
        int n = max_peers = this.profile_type == Common.CHANNEL_PROFILE_TYPE.CHANNEL_PROFILE_COMMUNICATION ? 7 : 17;
        if (this.m_peers.size() > max_peers) {
            log.info("peers size is bigger than max m_peers:" + this.m_peers.size());
            return -1;
        }
        if (!this.IsMixMode()) {
            return -1;
        }
        long maxuid = 0L;
        maxuid = this.userAccount.length() > 0 ? this.RecordingSDKInstance.getUidByUserAccount(this.maxResolutionUserAccount) : this.maxResolutionUid;
        Vector<Long> videoUids = new Vector<Long>();
        for (Long uid : this.m_peers) {
            if (!this.config.autoSubscribe && !this.subscribedVideoUids.contains(uid)) continue;
            if (this.layoutMode == 2) {
                String uc = this.RecordingSDKInstance.getUserAccountByUid((int)uid.longValue());
                if (uc.length() <= 0 && maxuid == 0L) continue;
                videoUids.add(uid);
                continue;
            }
            videoUids.add(uid);
        }
        layout.canvasHeight = this.height;
        layout.canvasWidth = this.width;
        layout.backgroundColor = "#23b9dc";
        layout.regionCount = videoUids.size();
        if (!videoUids.isEmpty()) {
            log.info("java setVideoMixingLayout videoUids is not empty, start layout");
            Common.VideoMixingLayout.Region[] regionList = new Common.VideoMixingLayout.Region[videoUids.size()];
            log.info("mixing layout mode:" + this.layoutMode);
            if (this.layoutMode == 1) {
                this.adjustBestFitVideoLayout(regionList, layout, videoUids);
            } else if (this.layoutMode == 2) {
                this.adjustVerticalPresentationLayout(maxuid, regionList, layout, videoUids);
            } else {
                this.adjustDefaultVideoLayout(regionList, layout, videoUids);
            }
            layout.regions = regionList;
        } else {
            layout.regions = null;
        }
        return this.RecordingSDKInstance.setVideoMixingLayout(layout);
    }

    private void adjustVerticalPresentationLayout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        log.info("begin adjust vertical presentation layout,peers size:" + videoUids.size() + ", maxResolutionUid:" + maxResolutionUid);
        if (videoUids.size() <= 5) {
            this.adjustVideo5Layout(maxResolutionUid, regionList, layout, videoUids);
        } else if (videoUids.size() <= 7) {
            this.adjustVideo7Layout(maxResolutionUid, regionList, layout, videoUids);
        } else if (videoUids.size() <= 9) {
            this.adjustVideo9Layout(maxResolutionUid, regionList, layout, videoUids);
        } else {
            this.adjustVideo17Layout(maxResolutionUid, regionList, layout, videoUids);
        }
    }

    private void adjustBestFitVideoLayout(Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        if (videoUids.size() == 1) {
            this.adjustBestFitLayout_Square(regionList, 1, layout, videoUids);
        } else if (videoUids.size() == 2) {
            this.adjustBestFitLayout_2(regionList, layout, videoUids);
        } else if (2 < videoUids.size() && videoUids.size() <= 4) {
            this.adjustBestFitLayout_Square(regionList, 2, layout, videoUids);
        } else if (5 <= videoUids.size() && videoUids.size() <= 9) {
            this.adjustBestFitLayout_Square(regionList, 3, layout, videoUids);
        } else if (10 <= videoUids.size() && videoUids.size() <= 16) {
            this.adjustBestFitLayout_Square(regionList, 4, layout, videoUids);
        } else if (videoUids.size() == 17) {
            this.adjustBestFitLayout_17(regionList, layout, videoUids);
        } else {
            log.info("adjustBestFitVideoLayout is more than 17 users");
        }
    }

    private void adjustBestFitLayout_2(Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int peersCount = videoUids.size();
        for (int i = 0; i < peersCount; ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            regionList[i].uid = videoUids.get(i);
            regionList[i].x = (i + 1) % 2 == 0 ? 0.0 : 0.5;
            regionList[i].y = 0.0;
            regionList[i].width = 0.5;
            regionList[i].height = 1.0;
            regionList[i].alpha = i + 1;
            regionList[i].renderMode = 0;
        }
    }

    private void adjustDefaultVideoLayout(Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        regionList[0] = layout.new Common.VideoMixingLayout.Region();
        regionList[0].uid = videoUids.get(0);
        regionList[0].x = 0.0;
        regionList[0].y = 0.0;
        regionList[0].width = 1.0;
        regionList[0].height = 1.0;
        regionList[0].alpha = 1.0;
        regionList[0].renderMode = 0;
        float f_width = this.width;
        float f_height = this.height;
        float canvasWidth = f_width;
        float canvasHeight = f_height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        for (int i = 1; i < videoUids.size(); ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            regionList[i].uid = videoUids.get(i);
            float f_x = (i - 1) % 4;
            float f_y = (i - 1) / 4;
            float xIndex = f_x;
            float yIndex = f_y;
            regionList[i].x = xIndex * (viewWidth + viewHEdge) + viewHEdge;
            regionList[i].y = 1.0f - (yIndex + 1.0f) * (viewHeight + viewVEdge);
            regionList[i].width = viewWidth;
            regionList[i].height = viewHeight;
            regionList[i].alpha = i + 1;
            regionList[i].renderMode = 0;
        }
        layout.regions = regionList;
    }

    private void setMaxResolutionUid(int number, long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, double weight_ratio) {
        regionList[number].uid = maxResolutionUid;
        regionList[number].x = 0.0;
        regionList[number].y = 0.0;
        regionList[number].width = 1.0 * weight_ratio;
        regionList[number].height = 1.0;
        regionList[number].alpha = 1.0;
        regionList[number].renderMode = 1;
    }

    private void changeToVideo7Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        log.info("changeToVideo7Layout");
        this.adjustVideo7Layout(maxResolutionUid, regionList, layout, videoUids);
    }

    private void changeToVideo9Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        log.info("changeToVideo9Layout");
        this.adjustVideo9Layout(maxResolutionUid, regionList, layout, videoUids);
    }

    private void changeToVideo17Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        log.info("changeToVideo17Layout");
        this.adjustVideo17Layout(maxResolutionUid, regionList, layout, videoUids);
    }

    private void adjustBestFitLayout_Square(Common.VideoMixingLayout.Region[] regionList, int nSquare, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = (float)(1.0 / (double)nSquare);
        float viewHEdge = (float)(1.0 / (double)nSquare);
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int peersCount = videoUids.size();
        for (int i = 0; i < peersCount; ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            float xIndex = i % nSquare;
            float yIndex = i / nSquare;
            regionList[i].uid = videoUids.get(i);
            regionList[i].x = 1.0 / (double)nSquare * (double)xIndex;
            regionList[i].y = 1.0 / (double)nSquare * (double)yIndex;
            regionList[i].width = viewWidth;
            regionList[i].height = viewHEdge;
            regionList[i].alpha = i + 1;
            regionList[i].renderMode = 0;
        }
    }

    private void adjustBestFitLayout_17(Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        int n = 5;
        float viewWidth = (float)(1.0 / (double)n);
        float viewHEdge = (float)(1.0 / (double)n);
        float totalWidth = 1.0f - viewWidth;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int peersCount = videoUids.size();
        for (int i = 0; i < peersCount; ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            float xIndex = i % (n - 1);
            float yIndex = i / (n - 1);
            regionList[i].uid = videoUids.get(i);
            regionList[i].width = viewWidth;
            regionList[i].height = viewHEdge;
            regionList[i].alpha = i + 1;
            regionList[i].renderMode = 0;
            if (i == 16) {
                regionList[i].x = (1.0f - viewWidth) * 0.5f * 1.0f;
                log.info("special layout for 17 x is:" + regionList[i].x);
            } else {
                regionList[i].x = 0.5f * viewWidth + viewWidth * xIndex;
            }
            regionList[i].y = 1.0 / (double)n * (double)yIndex;
        }
    }

    private void adjustVideo5Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        boolean flag = false;
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int number = 0;
        for (int i = 0; i < videoUids.size(); ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            if (maxResolutionUid == videoUids.get(i)) {
                log.info("adjustVideo5Layout equal with configured user uid:" + maxResolutionUid);
                flag = true;
                this.setMaxResolutionUid(number, maxResolutionUid, regionList, 0.8);
                ++number;
                continue;
            }
            regionList[number].uid = videoUids.get(i);
            float yIndex = flag ? (float)(number - 1) : (float)(number % 4);
            regionList[number].x = 0.8;
            regionList[number].y = 0.25 * (double)yIndex;
            regionList[number].width = 0.19999999999999996;
            regionList[number].height = 0.25;
            regionList[number].alpha = number;
            regionList[number].renderMode = 0;
            ++number;
            if (i != 4 || flag) continue;
            this.changeToVideo7Layout(maxResolutionUid, regionList, layout, videoUids);
        }
    }

    private void adjustVideo7Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        boolean flag = false;
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int number = 0;
        for (int i = 0; i < videoUids.size(); ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            if (maxResolutionUid == videoUids.get(i)) {
                log.info("adjustVideo7Layout equal with configured user uid:" + maxResolutionUid);
                flag = true;
                this.setMaxResolutionUid(number, maxResolutionUid, regionList, 0.8571428656578064);
                ++number;
                continue;
            }
            regionList[number].uid = videoUids.get(i);
            float yIndex = flag ? (float)number - 1.0f : (float)(number % 6);
            regionList[number].x = 0.8571428656578064;
            regionList[number].y = 0.16666667f * yIndex;
            regionList[number].width = 0.1428571492433548;
            regionList[number].height = 0.1666666716337204;
            regionList[number].alpha = number;
            regionList[number].renderMode = 0;
            ++number;
            if (i != 6 || flag) continue;
            this.changeToVideo9Layout(maxResolutionUid, regionList, layout, videoUids);
        }
    }

    private void adjustVideo9Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        boolean flag = false;
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int number = 0;
        for (int i = 0; i < videoUids.size(); ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            if (maxResolutionUid == videoUids.get(i)) {
                log.info("adjustVideo9Layout equal with configured user uid:" + maxResolutionUid);
                flag = true;
                this.setMaxResolutionUid(number, maxResolutionUid, regionList, 1.8f);
                ++number;
                continue;
            }
            regionList[number].uid = videoUids.get(i);
            float yIndex = flag ? (float)(number - 1) : (float)(number % 8);
            regionList[number].x = 0.8888888955116272;
            regionList[number].y = 0.125f * yIndex;
            regionList[number].width = 0.1111111119389534;
            regionList[number].height = 0.125;
            regionList[number].alpha = number;
            regionList[number].renderMode = 0;
            ++number;
            if (i != 8 || flag) continue;
            this.changeToVideo17Layout(maxResolutionUid, regionList, layout, videoUids);
        }
    }

    private void adjustVideo17Layout(long maxResolutionUid, Common.VideoMixingLayout.Region[] regionList, Common.VideoMixingLayout layout, Vector<Long> videoUids) {
        boolean flag = false;
        float canvasWidth = this.width;
        float canvasHeight = this.height;
        float viewWidth = 0.235f;
        float viewHEdge = 0.012f;
        float viewHeight = viewWidth * (canvasWidth / canvasHeight);
        float viewVEdge = viewHEdge * (canvasWidth / canvasHeight);
        int number = 0;
        log.info("adjustVideo17Layoutenter videoUids size is:" + videoUids.size() + ", maxResolutionUid:" + maxResolutionUid);
        for (int i = 0; i < videoUids.size(); ++i) {
            regionList[i] = layout.new Common.VideoMixingLayout.Region();
            if (maxResolutionUid == videoUids.get(i)) {
                flag = true;
                this.setMaxResolutionUid(number, maxResolutionUid, regionList, 0.8);
                ++number;
                continue;
            }
            if (!flag && i == 16) {
                log.info("Not the configured uid, and small regions is sixteen, so ignore this user:" + videoUids.get(i));
                break;
            }
            regionList[number].uid = videoUids.get(i);
            float yIndex = flag ? (float)((number - 1) % 8) : (float)(number % 8);
            regionList[number].x = flag && i > 8 || !flag && i >= 8 ? (double)0.9f : (double)0.8f;
            regionList[number].y = 0.125f * yIndex;
            regionList[number].width = 0.1f;
            regionList[number].height = 0.125;
            regionList[number].alpha = number;
            regionList[number].renderMode = 0;
            ++number;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WriteBytesToFileClassic(long uid, byte[] byteBuffer, long size, boolean isAudio) {
        if (byteBuffer == null) {
            log.info("WriteBytesToFileClassic but byte buffer is null!");
            return;
        }
        Recording recording = this;
        synchronized (recording) {
            try {
                UserInfo info;
                UserInfo userInfo = info = isAudio ? this.audioChannels.get(Long.toString(uid)) : this.videoChannels.get(Long.toString(uid));
                if (info != null) {
                    long curTs = System.currentTimeMillis();
                    if (this.startRecordTime < 0L) {
                        this.startRecordTime = curTs;
                    }
                    if (isAudio) {
                        if (this.keepMediaTime > 0L && (curTs - this.lastKeepAudioTime) / 1000L >= this.keepMediaTime) {
                            info.channel.close();
                            info.channel = new FileOutputStream(info.fileName, false);
                            this.lastKeepAudioTime = curTs;
                        }
                    } else if (this.keepMediaTime > 0L && (curTs - this.lastKeepVideoTime) / 1000L >= this.keepMediaTime) {
                        info.channel.close();
                        info.channel = new FileOutputStream(info.fileName, false);
                        this.lastKeepVideoTime = curTs;
                    }
                    info.channel.write(byteBuffer, 0, (int)size);
                    info.channel.flush();
                    info.last_receive_time = System.currentTimeMillis();
                } else {
                    log.info("Channel is null");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String GetNowDate() {
        String temp_str = "";
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        temp_str = sdf.format(dt);
        return temp_str;
    }

    private void PrintUsersInfo(Vector vector) {
        log.info("user size:" + vector.size());
        for (Long l : this.m_peers) {
            log.info("user:" + l);
        }
    }

    private boolean checkEnumValue(int val, int max, String msg) {
        if (val < 0 || val > max) {
            log.info(msg);
            return false;
        }
        return true;
    }

    public void createChannel(Map<String, String> params) {
        String tmpEnv;
        int uid = 0;
        String appId = "";
        String channelKey = "";
        String name = "";
        int channelProfile = 0;
        String decryptionMode = "";
        String secret = "";
        String mixResolution = "360,640,15,500";
        int idleLimitSec = 300;
        String applitePath = "";
        String recordFileRootDir = "";
        String cfgFilePath = "";
        int proxyType = 1;
        String proxyServer = "";
        String defaultVideoBgPath = "";
        String defaultUserBgPath = "";
        String subscribeVideoUids = "";
        String subscribeAudioUids = "";
        String localAp = "";
        int lowUdpPort = 0;
        int highUdpPort = 0;
        boolean isAudioOnly = false;
        boolean isVideoOnly = false;
        boolean isMixingEnabled = false;
        boolean autoSubscribe = true;
        boolean enableCloudProxy = false;
        boolean enableIntraRequest = true;
        boolean enableH265Support = false;
        int mixedVideoAudio = Common.MIXED_AV_CODEC_TYPE.MIXED_AV_DEFAULT.ordinal();
        int getAudioFrame = Common.AUDIO_FORMAT_TYPE.AUDIO_FORMAT_DEFAULT_TYPE.ordinal();
        int getVideoFrame = Common.VIDEO_FORMAT_TYPE.VIDEO_FORMAT_DEFAULT_TYPE.ordinal();
        int streamType = Common.REMOTE_VIDEO_STREAM_TYPE.REMOTE_VIDEO_STREAM_HIGH.ordinal();
        int captureInterval = 5;
        int triggerMode = 0;
        int audioIndicationInterval = 0;
        int audioProfile = 0;
        int logLevel = Integer.parseInt(params.get("--logLevel"));
        String Appid = params.get("--appId");
        String Channel2 = params.get("--channel");
        String AppliteDir = params.get("--appliteDir");
        String Uid = params.get("--uid");
        String UserAccount = params.get("--userAccount");
        String ChannelKey = params.get("--channelKey");
        String ChannelProfile = params.get("--channelProfile");
        String IsAudioOnly = params.get("--isAudioOnly");
        String IsVideoOnly = params.get("--isVideoOnly");
        String IsMixingEnabled = params.get("--isMixingEnabled");
        String MixResolution = params.get("--mixResolution");
        String MixedVideoAudio = params.get("--mixedVideoAudio");
        String DecryptionMode = params.get("--decryptionMode");
        String Secret = params.get("--secret");
        String Idle = params.get("--idle");
        String RecordFileRootDir = params.get("--recordFileRootDir");
        String LowUdpPort = params.get("--lowUdpPort");
        String HighUdpPort = params.get("--highUdpPort");
        String GetAudioFrame = params.get("--getAudioFrame");
        String GetVideoFrame = params.get("--getVideoFrame");
        String CaptureInterval = params.get("--captureInterval");
        String CfgFilePath = params.get("--cfgFilePath");
        String StreamType = params.get("--streamType");
        String TriggerMode = params.get("--triggerMode");
        String ProxyType = params.get("--proxyType");
        String ProxyServer = params.get("--proxyServer");
        String AudioProfile = params.get("--audioProfile");
        String AudioIndicationInterval = params.get("--audioIndicationInterval");
        String DefaultVideoBg = params.get("--defaultVideoBg");
        String DefaultUserBg = params.get("--defaultUserBg");
        String LogLevel = params.get("--logLevel");
        String LayoutMode = params.get("--layoutMode");
        String MaxResolutionUid = params.get("--maxResolutionUid");
        String MaxResolutionUserAccount = params.get("--maxResolutionUserAccount");
        String AutoSubscribe = params.get("--autoSubscribe");
        String SubscribeVideoUids = params.get("--subscribeVideoUids");
        String SubscribeAudioUids = params.get("--subscribeAudioUids");
        String KeepLastFrame = params.get("--keepLastFrame");
        String EnableCloudProxy = params.get("--enableCloudProxy");
        String EnableIntraRequest = params.get("--enableIntraRequest");
        String EnableH265Support = params.get("--enableH265Support");
        String LocalAp = params.get("--localAp");
        if (Appid == null || Uid == null && this.userAccount == null || Channel2 == null || AppliteDir == null) {
            log.error("\u5f55\u5236\u53c2\u6570\u6709\u8bef!");
            String usage = "java RecordingSDK --appId STRING --channel STRING --appliteDir STRING --uid UINTEGER32 --userAccount STRING --channelKey STRING --channelProfile UINTEGER32 --isAudioOnly --isVideoOnly --isMixingEnabled --mixResolution STRING --mixedVideoAudio UINTEGER32 --decryptionMode STRING --secret STRING --idle INTEGER32 --recordFileRootDir STRING --lowUdpPort INTEGER32 --highUdpPort INTEGER32 --getAudioFrame UINTEGER32 --getVideoFrame UINTEGER32 --captureInterval INTEGER32 --cfgFilePath STRING --streamType UINTEGER32 --triggerMode INTEGER32 --proxyType INTEGER32 --proxyServer STRING --audioProfile UINTEGER32 --audioIndicationInterval INTEGER32 --defaultVideoBg STRING --defaultUserBg STRING --logLevel INTEGER32 --layoutMode INTEGER32 --maxResolutionUid INTEGER32 --maxResolutionUserAccount STRING --autoSubscribe --subscribeVideoUids STRING --subscribeAudioUids STRING --keepLastFrame UINTEGER32 --enableCloudProxy --enableIntraRequest --enableH265Support\n\t--appId     (App Id/must)\n\t--channel     (Channel Id/must)\n\t--appliteDir     (directory of app lite 'AgoraCoreService', Must pointer to 'Agora_Recording_SDK_for_Linux_FULL/bin/' folder/must)\n\t--uid     (User Id default is 0/option)\n\t--userAccount     (User account, default uid is used/option)\n\t--channelKey     (channelKey/option)\n\t--channelProfile     (channel_profile:(0:COMMUNICATION),(1:broadcast) default is 0/option)\n\t--isAudioOnly     (Default 0:A/V, 1:AudioOnly (0:1)/option)\n\t--isVideoOnly     (Default 0:A/V, 1:VideoOnly (0:1)/option)\n\t--isMixingEnabled     (Mixing Enable? (0:1)/option)\n\t--mixResolution     (change default resolution for vdieo mix mode/option)\n\t--mixedVideoAudio     (mixVideoAudio:(0:seperated Audio,Video) (1:mixed Audio & Video with legacy codec) (2:mixed Audio & Video with new codec), default is 0 /option)\n\t--decryptionMode     (decryption Mode, default is NULL/option)\n\t--secret     (input secret when enable decryptionMode/option)\n\t--idle     (Default 300s, should be above 3s/option)\n\t--recordFileRootDir     (recording file root dir/option)\n\t--lowUdpPort     (default is random value/option)\n\t--highUdpPort     (default is random value/option)\n\t--getAudioFrame     (default 0 (0:save as file, 1:aac frame, 2:pcm frame, 3:mixed pcm frame) (Can't combine with isMixingEnabled) /option)\n\t--getVideoFrame     (default 0 (0:save as file, 1:encoded video frame, eg:h.264,h.265, 2:yuv, 3:jpg buffer, 4:jpg file, 5:jpg file and video file) (Can't combine with isMixingEnabled) /option)\n\t--captureInterval     (default 5 (Video snapshot interval (second)))\n\t--cfgFilePath     (config file path / option)\n\t--streamType     (remote video stream type(0:STREAM_HIGH,1:STREAM_LOW), default is 0/option)\n\t--triggerMode     (triggerMode:(0: automatically mode, 1: manually mode) default is 0/option)\n\t--proxyType     (proxyType:proxyServer format type, 0:self socks5 proxy server, 1:cloud proxy domain, 2:proxy LBS server list. default is 1/option)\n\t--proxyServer     (proxyServer:format proxyType:content, ie: 0:'ip:port', 1:'LBS domain:port', 2:'LBS_ip1,LBS_ip2:port' /option)\n\t--audioProfile     (audio quality: (0: single channelstandard 1: single channel high quality 2:multiple channel high quality)\n\t--audioIndicationInterval     (audioIndicationInterval:(0: no indication, audio indication interval(ms)) default is 0/option)\n\t--defaultVideoBg     (default video background/option)\n\t--defaultUserBg     (default user background/option)\n\t--logLevel     (log level default INFO/option)\n\t--layoutMode     (layoutMode:(0: default layout, 1:bestFit Layout mode, 2:vertical presentation Layout mode) default is 0/option)\n\t--maxResolutionUid     (uid with maxest resolution under vertical presentation Layout mode if uid is used  ( default is -1 /option)\n\t--maxResolutionUserAccount     (user account with maxest resolution under vertical presentation layout mode if userAccount is used ( default is empty /option)\n\t--autoSubscribe     (Auto subscribe video/audio streams of each uid. (0: false 1: true, default 1 /option))\n\t--subscribeVideoUids     (video stream of specific uids. uids seperated by commas, like 1234,2345/option)\n\t--subscribeAudioUids     (audio stream of specific uids. uids sperated by commas, like 1234,2345 /option)\n\t--keepLastFrame     (whether keep user's last video frame when no video stream(0: render user background image or corlor. 2. keep last farme. default is 0))\n\t--enableCloudProxy     (enable cloud proxy or not(0 : not, 1: enable, default 0/option)\n\t--enableIntraRequest     (enable Intra Request or not(0 : not, 1: enable, default 1/option))\n\t--enableH265Support     (enable H.265 video codec or not(0 : not, 1: enable, default 0/option))";
            log.info("Usage:" + usage);
            return;
        }
        if (Uid != null) {
            uid = Integer.parseInt(String.valueOf(Uid));
        }
        if (UserAccount != null) {
            this.userAccount = String.valueOf(UserAccount);
        }
        appId = String.valueOf(Appid);
        name = String.valueOf(Channel2);
        applitePath = String.valueOf(AppliteDir);
        if (ChannelKey != null) {
            channelKey = String.valueOf(ChannelKey);
        }
        if (ChannelProfile != null) {
            channelProfile = Integer.parseInt(String.valueOf(ChannelProfile));
        }
        if (!this.checkEnumValue(channelProfile, 1, "Invalid channel profile value :" + channelProfile)) {
            return;
        }
        if (DecryptionMode != null) {
            decryptionMode = String.valueOf(DecryptionMode);
        }
        if (Secret != null) {
            secret = String.valueOf(Secret);
        }
        if (MixResolution != null) {
            mixResolution = String.valueOf(MixResolution);
        }
        if (Idle != null) {
            idleLimitSec = Integer.parseInt(String.valueOf(Idle));
        }
        if (RecordFileRootDir != null) {
            recordFileRootDir = String.valueOf(RecordFileRootDir);
        }
        if (CfgFilePath != null) {
            cfgFilePath = String.valueOf(CfgFilePath);
        }
        if (LowUdpPort != null) {
            lowUdpPort = Integer.parseInt(String.valueOf(LowUdpPort));
        }
        if (HighUdpPort != null) {
            highUdpPort = Integer.parseInt(String.valueOf(HighUdpPort));
        }
        if (IsAudioOnly != null && Integer.parseInt(String.valueOf(IsAudioOnly)) == 1) {
            isAudioOnly = true;
        }
        if (KeepLastFrame != null) {
            this.keepLastFrame = Integer.parseInt(String.valueOf(KeepLastFrame));
        }
        if (IsVideoOnly != null && Integer.parseInt(String.valueOf(IsVideoOnly)) == 1) {
            isVideoOnly = true;
        }
        if (IsMixingEnabled != null && Integer.parseInt(String.valueOf(IsMixingEnabled)) == 1) {
            isMixingEnabled = true;
        }
        if (MixedVideoAudio != null) {
            mixedVideoAudio = Integer.parseInt(String.valueOf(MixedVideoAudio));
        }
        if (!this.checkEnumValue(mixedVideoAudio, 7, "Invalid mixedVideoAudio :" + mixedVideoAudio)) {
            return;
        }
        if (GetAudioFrame != null) {
            getAudioFrame = Integer.parseInt(String.valueOf(GetAudioFrame));
        }
        if (!this.checkEnumValue(getAudioFrame, 3, "Invalid getAudioFrame value : " + getAudioFrame)) {
            return;
        }
        if (GetVideoFrame != null) {
            getVideoFrame = Integer.parseInt(String.valueOf(GetVideoFrame));
        }
        if (!this.checkEnumValue(getVideoFrame, 5, "Invalid getVideoFrame value : " + getVideoFrame)) {
            return;
        }
        if (StreamType != null) {
            streamType = Integer.parseInt(String.valueOf(StreamType));
        }
        if (!this.checkEnumValue(streamType, 1, "Invalid streamType value : " + streamType)) {
            return;
        }
        if (CaptureInterval != null) {
            captureInterval = Integer.parseInt(String.valueOf(CaptureInterval));
        }
        if (AudioIndicationInterval != null) {
            audioIndicationInterval = Integer.parseInt(String.valueOf(AudioIndicationInterval));
        }
        if (TriggerMode != null) {
            triggerMode = Integer.parseInt(String.valueOf(TriggerMode));
        }
        if (ProxyType != null) {
            proxyType = Integer.parseInt(String.valueOf(ProxyType));
        }
        if (ProxyServer != null) {
            proxyServer = String.valueOf(ProxyServer);
        }
        if (AudioProfile != null) {
            audioProfile = Integer.parseInt(String.valueOf(AudioProfile));
        }
        if (DefaultVideoBg != null) {
            defaultVideoBgPath = String.valueOf(DefaultVideoBg);
        }
        if (DefaultUserBg != null) {
            defaultUserBgPath = String.valueOf(DefaultUserBg);
        }
        if (LogLevel != null) {
            logLevel = Integer.parseInt(String.valueOf(LogLevel));
        }
        if (LayoutMode != null) {
            this.layoutMode = Integer.parseInt(String.valueOf(LayoutMode));
        }
        if (MaxResolutionUid != null) {
            this.maxResolutionUid = Long.parseLong(String.valueOf(MaxResolutionUid));
        }
        if (MaxResolutionUserAccount != null) {
            this.maxResolutionUserAccount = String.valueOf(MaxResolutionUserAccount);
        }
        if (LocalAp != null) {
            localAp = String.valueOf(LocalAp);
        }
        if (this.userAccount.length() != 0 && this.maxResolutionUserAccount.length() == 0 && this.maxResolutionUid != -1L && this.layoutMode == 2) {
            log.info("maxResolutionUserAccount should be used when join channel with user account");
            return;
        }
        if (this.userAccount.length() == 0 && this.maxResolutionUid == 0L && this.maxResolutionUserAccount.length() != 0 && this.layoutMode == 2) {
            log.info("maxResolutionUid should be used when join channel with uid.");
            return;
        }
        if (EnableCloudProxy != null && Integer.parseInt(String.valueOf(EnableCloudProxy)) == 1) {
            enableCloudProxy = true;
        }
        if (AutoSubscribe != null && Integer.parseInt(String.valueOf(AutoSubscribe)) == 0) {
            autoSubscribe = false;
        }
        if (EnableIntraRequest != null && Integer.parseInt(String.valueOf(EnableIntraRequest)) == 0) {
            enableIntraRequest = false;
        }
        if (EnableH265Support != null && Integer.parseInt(String.valueOf(EnableH265Support)) == 1) {
            enableH265Support = true;
        }
        if (!autoSubscribe) {
            if (SubscribeVideoUids != null) {
                subscribeVideoUids = String.valueOf(SubscribeVideoUids);
                String[] struids = subscribeVideoUids.split(",");
                for (int i = 0; i < struids.length; ++i) {
                    if (this.userAccount.length() > 0) {
                        this.subscribedVideoUserAccount.add(struids[i]);
                        continue;
                    }
                    try {
                        this.subscribedVideoUids.add(Long.parseLong(struids[i]));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (SubscribeAudioUids != null) {
                subscribeAudioUids = String.valueOf(SubscribeAudioUids);
            }
        }
        if (audioProfile > 2) {
            audioProfile = 2;
        }
        if (audioProfile < 0) {
            audioProfile = 0;
        }
        RecordingConfig config = new RecordingConfig();
        config.channelProfile = Common.CHANNEL_PROFILE_TYPE.values()[channelProfile];
        config.idleLimitSec = idleLimitSec;
        config.isVideoOnly = isVideoOnly;
        config.isAudioOnly = isAudioOnly;
        config.isMixingEnabled = isMixingEnabled;
        config.mixResolution = mixResolution;
        config.mixedVideoAudio = Common.MIXED_AV_CODEC_TYPE.getByValue(mixedVideoAudio);
        config.appliteDir = applitePath;
        config.recordFileRootDir = recordFileRootDir;
        config.cfgFilePath = cfgFilePath;
        config.secret = secret;
        config.decryptionMode = decryptionMode;
        config.lowUdpPort = lowUdpPort;
        config.highUdpPort = highUdpPort;
        config.captureInterval = captureInterval;
        config.audioIndicationInterval = audioIndicationInterval;
        config.decodeAudio = Common.AUDIO_FORMAT_TYPE.values()[getAudioFrame];
        config.decodeVideo = Common.VIDEO_FORMAT_TYPE.values()[getVideoFrame];
        config.streamType = Common.REMOTE_VIDEO_STREAM_TYPE.values()[streamType];
        config.triggerMode = triggerMode;
        config.proxyType = proxyType;
        config.proxyServer = proxyServer;
        config.audioProfile = audioProfile;
        config.defaultVideoBgPath = defaultVideoBgPath;
        config.defaultUserBgPath = defaultUserBgPath;
        config.autoSubscribe = autoSubscribe;
        config.enableCloudProxy = enableCloudProxy;
        config.enableIntraRequest = enableIntraRequest;
        config.subscribeVideoUids = subscribeVideoUids;
        config.subscribeAudioUids = subscribeAudioUids;
        config.enableH265Support = enableH265Support;
        config.localAp = localAp;
        if (config.decodeVideo == Common.VIDEO_FORMAT_TYPE.VIDEO_FORMAT_ENCODED_FRAME_TYPE) {
            config.decodeVideo = Common.VIDEO_FORMAT_TYPE.VIDEO_FORMAT_H264_FRAME_TYPE;
        }
        this.config = config;
        if (logLevel < 1) {
            logLevel = 1;
        }
        if (logLevel > 6) {
            logLevel = 6;
        }
        this.isMixMode = isMixingEnabled;
        this.profile_type = Common.CHANNEL_PROFILE_TYPE.values()[channelProfile];
        if (isMixingEnabled && !isAudioOnly) {
            String[] sourceStrArray = mixResolution.split(",");
            if (sourceStrArray.length != 4) {
                log.info("Illegal resolution:" + mixResolution);
                return;
            }
            this.width = Integer.parseInt(sourceStrArray[0]);
            this.height = Integer.parseInt(sourceStrArray[1]);
            this.fps = Integer.parseInt(sourceStrArray[2]);
            this.kbps = Integer.parseInt(sourceStrArray[3]);
        }
        if ((tmpEnv = System.getenv("KEEPMEDIATIME")) != null && !tmpEnv.isEmpty()) {
            this.keepMediaTime = Integer.parseInt(tmpEnv);
            log.info("Get system env:KEEPMEDIATIME string:{}, int value:{}\n", (Object)tmpEnv, (Object)this.keepMediaTime);
        } else {
            log.info("No system env:KEEPMEDIATIME");
        }
        this.cleanTimer = new Timer();
        if (this.userAccount.length() > 0) {
            this.RecordingSDKInstance.createChannelWithUserAccount(appId, channelKey, name, this.userAccount, config, logLevel);
        } else {
            this.RecordingSDKInstance.createChannel(appId, channelKey, name, uid, config, logLevel);
        }
        this.cleanTimer.cancel();
        log.info("jni layer has been exited...");
        this.finish = true;
    }
}

