/*
 * Decompiled with CFR 0.152.
 */
package io.agora.recording;

import io.agora.recording.RecordingEventHandler;
import io.agora.recording.common.Common;
import io.agora.recording.common.RecordingConfig;
import io.agora.recording.common.RecordingEngineProperties;
import java.util.ArrayList;
import java.util.List;

public class RecordingSDK {
    private List<RecordingEventHandler> recordingEventHandlers = new ArrayList<RecordingEventHandler>();
    private long nativeHandle = 0L;
    public static int MAX_USER_ACCOUNT_LENGTH = 256;

    public void registerOberserver(RecordingEventHandler recordingEventHandler) {
        if (!this.recordingEventHandlers.contains(recordingEventHandler)) {
            this.recordingEventHandlers.add(recordingEventHandler);
        }
    }

    public void unRegisterOberserver(RecordingEventHandler recordingEventHandler) {
        this.recordingEventHandlers.remove(recordingEventHandler);
    }

    public native boolean createChannel(String var1, String var2, String var3, int var4, RecordingConfig var5, int var6);

    public native boolean createChannelWithUserAccount(String var1, String var2, String var3, String var4, RecordingConfig var5, int var6);

    public long getUidByUserAccount(String userAccount) {
        if (this.nativeHandle != 0L) {
            return this.getUidByUserAccount(this.nativeHandle, userAccount);
        }
        return 0L;
    }

    private native long getUidByUserAccount(long var1, String var3);

    public String getUserAccountByUid(int uid) {
        if (this.nativeHandle != 0L) {
            return this.getUserAccountByUid(this.nativeHandle, uid);
        }
        return "";
    }

    private native String getUserAccountByUid(long var1, int var3);

    public synchronized boolean leaveChannel() {
        if (this.nativeHandle != 0L) {
            long temp = this.nativeHandle;
            this.nativeHandle = 0L;
            return this.leaveChannel(temp);
        }
        return false;
    }

    private native boolean leaveChannel(long var1);

    public int setVideoMixingLayout(Common.VideoMixingLayout layout) {
        if (this.nativeHandle != 0L) {
            return this.setVideoMixingLayout(this.nativeHandle, layout);
        }
        return -1;
    }

    private native int setVideoMixingLayout(long var1, Common.VideoMixingLayout var3);

    public int updateWatermarkConfigs(Common.LiteraWatermarkConfig[] literaWms, Common.TimestampWatermarkConfig[] timestampWms, Common.ImageWatermarkConfig[] imgWms) {
        if (this.nativeHandle != 0L) {
            return this.updateWatermarkConfigs(this.nativeHandle, literaWms, timestampWms, imgWms);
        }
        return -1;
    }

    private native int updateWatermarkConfigs(long var1, Common.LiteraWatermarkConfig[] var3, Common.TimestampWatermarkConfig[] var4, Common.ImageWatermarkConfig[] var5);

    public int updateSubscribeVideoUids(int[] uids) {
        if (this.nativeHandle != 0L) {
            return this.updateSubscribeVideoUids(this.nativeHandle, uids);
        }
        return -1;
    }

    private native int updateSubscribeVideoUids(long var1, int[] var3);

    public int updateSubscribeAudioUids(int[] uids) {
        if (this.nativeHandle != 0L) {
            return this.updateSubscribeAudioUids(this.nativeHandle, uids);
        }
        return -1;
    }

    private native int updateSubscribeAudioUids(long var1, int[] var3);

    public int startService() {
        if (this.nativeHandle != 0L) {
            return this.startService(this.nativeHandle);
        }
        return -1;
    }

    private native int startService(long var1);

    public int stopService() {
        if (this.nativeHandle != 0L) {
            return this.stopService(this.nativeHandle);
        }
        return -1;
    }

    private native int stopService(long var1);

    public RecordingEngineProperties getProperties() {
        if (this.nativeHandle != 0L) {
            return this.getProperties(this.nativeHandle);
        }
        return null;
    }

    private native RecordingEngineProperties getProperties(long var1);

    public int setUserBackground(int uid, String imagePath) {
        if (this.nativeHandle != 0L) {
            return this.setUserBackground(this.nativeHandle, uid, imagePath);
        }
        return -1;
    }

    private native int setUserBackground(long var1, int var3, String var4);

    public void setLogLevel(int level) {
        if (this.nativeHandle != 0L) {
            this.setLogLevel(this.nativeHandle, level);
        }
    }

    private native void setLogLevel(long var1, int var3);

    private void nativeObjectRef(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    private void onLeaveChannel(int reason) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onLeaveChannel(reason);
        }
    }

    private void onError(int error, int stat_code) {
        this.nativeHandle = 0L;
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onError(error, stat_code);
        }
    }

    private void onWarning(int warn) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onWarning(warn);
        }
    }

    private void onUserOffline(long uid, int reason) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onUserOffline(uid, reason);
        }
    }

    private void onRemoteAudioStreamStateChanged(long uid, int state, int reason) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRemoteAudioStreamStateChanged(uid, Common.REMOTE_STREAM_STATE.values()[state], Common.REMOTE_STREAM_STATE_CHANGED_REASON.values()[reason]);
        }
    }

    private void onRemoteVideoStreamStateChanged(long uid, int state, int reason) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRemoteVideoStreamStateChanged(uid, Common.REMOTE_STREAM_STATE.values()[state], Common.REMOTE_STREAM_STATE_CHANGED_REASON.values()[reason]);
        }
    }

    private void onUserJoined(long uid, String recordingDir) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onUserJoined(uid, recordingDir);
        }
    }

    private void audioFrameReceived(long uid, Common.AudioFrame frame) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.audioFrameReceived(uid, frame);
        }
    }

    private void onActiveSpeaker(long uid) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onActiveSpeaker(uid);
        }
    }

    private void onAudioVolumeIndication(Common.AudioVolumeInfo[] infos) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onAudioVolumeIndication(infos);
        }
    }

    private void onReceivingStreamStatusChanged(boolean receivingAudio, boolean receivingVideo) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onReceivingStreamStatusChanged(receivingAudio, receivingVideo);
        }
    }

    private void onConnectionLost() {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onConnectionLost();
        }
    }

    private void onConnectionInterrupted() {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onConnectionInterrupted();
        }
    }

    private void onFirstRemoteVideoDecoded(long uid, int width, int height, int elapsed) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onFirstRemoteVideoDecoded(uid, width, height, elapsed);
        }
    }

    private void onFirstRemoteAudioFrame(long uid, int elapsed) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onFirstRemoteAudioFrame(uid, elapsed);
        }
    }

    private void videoFrameReceived(long uid, int type, Common.VideoFrame frame, int rotation) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.videoFrameReceived(uid, type, frame, rotation);
        }
    }

    private synchronized void stopCallBack() {
        this.nativeHandle = 0L;
    }

    private void recordingPathCallBack(String path) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.recordingPathCallBack(path);
        }
    }

    private void onJoinChannelSuccess(String channelId, long uid) {
        for (RecordingEventHandler oberserver : this.recordingEventHandlers) {
            oberserver.onJoinChannelSuccess(channelId, uid);
        }
    }

    private void onLocalUserRegistered(long uid, String userAccount) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onLocalUserRegistered(uid, userAccount);
        }
    }

    private void onUserInfoUpdated(long uid, String userAccount) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onUserInfoUpdated(uid, userAccount);
        }
    }

    void onRejoinChannelSuccess(String channelId, long uid) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRejoinChannelSuccess(channelId, uid);
        }
    }

    void onConnectionStateChanged(int state, int reason) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onConnectionStateChanged(Common.CONNECTION_STATE_TYPE.values()[state], Common.CONNECTION_CHANGED_REASON_TYPE.values()[reason]);
        }
    }

    void onRemoteVideoStats(long uid, Common.RemoteVideoStats stats) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRemoteVideoStats(uid, stats);
        }
    }

    void onRemoteAudioStats(long uid, Common.RemoteAudioStats stats) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRemoteAudioStats(uid, stats);
        }
    }

    void onRecordingStats(Common.RecordingStats stats) {
        for (RecordingEventHandler observer : this.recordingEventHandlers) {
            observer.onRecordingStats(stats);
        }
    }

    static {
        System.loadLibrary("recording");
    }
}

