/*
 * Decompiled with CFR 0.152.
 */
package io.agora.recording.common;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Common {

    public class VideoMixingLayout {
        public int canvasWidth = 0;
        public int canvasHeight = 0;
        public String backgroundColor = "";
        public int regionCount = 0;
        public Region[] regions;
        public String appData = "";
        public int appDataLength = 0;
        public int keepLastFrame = 0;
        public LiteraWatermarkConfig[] literalWms;
        public TimestampWatermarkConfig[] timestampWms;
        public ImageWatermarkConfig[] imageWms;

        public class Region {
            public long uid = 0L;
            public double x = 0.0;
            public double y = 0.0;
            public double width = 0.0;
            public double height = 0.0;
            public double alpha = 1.0;
            public int renderMode = 0;
        }
    }

    public class ImageWatermarkConfig {
        public String imagePath = "";
        public int offsetX = 0;
        public int offsetY = 0;
        public int wmWidth = 0;
        public int wmHeight = 0;
    }

    public class TimestampWatermarkConfig {
        public int fontSize = 10;
        public int offsetX = 0;
        public int offsetY = 0;
        public int wmWidth = 0;
        public int wmHeight = 0;
    }

    public class LiteraWatermarkConfig {
        public String wmLitera = "";
        public String fontFilePath = "";
        public int fontSize = 10;
        public int offsetX = 0;
        public int offsetY = 0;
        public int wmWidth = 0;
        public int wmHeight = 0;
    }

    public class AudioVolumeInfo {
        public long uid;
        public int volume;
    }

    public class UserJoinInfos {
        String storageDir = "";

        UserJoinInfos() {
        }
    }

    public class RecordingStats {
        public int duration = 0;
        public int rxBytes = 0;
        public int rxKBitRate = 0;
        public int rxAudioKBitRate = 0;
        public int rxVideoKBitRate = 0;
        public int lastmileDelay = 0;
        public int userCount = 0;
        public int cpuAppUsage = 0;
        public int cpuTotalUsage = 0;
    }

    public class RemoteAudioStats {
        public int quality = 0;
        public int networkTransportDelay = 0;
        public int jitterBufferDelay = 0;
        public int audioLossRate = 0;
    }

    public class RemoteVideoStats {
        public int delay = 0;
        public int width = 0;
        public int height = 0;
        public int receivedBitrate = 0;
        public int decoderOutputFrameRate = 0;
        public int rxStreamType = 0;
    }

    public class VideoFrame {
        public VideoYuvFrame yuv;
        public VideoH264Frame h264;
        public VideoH265Frame h265;
        public VideoJpgFrame jpg;
        public VideoJpgFile jpg_file;
        public int rotation;
    }

    public class VideoJpgFile {
        public long frame_ms = 0L;
        public String file_name = "";

        VideoJpgFile() {
        }
    }

    public class VideoJpgFrame {
        public long frame_ms = 0L;
        public byte[] buf;
        public long bufSize = 0L;

        VideoJpgFrame() {
        }
    }

    public class VideoH265Frame {
        public long frame_ms = 0L;
        public long frame_num = 0L;
        public byte[] buf;
        public long bufSize = 0L;

        VideoH265Frame() {
        }
    }

    public class VideoH264Frame {
        public long frame_ms = 0L;
        public long frame_num = 0L;
        public byte[] buf;
        public long bufSize = 0L;

        VideoH264Frame() {
        }
    }

    public class VideoYuvFrame {
        public long frame_ms;
        public ByteBuffer ybuf;
        public ByteBuffer ubuf;
        public ByteBuffer vbuf;
        public int width;
        public int height;
        public int ystride;
        public int ustride;
        public int vstride;
        public byte[] buf;
        public long bufSize;

        VideoYuvFrame(long framems, int width, int height, int ystride, int ustride, int vstride) {
            this.frame_ms = framems;
            this.width = width;
            this.height = height;
            this.ystride = ystride;
            this.ustride = ustride;
            this.vstride = vstride;
        }
    }

    public class AudioAacFrame {
        public long frame_ms;
        public byte[] aacBuf;
        public long aacBufSize;
        public int channels;
        public int bitrate;

        public AudioAacFrame(long framems) {
            this.frame_ms = framems;
            this.aacBufSize = 0L;
        }
    }

    public class AudioPcmFrame {
        public long frame_ms;
        public long channels;
        public long sample_bits;
        public long sample_rates;
        public long samples;
        public byte[] pcmBuf;
        public long pcmBufSize;

        public AudioPcmFrame(long frame_ms, long sample_rates, long samples) {
        }
    }

    public class AudioFrame {
        public AUDIO_FRAME_TYPE type;
        public AudioPcmFrame pcm;
        public AudioAacFrame aac;
    }

    public static enum agora_log_level {
        AGORA_LOG_LEVEL_FATAL(1),
        AGORA_LOG_LEVEL_ERROR(2),
        AGORA_LOG_LEVEL_WARN(3),
        AGORA_LOG_LEVEL_NOTICE(4),
        AGORA_LOG_LEVEL_INFO(5),
        AGORA_LOG_LEVEL_DEBUG(6);

        private int value;

        private agora_log_level(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum AUDIO_PROFILE_TYPE {
        AUDIO_PROFILE_DEFAULT(0),
        AUDIO_PROFILE_HIGH_QUALITY(1),
        AUDIO_PROFILE_HIGH_QUALITY_STEREO(2);

        private int value;

        private AUDIO_PROFILE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TRIGGER_MODE_TYPE {
        AUTOMATICALLY_MODE(0),
        MANUALLY_MODE(1);

        private int value;

        private TRIGGER_MODE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MIXED_AV_CODEC_TYPE {
        MIXED_AV_DEFAULT(0),
        MIXED_AV_CODEC_V1(1),
        MIXED_AV_CODEC_V2(2),
        AV_CODEC_INDIVIDUAL_TS_ONLY(4),
        AV_CODEC_INDIVIDUAL_TS_AND_MP4(5),
        AV_CODEC_MIXED_TS_ONLY(6),
        AV_CODEC_MIXED_TS_AND_MP4(7);

        private int value;

        private MIXED_AV_CODEC_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MIXED_AV_CODEC_TYPE getByValue(int value) {
            return Arrays.stream(MIXED_AV_CODEC_TYPE.values()).filter(e -> e.getValue() == value).findFirst().orElse(MIXED_AV_DEFAULT);
        }
    }

    public class VIDEO_FRAME_TYPE {
        public final int VIDEO_FRAME_RAW_YUV = 0;
        public final int VIDEO_FRAME_H264 = 1;
        public final int VIDEO_FRAME_JPG = 2;
        public final int VIDEO_FRAME_H265 = 3;
        public final int VIDEO_JPG_FILE = 4;
        public int type = 0;

        public int getValue() {
            return this.type;
        }
    }

    public static enum AUDIO_FRAME_TYPE {
        AUDIO_FRAME_RAW_PCM,
        AUDIO_FRAME_AAC;

    }

    public static enum AUDIO_FORMAT_TYPE {
        AUDIO_FORMAT_DEFAULT_TYPE(0),
        AUDIO_FORMAT_AAC_FRAME_TYPE(1),
        AUDIO_FORMAT_PCM_FRAME_TYPE(2),
        AUDIO_FORMAT_MIXED_PCM_FRAME_TYPE(3);

        private int value;

        private AUDIO_FORMAT_TYPE(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum VIDEO_FORMAT_TYPE {
        VIDEO_FORMAT_DEFAULT_TYPE(0),
        VIDEO_FORMAT_H264_FRAME_TYPE(1),
        VIDEO_FORMAT_YUV_FRAME_TYPE(2),
        VIDEO_FORMAT_JPG_FRAME_TYPE(3),
        VIDEO_FORMAT_JPG_FILE_TYPE(4),
        VIDEO_FORMAT_JPG_VIDEO_FILE_TYPE(5),
        VIDEO_FORMAT_ENCODED_FRAME_TYPE(6);

        private int value;

        private VIDEO_FORMAT_TYPE(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }
    }

    public static enum SERVICE_MODE {
        RECORDING_MODE(0),
        SERVER_MODE(1),
        IOT_MODE(2);


        private SERVICE_MODE(int value) {
        }
    }

    public static enum REMOTE_VIDEO_STREAM_TYPE {
        REMOTE_VIDEO_STREAM_HIGH(0),
        REMOTE_VIDEO_STREAM_LOW(1);

        private int value;

        private REMOTE_VIDEO_STREAM_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum USER_OFFLINE_REASON_TYPE {
        USER_OFFLINE_QUIT(0),
        USER_OFFLINE_DROPPED(1),
        USER_OFFLINE_BECOME_AUDIENCE(2);


        private USER_OFFLINE_REASON_TYPE(int code) {
        }
    }

    public static enum CONNECTION_CHANGED_REASON_TYPE {
        CONNECTION_CHANGED_CONNECTING(0),
        CONNECTION_CHANGED_JOIN_SUCCESS(1),
        CONNECTION_CHANGED_INTERRUPTED(2),
        CONNECTION_CHANGED_BANNED_BY_SERVER(3),
        CONNECTION_CHANGED_JOIN_FAILED(4),
        CONNECTION_CHANGED_LEAVE_CHANNEL(5);

        private int value;

        private CONNECTION_CHANGED_REASON_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CONNECTION_STATE_TYPE {
        CONNECTION_STATE_DISCONNECTED(1),
        CONNECTION_STATE_CONNECTING(2),
        CONNECTION_STATE_CONNECTED(3),
        CONNECTION_STATE_RECONNECTING(4),
        CONNECTION_STATE_FAILED(5);

        private int value;

        private CONNECTION_STATE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CHANNEL_PROFILE_TYPE {
        CHANNEL_PROFILE_COMMUNICATION(0),
        CHANNEL_PROFILE_LIVE_BROADCASTING(1);

        private int value;

        private CHANNEL_PROFILE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum WARN_CODE_TYPE {
        WARN_NO_AVAILABLE_CHANNEL(103),
        WARN_LOOKUP_CHANNEL_TIMEOUT(104),
        WARN_LOOKUP_CHANNEL_REJECTED(105),
        WARN_OPEN_CHANNEL_TIMEOUT(106),
        WARN_OPEN_CHANNEL_REJECTED(107),
        WARN_RECOVERY_CORE_SERVICE_FAILURE(108);


        private WARN_CODE_TYPE(int value) {
        }
    }

    public static enum REMOTE_STREAM_STATE_CHANGED_REASON {
        REASON_REMOTE_STREAM_STARTED(0),
        REASON_REMOTE_STREAM_STOPPED(1);

        private int value;

        private REMOTE_STREAM_STATE_CHANGED_REASON(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum REMOTE_STREAM_STATE {
        REMOTE_STREAM_STATE_RUNNING(0),
        REMOTE_STREAM_STATE_STOPPED(1);

        private int value;

        private REMOTE_STREAM_STATE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LEAVE_PATH_CODE {
        LEAVE_CODE_INIT(0),
        LEAVE_CODE_SIG(2),
        LEAVE_CODE_NO_USERS(4),
        LEAVE_CODE_TIMER_CATCH(8),
        LEAVE_CODE_CLIENT_LEAVE(16);


        private LEAVE_PATH_CODE(int code) {
        }
    }

    public static enum STAT_CODE_TYPE {
        STAT_OK(0),
        STAT_ERR_FROM_ENGINE(1),
        STAT_ERR_ARS_JOIN_CHANNEL(2),
        STAT_ERR_CREATE_PROCESS(3),
        STAT_ERR_MIXED_INVALID_VIDEO_PARAM(4),
        STAT_ERR_NULL_POINTER(5),
        STAT_ERR_PROXY_SERVER_INVALID_PARAM(6),
        STAT_POLL_ERR(8),
        STAT_POLL_HANG_UP(16),
        STAT_POLL_NVAL(32);


        private STAT_CODE_TYPE(int value) {
        }
    }

    public static enum ERROR_CODE_TYPE {
        ERR_OK(0),
        ERR_FAILED(1),
        ERR_INVALID_ARGUMENT(2),
        ERR_INTERNAL_FAILED(3);

        private int value;

        private ERROR_CODE_TYPE(int value) {
        }

        public int getValue() {
            return this.value;
        }
    }
}

