/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.log.controller;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.fczx.log.data.EsPageParam;
import com.geoway.fczx.log.data.EsPageResult;
import com.geoway.fczx.log.data.SystemLogVo;
import com.geoway.fczx.log.entity.EsDevEvent;
import com.geoway.fczx.log.entity.EsDevOsd;
import com.geoway.fczx.log.entity.SysLogInfo;
import com.geoway.fczx.log.service.EsLogService;
import com.geoway.fczx.log.service.ILogService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u65e5\u5fd7\u670d\u52a1\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/log/v1"})
public class LogController {
    @Autowired(required=false)
    private ILogService logService;
    @Resource
    private EsLogService esLogService;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5fd7")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", value="\u7528\u6237\u540d", paramType="query", dataType="String"), @ApiImplicitParam(name="client", value="ip\u5730\u5740", paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataType="Long"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataType="Long")})
    @GetMapping(value={"/system"})
    public ResponseEntity<BaseResponse> getLogs(SystemLogVo param) {
        if (ObjectUtil.isNull((Object)param.getPageNum()) && ObjectUtil.isNull((Object)param.getPageSize())) {
            List<SysLogInfo> resList = this.logService.getLogs(param);
            return ObjectResponse.ok(resList);
        }
        PageInfo<SysLogInfo> pageInfo = this.logService.getPageLogs(param);
        return ObjectResponse.ok(pageInfo);
    }

    @ApiOperation(value="\u83b7\u53d6OSD\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8bbe\u5907SN\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="filterTrack", value="\u8fc7\u6ee4\u8f68\u8ff9", paramType="query", dataType="Boolean"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataType="Long"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataType="Long")})
    @ApiOperationSupport(order=2, ignoreParameters={"param"})
    @GetMapping(value={"/osd/logs"})
    public ResponseEntity<BaseResponse> getOsdLogs(@RequestParam(required=false) Map<String, Object> param, EsPageParam page, Boolean filterTrack) {
        EsPageResult<EsDevOsd> datalist = this.esLogService.getPageOsdLogs(param, page);
        if (param.containsKey("filterTrack") && BooleanUtil.isTrue((Boolean)filterTrack)) {
            ArrayList list = new ArrayList();
            datalist.getContent().forEach(data -> {
                Map<String, Object> track = data.convertTrackDto();
                if (track != null) {
                    list.add(track);
                }
            });
            return ObjectResponse.ok(new EsPageResult(list, datalist.getSize(), datalist.getTotal(), datalist.getNextSearchAfter()));
        }
        return ObjectResponse.ok(datalist);
    }

    @ApiOperation(value="\u83b7\u53d6\u901a\u4fe1\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8bbe\u5907SN\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="event", value="\u65f6\u95f4\u7c7b\u578b", paramType="query", dataType="String"), @ApiImplicitParam(name="bid", value="\u4e1a\u52a1\u6807\u8bc6", paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataType="Long"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataType="Long")})
    @ApiOperationSupport(order=3, ignoreParameters={"param"})
    @GetMapping(value={"/event/logs"})
    public ResponseEntity<BaseResponse> getEventLogs(Long startTime, Long endTime, @RequestParam(required=false) Map<String, Object> param, EsPageParam page) {
        String[] keys;
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        for (String key : keys = new String[]{"sn", "event", "bid"}) {
            if (!ObjectUtil.isEmpty((Object)param.get(key))) continue;
            param.remove(key);
        }
        EsPageResult<EsDevEvent> datalist = this.esLogService.getPageEventLogs(param, page);
        return ObjectResponse.ok(datalist);
    }

    @ApiIgnore
    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7\u89c4\u5219")
    @ApiOperationSupport(order=4)
    @DeleteMapping(value={"/mqtt/es/rule"})
    public ResponseEntity<BaseResponse> removeMqttEsRule() {
        boolean flag = this.esLogService.removeMqttEsRule();
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u65e5\u5fd7\u89c4\u5219\u5931\u8d25");
    }

    @ApiOperation(value="\u5bfc\u51faOSD\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8bbe\u5907SN\u7801", paramType="query", dataType="String", required=true), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true)})
    @ApiOperationSupport(order=5, ignoreParameters={"param"})
    @GetMapping(value={"/osd/logs/export"})
    public void exportOsdLogs(String sn, Long startTime, Long endTime, HttpServletResponse response) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{sn, startTime, endTime})) {
            this.esLogService.exportOsdLogs(response, sn, startTime, endTime);
        } else {
            FczxLiveTool.responseError((HttpServletResponse)response, (String)JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u901a\u4fe1\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="event", value="\u901a\u4fe1\u4e8b\u4ef6", paramType="query", dataType="String"), @ApiImplicitParam(name="bid", value="\u5173\u8054\u6807\u8bc6", paramType="query", dataType="String"), @ApiImplicitParam(name="sn", value="\u8bbe\u5907SN\u7801", paramType="query", dataType="String", required=true), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true)})
    @ApiOperationSupport(order=5, ignoreParameters={"param"})
    @GetMapping(value={"/event/logs/export"})
    public void exportEventLogs(String sn, Long startTime, Long endTime, @RequestParam Map<String, Object> param, HttpServletResponse response) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{sn, startTime, endTime})) {
            param.put("startTime", startTime);
            param.put("endTime", endTime);
            this.esLogService.exportEventLogs(response, startTime, endTime, param);
        } else {
            FczxLiveTool.responseError((HttpServletResponse)response, (String)JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u7cfb\u7edf\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", value="\u7528\u6237\u540d", paramType="query", dataType="String"), @ApiImplicitParam(name="client", value="ip\u5730\u5740", paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataTypeClass=Long.class, required=true)})
    @ApiOperationSupport(order=1, ignoreParameters={"param"})
    @GetMapping(value={"/system/logs/export"})
    public void exportSystemLogs(@RequestParam Map<String, Object> param, Long startTime, Long endTime, HttpServletResponse response) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{startTime, endTime})) {
            param.put("startTime", startTime);
            param.put("endTime", endTime);
            this.logService.exportSystemLogs(response, param);
        } else {
            FczxLiveTool.responseError((HttpServletResponse)response, (String)JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a").getBody()));
        }
    }

    @ApiOperation(value="mqtt\u4e1a\u52a1\u6062\u590d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8bbe\u5907SN\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="event", value="\u65f6\u95f4\u7c7b\u578b", paramType="query", dataType="String"), @ApiImplicitParam(name="bid", value="\u4e1a\u52a1\u6807\u8bc6", paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataType="Long"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", paramType="query", dataType="Long")})
    @ApiOperationSupport(order=7, ignoreParameters={"param"})
    @PostMapping(value={"/mqtt/recovery"})
    public ResponseEntity<BaseResponse> mqttLogRecovery(Long startTime, Long endTime, @RequestParam(required=false) Map<String, Object> param, EsPageParam page) {
        if (this.logService != null) {
            String[] keys;
            param.put("startTime", startTime);
            param.put("endTime", endTime);
            for (String key : keys = new String[]{"sn", "event", "bid"}) {
                if (!ObjectUtil.isEmpty((Object)param.get(key))) continue;
                param.remove(key);
            }
            EsPageResult<EsDevEvent> datalist = this.esLogService.getPageEventLogs(param, page);
            if (ObjectUtil.isNotEmpty(datalist.getContent())) {
                datalist.getContent().forEach(log -> this.logService.mqttLogRecovery(log.getTopic(), log.getPayload()));
            }
        }
        return ObjectResponse.ok();
    }
}

