/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.log.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.log.annotation.FczxLog;
import com.geoway.fczx.log.entity.SysLogInfo;
import com.geoway.fczx.log.service.ILogService;
import com.geoway.ue.common.util.HttpTool;
import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=99)
@Component
public class FczxLogAspectHandler {
    private static final Logger log = LoggerFactory.getLogger(FczxLogAspectHandler.class);
    private static final ThreadLocal<SysLogInfo> logThreadLocal = new NamedThreadLocal("ThreadLocal log");
    @Resource
    private HttpServletRequest request;
    @Autowired(required=false)
    private ILogService ILogService;

    @PostConstruct
    private void init() {
        log.debug("\u521d\u59cb\u5316\u7cfb\u7edf\u65e5\u5fd7\u5207\u9762");
    }

    @Pointcut(value="@annotation(com.geoway.fczx.log.annotation.FczxLog)")
    public void fczxLogAspect() {
    }

    @Before(value="fczxLogAspect()")
    public void doBefore(JoinPoint joinPoint) {
        String username = "adminPC";
        SysLogInfo logInfo = this.getControllerMethodLogInfo(joinPoint);
        logInfo.setClient(HttpTool.getRealIpAddress((HttpServletRequest)this.request));
        logInfo.setUsername(username);
        logThreadLocal.set(logInfo);
    }

    @AfterReturning(returning="res", pointcut="fczxLogAspect()")
    public void doAfterReturning(Object res) {
        SysLogInfo logInfo = logThreadLocal.get();
        if (logInfo != null) {
            if (res != null) {
                if (res instanceof ResponseEntity) {
                    ResponseEntity response = (ResponseEntity)res;
                    if (ObjectUtil.equal((Object)HttpStatus.OK.value(), (Object)response.getStatusCodeValue())) {
                        logInfo.setResult(1);
                    } else {
                        logInfo.setResult(0);
                        logInfo.setError(JSONUtil.toJsonStr((Object)response.getBody()));
                    }
                }
            } else {
                logInfo.setResult(1);
            }
            this.insertLog(logInfo);
        }
    }

    @AfterThrowing(pointcut="fczxLogAspect()", throwing="e")
    public void doAfterThrowing(Throwable e) {
        SysLogInfo logInfo = logThreadLocal.get();
        if (logInfo != null) {
            logInfo.setResult(0);
            logInfo.setError(e.getMessage());
            this.insertLog(logInfo);
        }
    }

    public SysLogInfo getControllerMethodLogInfo(JoinPoint joinPoint) {
        SysLogInfo systemLog = new SysLogInfo();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        FczxLog log = method.getAnnotation(FczxLog.class);
        systemLog.setVisitTime(new Date().getTime());
        systemLog.setDesc(log.Desc());
        systemLog.setType(log.OpType());
        return systemLog;
    }

    public void insertLog(SysLogInfo logInfo) {
        logInfo.setFinishTime(new Date().getTime());
        this.ILogService.saveSystemLog(logInfo);
    }
}

