/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.log.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.live.data.mqtt.Connector;
import com.geoway.fczx.live.data.mqtt.ConnectorAction;
import com.geoway.fczx.live.data.mqtt.FlowRule;
import com.geoway.fczx.live.data.property.EmqxProperties;
import com.geoway.fczx.live.thirdapi.emqx.EmqxRestService;
import com.geoway.fczx.live.util.FczxLiveTool;
import com.geoway.fczx.log.data.EsPageParam;
import com.geoway.fczx.log.data.EsPageResult;
import com.geoway.fczx.log.entity.EsDevEvent;
import com.geoway.fczx.log.entity.EsDevOsd;
import com.geoway.fczx.log.util.EsSearchAfterPager;
import com.geoway.ue.common.data.page.PageDto;
import com.geoway.ue.common.data.response.BaseResponse;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class EsLogService {
    private static final Logger log = LoggerFactory.getLogger(EsLogService.class);
    @Resource
    private Environment environment;
    @Autowired(required=false)
    private EmqxProperties emqxProperties;
    @Autowired(required=false)
    private EmqxRestService emqxRestService;
    @Resource
    private ElasticsearchProperties properties;
    @Resource
    private ElasticsearchOperations esOperation;
    @Resource
    private EsSearchAfterPager esSearchAfterPager;

    @PostConstruct
    public void init() {
        this.createIndices();
        this.createMqttToEsRule();
    }

    public void createIndices() {
        try {
            IndexOperations indexOps2;
            if (ObjectUtil.isEmpty((Object)this.environment.getProperty("spring.elasticsearch.uris"))) {
                return;
            }
            IndexOperations indexOps = this.esOperation.indexOps(EsDevOsd.class);
            if (!indexOps.exists()) {
                indexOps.create();
                indexOps.putMapping(indexOps.createMapping());
                log.info("EsDevOsd\u7d22\u5f15\u521b\u5efa\u6210\u529f");
            }
            if (!(indexOps2 = this.esOperation.indexOps(EsDevEvent.class)).exists()) {
                indexOps2.create();
                indexOps2.putMapping(indexOps2.createMapping());
                log.info("EsDevEvent\u7d22\u5f15\u521b\u5efa\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
    }

    public void createMqttToEsRule() {
        if (ObjectUtil.isEmpty((Object)this.environment.getProperty("spring.elasticsearch.uris"))) {
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)this.emqxProperties.getServerApiUrl())) {
            Object connector = this.emqxRestService.existConnect(this.emqxProperties, "http:log_to_es");
            if (ObjectUtil.isEmpty((Object)connector) && ObjectUtil.isNotEmpty((Object)this.properties.getUris())) {
                String basic = null;
                if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{this.properties.getUsername(), this.properties.getPassword()})) {
                    String auth = this.properties.getUsername().concat(":").concat(this.properties.getPassword());
                    basic = "Bearer " + Base64Utils.encodeToString((byte[])auth.getBytes());
                }
                String url = (String)this.properties.getUris().get(0);
                Connector con = new Connector("log_to_es", url, null, basic);
                con.setDescription("\u6d88\u606f\u8f6c\u53d1\u5230ES\u4f5c\u4e3a\u65e5\u5fd7");
                String error = this.emqxRestService.createConnect(this.emqxProperties, con);
                if (ObjectUtil.isEmpty((Object)error)) {
                    log.error("\u521b\u5efa{}\u8fde\u63a5\u5668\u5931\u8d25", (Object)"log_to_es");
                    return;
                }
            }
            this.buildLogRule("log_to_es", "osd_data", "osd_to_es", "SELECT\n  payload as payload,\n  payload.gateway as gateway,\n  payload.timestamp as timestamp,\n  replace(replace(topic,'thing/product/', '', 'all'),'/osd', '', 'all') as sn\nFROM\n  \"thing/product/+/osd\"\nWHERE replace(replace(topic,'thing/product/', '', 'all'),'/osd', '', 'all') != payload.gateway", "{\n  \"sn\": \"${sn}\",\n  \"gateway\": \"${gateway}\",\n  \"timestamp\": ${timestamp},\n  \"payload\": ${payload}\n}", "osd\u4fe1\u606f\u8f6c\u53d1\u5230es\u5b58\u50a8\u4e3a\u65e5\u5fd7");
            this.buildLogRule("log_to_es", "event_data", "hms_to_es", "SELECT\n    topic as topic,\n    payload as payload,\n    payload.bid as bid,\n    payload.method as event,\n    payload.gateway as gateway,\n    payload.timestamp as timestamp,\n  nth(3,split(topic, '/'))  as sn\n  FROM\n    \"thing/product/+/events\"\n  WHERE\n    payload.method = 'hms' AND length(payload.data.list)>0", "{\n  \"sn\": \"${sn}\",\n  \"bid\": \"${bid}\",\n  \"event\": \"${event}\",\n  \"topic\": \"${topic}\",\n  \"gateway\": \"${gateway}\",\n  \"timestamp\": ${timestamp},\n  \"payload\": ${payload}\n}", "\u544a\u8b66\u4fe1\u606f\u8f6c\u53d1\u5230es\u5b58\u50a8\u4e3a\u65e5\u5fd7");
            this.buildLogRule("log_to_es", "event_data", "comm_to_es", "SELECT\n    topic as topic,\n    payload as payload,\n    payload.bid as bid,\n    payload.method as event,\n    payload.gateway as gateway,\n    payload.timestamp as timestamp,\n    nth(3,split(topic, '/'))  as sn\n  FROM\n    \"thing/product/+/requests\",\n    \"thing/product/+/requests_reply\",\n    \"thing/product/+/services\",\n    \"thing/product/+/services_reply\",\n    \"thing/product/+/events_reply\",\n    \"thing/product/+/drc/up\",\n    \"thing/product/+/drc/down\"", "{\n  \"sn\": \"${sn}\",\n  \"bid\": \"${bid}\",\n  \"event\": \"${event}\",\n  \"topic\": \"${topic}\",\n  \"gateway\": \"${gateway}\",\n  \"timestamp\": ${timestamp},\n  \"payload\": ${payload}\n}", "\u901a\u4fe1\u4fe1\u606f\u8f6c\u53d1\u5230es\u5b58\u50a8\u4e3a\u65e5\u5fd7");
            this.buildLogRule("log_to_es", "event_data", "event_to_es", "SELECT\n    topic as topic,\n    payload as payload,\n    payload.bid as bid,\n    payload.method as event,\n    payload.gateway as gateway,\n    payload.timestamp as timestamp,\n    nth(3,split(topic, '/'))  as sn\n  FROM\n  \"thing/product/+/events\"\n  WHERE\n    payload.method != 'hms' and payload.method != 'dji_flight_device_sync'", "{\n  \"sn\": \"${sn}\",\n  \"bid\": \"${bid}\",\n  \"event\": \"${event}\",\n  \"topic\": \"${topic}\",\n  \"gateway\": \"${gateway}\",\n  \"timestamp\": ${timestamp},\n  \"payload\": ${payload}\n}", "event\u4fe1\u606f\u8f6c\u53d1\u5230es\u5b58\u50a8\u4e3a\u65e5\u5fd7");
        }
    }

    public boolean removeMqttEsRule() {
        if (ObjectUtil.isNotEmpty((Object)this.emqxProperties.getServerApiUrl())) {
            this.emqxRestService.removeFlowRule(this.emqxProperties, "osd_to_es");
            this.emqxRestService.removeFlowRule(this.emqxProperties, "hms_to_es");
            this.emqxRestService.removeFlowRule(this.emqxProperties, "comm_to_es");
            this.emqxRestService.removeFlowRule(this.emqxProperties, "event_to_es");
            this.emqxRestService.removeAction(this.emqxProperties, String.format("http:%s", "osd_to_es"));
            this.emqxRestService.removeAction(this.emqxProperties, String.format("http:%s", "hms_to_es"));
            this.emqxRestService.removeAction(this.emqxProperties, String.format("http:%s", "comm_to_es"));
            this.emqxRestService.removeAction(this.emqxProperties, String.format("http:%s", "event_to_es"));
            this.emqxRestService.removeConnect(this.emqxProperties, String.format("http:%s", "log_to_es"));
            return true;
        }
        return false;
    }

    private void buildLogRule(String connector, String index, String ruleId, String sql, String body, String desc) {
        List list = this.emqxRestService.existRuleById(this.emqxProperties, ruleId);
        if (ObjectUtil.isEmpty((Object)list)) {
            String path = String.format("/%s/_doc", index);
            ConnectorAction action = new ConnectorAction(connector, ruleId, path, body);
            action.setDescription(desc);
            String error = this.emqxRestService.createAction(this.emqxProperties, action);
            if (ObjectUtil.isEmpty((Object)error)) {
                log.error("\u521b\u5efa{}\u8fde\u63a5\u5668\u52a8\u4f5c\u5931\u8d25", (Object)ruleId);
                return;
            }
            FlowRule rule = FlowRule.simpleLogRule((String)ruleId, (String)ruleId, (String)sql);
            rule.setDescription(desc);
            Object res = this.emqxRestService.createRealRule(this.emqxProperties, rule);
            if (ObjectUtil.isEmpty((Object)res)) {
                log.error("\u521b\u5efa{}\u89c4\u5219\u5931\u8d25", (Object)ruleId);
                return;
            }
        }
        log.info("\u5df2\u7ecf\u63a5\u5165{}\u65e5\u5fd7\u91c7\u96c6", (Object)ruleId);
    }

    private BoolQueryBuilder buildQueryBuilder(Map<String, Object> params, Object fuzzy, List<String> fields) {
        BoolQueryBuilder builder = new BoolQueryBuilder();
        HashSet<String> keys = new HashSet<String>(params.keySet());
        keys.remove("nextSearchAfter");
        keys.remove("filterTrack");
        keys.remove("fuzzyQuery");
        keys.remove("startTime");
        keys.remove("endTime");
        keys.remove("size");
        if (ObjectUtil.isNotEmpty(keys)) {
            Boolean enable = (Boolean)this.environment.getProperty("com.geoway.fczx.debug.es-keyword-enable", Boolean.class, (Object)false);
            keys.forEach(k -> builder.must((QueryBuilder)QueryBuilders.termQuery((String)(enable != false ? k.concat(".keyword") : k), params.get(k))));
        }
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{params.get("startTime"), params.get("endTime")})) {
            try {
                RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"timestamp");
                rangeQuery.gte(params.get("startTime"));
                rangeQuery.lte(params.get("endTime"));
                builder.must((QueryBuilder)rangeQuery);
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u89e3\u6790\u5931\u8d25");
                return builder;
            }
        }
        if (ObjectUtil.isNotEmpty((Object)fuzzy)) {
            BoolQueryBuilder bool = new BoolQueryBuilder();
            String fuzzyQuery = "*".concat(String.valueOf(fuzzy)).concat("*");
            fields.forEach(filed -> bool.should((QueryBuilder)QueryBuilders.wildcardQuery((String)filed, (String)fuzzyQuery)));
            builder.must((QueryBuilder)bool);
        }
        return builder;
    }

    public List<EsDevOsd> getOsdLogsScroll(PageDto params) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        BoolQueryBuilder builder = this.buildQueryBuilder(params.getParams(), params.getFuzzyQuery(), Collections.singletonList("sn"));
        queryBuilder.withPageable(Pageable.ofSize((int)10000));
        NativeSearchQuery query = queryBuilder.withQuery((QueryBuilder)builder).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"timestamp").order(SortOrder.DESC)}).build();
        long count = this.esOperation.count((Query)query, EsDevOsd.class);
        ArrayList<EsDevOsd> list = new ArrayList<EsDevOsd>();
        if (count > 10000L) {
            try (SearchHitsIterator stream = this.esOperation.searchForStream((Query)query, EsDevOsd.class);){
                while (stream.hasNext()) {
                    list.add((EsDevOsd)((SearchHit)stream.next()).getContent());
                }
            }
        } else {
            SearchHits search = this.esOperation.search((Query)query, EsDevOsd.class);
            if (!search.isEmpty()) {
                search.forEach(item -> list.add((EsDevOsd)item.getContent()));
            }
        }
        return list;
    }

    public List<EsDevEvent> getEventLogsScroll(PageDto params) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        BoolQueryBuilder builder = this.buildQueryBuilder(params.getParams(), params.getFuzzyQuery(), Arrays.asList("sn", "event", "bid"));
        queryBuilder.withPageable(Pageable.ofSize((int)10000));
        NativeSearchQuery query = queryBuilder.withQuery((QueryBuilder)builder).withSorts(new SortBuilder[]{SortBuilders.fieldSort((String)"timestamp").order(SortOrder.DESC)}).build();
        long count = this.esOperation.count((Query)query, EsDevOsd.class);
        ArrayList<EsDevEvent> list = new ArrayList<EsDevEvent>();
        if (count > 10000L) {
            try (SearchHitsIterator stream = this.esOperation.searchForStream((Query)query, EsDevEvent.class);){
                while (stream.hasNext()) {
                    list.add((EsDevEvent)((SearchHit)stream.next()).getContent());
                }
            }
        } else {
            SearchHits search = this.esOperation.search((Query)query, EsDevEvent.class);
            if (!search.isEmpty()) {
                search.forEach(item -> list.add((EsDevEvent)item.getContent()));
            }
        }
        return list;
    }

    public EsPageResult<EsDevOsd> getPageOsdLogs(Map<String, Object> params, EsPageParam page) {
        BoolQueryBuilder builder = this.buildQueryBuilder(params, null, null);
        SortBuilder[] sorts = new SortBuilder[]{SortBuilders.fieldSort((String)"timestamp").order(SortOrder.DESC)};
        return this.esSearchAfterPager.searchAfterPage((QueryBuilder)builder, page.getSize(), page.getNextSearchAfter(), EsDevOsd.class, sorts);
    }

    public EsPageResult<EsDevEvent> getPageEventLogs(Map<String, Object> params, EsPageParam page) {
        BoolQueryBuilder builder = this.buildQueryBuilder(params, null, null);
        SortBuilder[] sorts = new SortBuilder[]{SortBuilders.fieldSort((String)"timestamp").order(SortOrder.DESC)};
        return this.esSearchAfterPager.searchAfterPage((QueryBuilder)builder, page.getSize(), page.getNextSearchAfter(), EsDevEvent.class, sorts);
    }

    public void exportOsdLogs(HttpServletResponse response, String sn, Long startTime, Long endTime) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sn", sn);
        param.put("endTime", endTime);
        param.put("startTime", startTime);
        PageDto dto = new PageDto();
        dto.setKeyword(param);
        List<EsDevOsd> list = this.getOsdLogsScroll(dto);
        if (ObjectUtil.isEmpty(list)) {
            FczxLiveTool.responseError((HttpServletResponse)response, (String)JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u672a\u627e\u5230\u98de\u884c\u65e5\u5fd7\u6570\u636e").getBody()));
            return;
        }
        JSONArray array = new JSONArray(list);
        String start = DateUtil.format((Date)new Date(startTime), (String)"yyyyMMddHHmmss");
        String end = DateUtil.format((Date)new Date(endTime), (String)"yyyyMMddHHmmss");
        String name = "\u98de\u884c\u65e5\u5fd7" + start + "_" + end;
        response.setContentType("application/force-download");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String path = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + ".txt";
        try {
            FileUtil.newFile((String)path);
            FileUtil.writeLines((Collection)((Collection)array.getByPath("payload", List.class)), (File)FileUtil.file((String)path), (Charset)StandardCharsets.UTF_8);
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(name + ".txt", "UTF-8"));
            IoUtil.copy((InputStream)FileUtil.getInputStream((String)path), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u98de\u884c\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            FileUtil.del((String)path);
        }
    }

    public void exportEventLogs(HttpServletResponse response, Long startTime, Long endTime, Map<String, Object> param) {
        PageDto dto = new PageDto();
        dto.setKeyword(param);
        List<EsDevEvent> list = this.getEventLogsScroll(dto);
        if (ObjectUtil.isEmpty(list)) {
            FczxLiveTool.responseError((HttpServletResponse)response, (String)JSONUtil.toJsonStr((Object)BaseResponse.error((String)"\u672a\u627e\u5230\u901a\u4fe1\u65e5\u5fd7\u6570\u636e").getBody()));
            return;
        }
        JSONArray array = new JSONArray(list);
        String start = DateUtil.format((Date)new Date(startTime), (String)"yyyyMMddHHmmss");
        String end = DateUtil.format((Date)new Date(endTime), (String)"yyyyMMddHHmmss");
        String name = "\u901a\u4fe1\u65e5\u5fd7" + start + "_" + end;
        response.setContentType("application/force-download");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String path = System.getProperty("user.dir") + "/" + IdUtil.fastSimpleUUID() + ".txt";
        BufferedInputStream inputStream = null;
        try {
            FileUtil.newFile((String)path);
            FileUtil.writeLines((Collection)((Collection)array.getByPath("payload", List.class)), (File)FileUtil.file((String)path), (Charset)StandardCharsets.UTF_8);
            response.setHeader("Content-Disposition", "attachment;Filename=" + URLEncoder.encode(name + ".txt", "UTF-8"));
            inputStream = FileUtil.getInputStream((String)path);
            IoUtil.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            try {
                log.error("\u4e0b\u8f7d\u901a\u4fe1\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(inputStream);
                FileUtil.del((String)path);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)inputStream);
        FileUtil.del((String)path);
    }
}

