/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.log.util;

import com.geoway.fczx.log.data.EsPageResult;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;

public class EsSearchAfterPager {
    private final ElasticsearchRestTemplate elasticsearchTemplate;

    public EsSearchAfterPager(ElasticsearchRestTemplate elasticsearchTemplate) {
        this.elasticsearchTemplate = elasticsearchTemplate;
    }

    public <T> EsPageResult<T> searchAfterPage(QueryBuilder builder, int size, List<Object> searchAfter, Class<T> entityClass, SortBuilder<?> ... sorts) {
        NativeSearchQueryBuilder queryBuilder = (NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery(builder).withPageable(Pageable.ofSize((int)size));
        queryBuilder.withSorts(sorts);
        if (searchAfter != null && !searchAfter.isEmpty()) {
            queryBuilder.withSearchAfter(searchAfter);
        }
        NativeSearchQuery query = queryBuilder.build();
        SearchHits searchHits = this.elasticsearchTemplate.search((Query)query, entityClass);
        List nextSearchAfter = null;
        if (searchHits.hasSearchHits() && !searchHits.getSearchHits().isEmpty()) {
            nextSearchAfter = ((SearchHit)searchHits.getSearchHits().get(searchHits.getSearchHits().size() - 1)).getSortValues();
        }
        List content = searchHits.getSearchHits().stream().map(SearchHit::getContent).collect(Collectors.toList());
        return new EsPageResult(content, size, searchHits.getTotalHits(), nextSearchAfter);
    }
}

