/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.robot.controller;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.robot.data.WxMessageBase;
import com.geoway.fczx.robot.data.WxMessagePerson;
import com.geoway.fczx.robot.data.property.RobotProperties;
import com.geoway.fczx.robot.data.property.SmsProperties;
import com.geoway.fczx.robot.handler.CustomWxPushConfig;
import com.geoway.fczx.robot.util.WxRobotTool;
import com.geoway.ue.common.data.response.BaseResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.sms.service.sdk.config.SMSConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/robot/v1"})
public class RobotController {
    @Autowired(required=false)
    private CustomWxPushConfig pushConfig;
    @Resource
    private SMSConfig smsConfig;

    @ApiOperation(value="\u63a8\u9001\u7fa4\u804a\u6d88\u606f")
    @ApiOperationSupport(order=1, ignoreParameters={"phones"})
    @PostMapping(value={"/push/group/message"})
    public ResponseEntity<BaseResponse> pushGroupMessage(@RequestBody WxMessageBase message) {
        this.checkWxPushServer(message);
        WxRobotTool.sendMessage(message, null);
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u63a8\u9001\u4e2a\u4eba\u6d88\u606f")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/push/person/message"})
    public ResponseEntity<BaseResponse> pushPersonMessage(@RequestBody WxMessagePerson message) {
        this.checkWxPushServer(message);
        WxRobotTool.sendMessage(message, message.getPhones());
        return BaseResponse.ok();
    }

    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u6d88\u606f", notes="\u76ee\u524d\u63a5\u5165\u7684\u4e3a\u6cb3\u5317\u7ec4\u4ef6\uff0c\u8c28\u614e\u8c03\u7528")
    @ApiOperationSupport(order=3, includeParameters={"phones", "content"})
    @PostMapping(value={"/notice"})
    public ResponseEntity<BaseResponse> pushNotice(@RequestBody WxMessagePerson message) {
        SmsProperties properties = this.checkSmsPushServer();
        boolean flag = WxRobotTool.sendSMSMessage(properties, message);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
    }

    private SmsProperties checkSmsPushServer() {
        SmsProperties server = null;
        if (this.pushConfig != null) {
            server = this.pushConfig.getSmsPushConfig();
        }
        if (server == null) {
            server = new SmsProperties(this.smsConfig);
        }
        return server;
    }

    private void checkWxPushServer(WxMessageBase message) {
        String server;
        if (ObjectUtil.isEmpty((Object)message.getServer()) && this.pushConfig != null && ObjectUtil.isNotEmpty((Object)(server = this.pushConfig.getWxPushUrl()))) {
            message.setServer(server);
            return;
        }
        message.setServer(RobotProperties.serverUrl);
    }
}

