CREATE SCHEMA IF NOT EXISTS spot;

CREATE SCHEMA IF NOT EXISTS clue;


CREATE TABLE IF NOT EXISTS zx_namespace_spot
(
    namespace_id character varying(64) NOT NULL,
    bsm          character varying(64) NOT NULL
);

CREATE TABLE IF NOT EXISTS manage_device_dictionary
(
    "id"          serial primary key,
    "domain"      int         NOT NULL,
    "device_type" int         NOT NULL,
    "sub_type"    int         NOT NULL,
    "device_name" varchar(32) NOT NULL DEFAULT '',
    "radius"        double precision     DEFAULT 5000,
    "min_height"    double precision     DEFAULT 150,
    "max_height"    double precision     DEFAULT 300,
    "device_desc" varchar(100)         DEFAULT NULL
);

INSERT INTO "manage_device_dictionary" ("id", "domain", "device_type", "sub_type", "device_name", "device_desc")
VALUES (1, 0, 60, 0, 'Matrice 300 RTK', NULL),
       (2, 0, 67, 0, 'Matrice 30', NULL),
       (3, 0, 67, 1, 'Matrice 30T', NULL),
       (4, 1, 20, 0, 'Z30', NULL),
       (5, 1, 26, 0, 'XT2', NULL),
       (6, 1, 39, 0, 'FPV', NULL),
       (7, 1, 41, 0, 'XTS', NULL),
       (8, 1, 42, 0, 'H20', NULL),
       (9, 1, 43, 0, 'H20T', NULL),
       (10, 1, 50, 65535, 'P1', 'include 24 and 35 and 50mm'),
       (11, 1, 52, 0, 'M30 Camera', NULL),
       (12, 1, 53, 0, 'M30T Camera', NULL),
       (13, 1, 61, 0, 'H20N', NULL),
       (14, 1, 165, 0, 'DJI Dock Camera', NULL),
       (15, 1, 90742, 0, 'L1', NULL),
       (16, 2, 56, 0, 'DJI Smart Controller', 'Remote control for M300'),
       (17, 2, 119, 0, 'DJI RC Plus', 'Remote control for M30'),
       (18, 3, 1, 0, 'DJI Dock', ''),
       (19, 0, 77, 0, 'Mavic 3E', NULL),
       (20, 0, 77, 1, 'Mavic 3T', NULL),
       (21, 1, 66, 0, 'Mavic 3E Camera', NULL),
       (22, 1, 67, 0, 'Mavic 3T Camera', NULL),
       (23, 2, 144, 0, 'DJI RC Pro', 'Remote control for Mavic 3E/T and Mavic 3M'),
       (24, 0, 77, 2, 'Mavic 3M', NULL),
       (25, 1, 68, 0, 'Mavic 3M Camera', NULL),
       (26, 0, 89, 0, 'Matrice 350 RTK', NULL),
       (27, 3, 2, 0, 'DJI Dock2', NULL),
       (28, 0, 91, 0, 'M3D', NULL),
       (29, 0, 91, 1, 'M3TD', NULL),
       (30, 1, 80, 0, 'M3D Camera', NULL),
       (31, 1, 81, 0, 'M3TD Camera', NULL),
       (33, 3, 3, 0, 'DJI Dock3', NULL),
       (38, 0, 100, 0, 'M4D', NULL),
       (39, 0, 100, 1, 'M4TD', NULL),
       (40, 1, 98, 0, 'M4D Camera', NULL),
       (41, 1, 99, 0, 'M4TD Camera', NULL),
       (42, 3, 3, 0, 'Dock3', NULL);

CREATE OR REPLACE
    AGGREGATE group_concat(anycompatible)
    (
    sfunc = array_append, -- 每行的操作函数，将本行append到数组里
    stype = anycompatiblearray, -- 聚集后返回数组类型
    initcond = '{}' -- 初始化空数组
    );


CREATE TABLE IF NOT EXISTS zx_limit_map
(
    gid         serial primary key,
    area_id     int8                                NOT NULL,
    address     varchar(255)                        NULL,
    begin_at    timestamptz                         NULL,
    end_at      timestamptz                         NULL,
    color       varchar(7)                          NULL,
    country     varchar(32)                         NULL,
    city        varchar(64)                         NULL,
    data_source int4                                NULL,
    "name"      varchar(64)                         NULL,
    "type"      int4                                NULL,
    url         varchar(255)                        NULL,
    description varchar(255)                        NULL,
    sub_areas   varchar(255)                        NULL,
    lng         float8                              NULL,
    lat         float8                              NULL,
    height      float8                              NULL,
    radius      float8                              NULL,
    shape       int4                                NULL,
    "level"     int4                                NULL,
    geom        public.geometry(multipolygon, 4490) NULL,
    limit_type  integer
);

COMMENT
    ON COLUMN public.zx_limit_map.limit_type
    IS '0 - 禁飞区
        1 - 限高区
        2 - 加强警示区
        3 - 警示区
        4 - 授权区
        5 - 法规限制区
        6 - 法规适飞区
        7 - 风景示范区';

CREATE TABLE IF NOT EXISTS manage_workspace
(
    "id"             serial primary key,
    "workspace_id"   varchar(64)  NOT NULL DEFAULT '',
    "workspace_name" varchar(64)  NOT NULL DEFAULT '',
    "workspace_desc" varchar(100) NOT NULL DEFAULT '',
    "platform_name"  varchar(64)  NOT NULL DEFAULT '',
    "create_time"    bigint       NOT NULL,
    "update_time"    bigint       NOT NULL,
    "bind_code"      varchar(32)  NOT NULL DEFAULT ''
);

ALTER TABLE IF EXISTS manage_workspace
    ADD COLUMN metadata json;
ALTER TABLE IF EXISTS public.manage_workspace
    ADD CONSTRAINT bind_code_uq UNIQUE (bind_code);
ALTER TABLE IF EXISTS public.manage_workspace
    ADD CONSTRAINT workspace_id_uq UNIQUE (workspace_id);

CREATE TABLE IF NOT EXISTS public.zx_spot
(
    gid      integer,
    objectid character varying(64),
    bsm      character varying(64) NOT NULL,
    dlbm     character varying(32),
    dlmc     character varying(32),
    zldwdm   character varying(19),
    zldwmc   character varying(93),
    tbmj     character varying(16),
    yqlqxzqm character varying(100),
    f_userid character varying(100),
    xc_status character varying(16),
    geom     geometry,
    CONSTRAINT gd_tzz1_pkey PRIMARY KEY (bsm)
);

CREATE INDEX IF NOT EXISTS gd_tzz1_f_userid_1680836914241
    ON public.zx_spot USING btree (f_userid);

CREATE INDEX IF NOT EXISTS gd_tzz1_f_xc_status_1680836914241
    ON public.zx_spot USING btree (xc_status);

CREATE INDEX IF NOT EXISTS gd_tzz1_f_zldwdm_1680836914241
    ON public.zx_spot USING btree (zldwdm);

CREATE INDEX IF NOT EXISTS gd_tzz1_geom_1680836938752
    ON public.zx_spot USING gist (geom);

CREATE TABLE IF NOT EXISTS public.zx_spot_summary
(
    zldwdm       character varying(32),
    zldwmc       character varying(64),
    namespace_id character varying(64),
    land_num     integer,
    mj           double precision
);

CREATE INDEX IF NOT EXISTS zx_ns_spot_bsm ON public.zx_namespace_spot USING btree (bsm);
CREATE INDEX IF NOT EXISTS zx_ns_spot_nsid ON public.zx_namespace_spot USING btree (namespace_id);
CREATE INDEX IF NOT EXISTS zx_spot_summary_zldwmc ON public.zx_spot_summary USING btree (zldwmc);
CREATE INDEX IF NOT EXISTS zx_spot_summary_nsid ON public.zx_spot_summary USING btree (namespace_id);


CREATE TABLE IF NOT EXISTS public.zx_system_config
(
    id          character varying(64),
    p_id        character varying(64),
    name        character varying(128),
    code        character varying(32),
    value       character varying(255),
    type        character varying(16),
    dict        json,
    create_time timestamp with time zone,
    update_time timestamp with time zone,
    PRIMARY KEY (id)
);

CREATE SEQUENCE IF not exists seq_clue_no_loop
    INCREMENT 1
    MINVALUE 100001
    MAXVALUE 999999
    START 100001
    CACHE 1
    CYCLE;


CREATE TABLE IF NOT EXISTS "manage_user"
(
    "id"            serial primary key,
    "user_id"       varchar(64) NOT NULL DEFAULT '',
    "username"      varchar(32) NOT NULL DEFAULT '',
    "password"      varchar(255) NOT NULL DEFAULT '',
    "workspace_id"  varchar(64) NOT NULL DEFAULT '',
    "user_type"     smallint    NOT NULL,
    "mqtt_username" varchar(32) NOT NULL DEFAULT '',
    "mqtt_password" varchar(32) NOT NULL DEFAULT '',
    "create_time"   bigint      NOT NULL,
    "update_time"   bigint      NOT NULL
);

ALTER TABLE IF EXISTS manage_user
    ADD CONSTRAINT user_id_uq UNIQUE (user_id);


CREATE TABLE IF NOT EXISTS zx_xzj_xzq
(
    objectid serial primary key,
    xzqmc    character varying(50),
    xzqdm    character varying(50),
    maxx     double precision,
    minx     double precision,
    maxy     double precision,
    miny     double precision,
    level    int4,
    pid      character varying(50),
    geom     public.geometry(Geometry, 4490)
);