ALTER TABLE IF EXISTS media_file
    ADD COLUMN metadata json;

CREATE TABLE IF NOT EXISTS zx_db_export
(
    id             character varying(64) NOT NULL,
    namespace_id   character varying(64),
    namespace_name character varying(64),
    start_time     character varying(22),
    end_time       character varying(22),
    pkg_time       timestamp without time zone,
    status         character varying(4),
    error          text,
    object_key     text,
    PRIMARY KEY (id)
);

ALTER TABLE IF EXISTS zx_db_export
    ADD COLUMN job_ids text;

ALTER TABLE IF EXISTS zx_db_export
    ADD COLUMN type integer default 0;

ALTER TABLE IF EXISTS wayline_job
    ADD COLUMN review_type character varying(16);

ALTER TABLE IF EXISTS wayline_job
    ADD COLUMN analysis_model character varying(128);

ALTER TABLE IF EXISTS wayline_file
    ADD COLUMN metadata json;

CREATE TABLE IF NOT EXISTS zx_plot
(
    plot_id      character varying(32) NOT NULL,
    description  character varying(255),
    tags         character varying(255),
    job_id       character varying(64),
    namespace_id character varying(64),
    object_key   character varying(255),
    plotting     json,
    create_time  timestamp without time zone,
    update_time  timestamp
                     without time zone,
    PRIMARY KEY
        (
         plot_id
            )
);

ALTER TABLE IF EXISTS media_file
    ALTER COLUMN is_original DROP NOT NULL;

ALTER TABLE IF EXISTS wayline_job
    ADD COLUMN exit_wayline_when_rc_lost integer NOT NULL DEFAULT 1;

ALTER TABLE IF EXISTS wayline_job
    ADD COLUMN low_power_continue boolean DEFAULT false;

CREATE TABLE IF NOT EXISTS zx_share
(
    share_id    character varying(64)       NOT NULL,
    type        character varying(8)        NOT NULL,
    expire_time timestamp without time zone NOT NULL,
    encipher    character varying(32),
    status      character varying(8)        NOT NULL,
    create_time timestamp without time zone NOT NULL,
    metadata    json,
    PRIMARY KEY (share_id)
);

CREATE TABLE IF NOT EXISTS model_rebuild_task
(
    id              character varying(64) NOT NULL,
    "name"          character varying(64),
    "type"          integer,
    data_size       double precision,
    create_time     timestamp without time zone,
    status          integer,
    start_time      timestamp without time zone,
    complete_time   timestamp without time zone,
    origin_res_uuid character varying(64),
    output_res_uuid character varying(64),
    err_code        character varying(64),
    err_msg         character varying(255)
);

CREATE TABLE IF NOT EXISTS zx_region_contact
(
    xzqdm      character varying(50),
    contactors json
);

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN percentage numeric;

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN job_task_ids json;

CREATE TABLE zx_job_diagram
(
    job_id   character varying(64) NOT NULL,
    diagram  json,
    rect     text,
    metadata json,
    PRIMARY KEY (job_id)
);

ALTER TABLE IF EXISTS model_rebuild_task
    DROP
        COLUMN IF EXISTS job_task_ids;

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN IF NOT EXISTS process_id character varying(64);

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN IF NOT EXISTS job_task_ids text;

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN IF NOT EXISTS result_info json;

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN IF NOT EXISTS service json;

ALTER TABLE IF EXISTS model_rebuild_task
    ADD COLUMN IF NOT EXISTS metadata json;

CREATE TABLE zx_display_photo
(
    id             character varying(64)  NOT NULL,
    job_id         character varying(64)  NOT NULL,
    job_name       character varying(128) NOT NULL,
    image_spot_ids text                   NOT NULL,
    PRIMARY KEY (id)
);

CREATE TABLE zx_namespace_user
(
    namespace_id   character varying(64)  NOT NULL,
    namespace_name character varying(128) NOT NULL,
    user_id        character varying(64)  NOT NULL,
    user_info      json,
    duty           text
);

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN external json;

ALTER TABLE IF EXISTS manage_device
    ADD COLUMN source character varying(32) DEFAULT 'cloud';

CREATE TABLE zx_package_job
(
    id           character varying(64) NOT NULL,
    name         character varying(255),
    biz_id       character varying(255),
    type         integer,
    fjhxz        text,
    result       character varying(255),
    status       integer,
    file_num     integer,
    package_time timestamp without time zone,
    finish_time  timestamp without time zone,
    PRIMARY KEY (id)
);

ALTER TABLE IF EXISTS zx_wayline_job
    ADD COLUMN dispatch_id character varying(64);

ALTER TABLE IF EXISTS zx_wayline_job
    ADD COLUMN batch_no character varying(64);


CREATE TABLE zx_dispatch_job
(
    id          character varying(64) NOT NULL,
    name        character varying(255),
    type        integer,
    tb_ids      text,
    condition   text,
    metadata    json,
    process     json,
    server      json,
    local       boolean default true,
    meeting     boolean default false,
    judge       boolean default false,
    feedback    boolean default false,
    status      integer,
    owner       character varying(64),
    creator     character varying(64),
    begin_time  timestamp without time zone,
    end_time    timestamp without time zone,
    create_time timestamp without time zone,
    update_time timestamp without time zone,
    PRIMARY KEY (id)
);

CREATE TABLE zx_dispatch_spot
(
    id           serial primary key,
    object_id    character varying(64),
    dispatch_id  character varying(64),
    namespace_id character varying(64),
    xzqdm        character varying(64),
    xzqmc        character varying(64),
    bsm          character varying(64) NOT NULL,
    geom         public.geometry(Geometry, 4490),
    tbmj         double precision,
    tbly         character varying(32),
    metadata     json,
    description  text,
    create_time  timestamp without time zone default current_timestamp
);

CREATE INDEX IF NOT EXISTS zds_geom_idx ON zx_dispatch_spot USING gist (geom);
CREATE INDEX IF NOT EXISTS zds_bsm_idx ON zx_dispatch_spot USING btree (bsm);
CREATE INDEX IF NOT EXISTS zds_dispatch_idx ON zx_dispatch_spot USING btree (dispatch_id);

CREATE TABLE zx_dispatch_flight
(
    id             serial primary key,
    flight_id      character varying(64),
    dispatch_id    character varying(64),
    dock_sn        character varying(64),
    dock_name      character varying(64),
    job_name       character varying(255),
    wayline_name   character varying(255),
    job_status     integer,
    task_type      integer,
    result_count   integer,
    distance       double precision,
    spent          double precision,
    area           double precision,
    tb_ids         text,
    metadata       json,
    create_time    timestamp without time zone,
    begin_time     bigint,
    end_time       bigint,
    execute_time   bigint,
    completed_time bigint
);

ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN custom_type character varying(32);
ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN radius integer;
ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN oid integer;
ALTER TABLE IF EXISTS map_group
    ADD COLUMN level integer not null default '1';
ALTER TABLE IF EXISTS map_group
    ADD COLUMN oid integer;
ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN level integer not null default '2';
ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN metadata json;
ALTER TABLE IF EXISTS map_group_element
    ADD COLUMN shape public.geometry(Geometry, 4490);
ALTER TABLE IF EXISTS map_group
    ADD COLUMN parent_id character varying(64);

CREATE TABLE zx_system_log
(
    id          serial primary key,
    client      character varying(32),
    username    character varying(64),
    "desc"      text,
    result      integer,
    type        integer,
    error       text,
    visit_time  bigint,
    finish_time bigint
)