/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.controller;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.djipri.DjiPriFlighthubApp;
import com.geoway.fczx.djipri.controller.SkPriBaseController;
import com.geoway.fczx.djipri.data.SkControls;
import com.geoway.fczx.djipri.data.SkDronePayload;
import com.geoway.fczx.djipri.data.SkSetRtk;
import com.geoway.fczx.djipri.services.SkPriDeviceService;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkDeviceCamera;
import com.geoway.fczx.djsk.data.SkTaskCmd;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u8bbe\u5907\u63a5\u53e3"}, description="\u79c1\u6709\u7248\u53f8\u7a7a")
@RestController
@ConditionalOnBean(value={DjiPriFlighthubApp.class})
@RequestMapping(value={"/api/dji-pri/device/v1"})
public class SkPriDeviceController
extends SkPriBaseController {
    @Resource
    private SkPriDeviceService priDeviceService;

    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u7269\u6a21\u578b")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/{deviceSn}/state"})
    public ResponseEntity<BaseResponse> getDeviceState(@PathVariable String deviceSn) {
        SkDevice data = this.priDeviceService.getDeviceState(this.obtainPriProperties(), null, deviceSn);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u544a\u8b66")
    @ApiImplicitParam(name="deviceList", value="\u8bbe\u5907SN\u5217\u8868,\u8bbe\u5907SN\u4ee5\u9017\u53f7\u95f4\u9694", required=true)
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/hms"})
    public ResponseEntity<BaseResponse> getDeviceHms(@RequestParam String deviceList) {
        if (ObjectUtil.isEmpty((Object)deviceList)) {
            return BaseResponse.error((String)"\u8bbe\u5907SN\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object data = this.priDeviceService.getDeviceHms(this.obtainPriProperties(), null, deviceList);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u4efb\u52a1\u6307\u4ee4\u4e0b\u53d1")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/execute/cmd"})
    public ResponseEntity<BaseResponse> executeCommand(@RequestBody SkTaskCmd param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getDevice_sn(), param.getDevice_cmd_method()})) {
            boolean flag = this.priDeviceService.executeCommand(this.obtainPriProperties(), param);
            return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u4efb\u52a1\u6307\u4ee4\u4e0b\u53d1\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u673a\u573a\u76f8\u673a\u5207\u6362")
    @ApiOperationSupport(order=4, ignoreParameters={"lensType", "qualityType", "videoExpire"})
    @PostMapping(value={"/change/camera"})
    public ResponseEntity<BaseResponse> changeCamera(@RequestBody SkDeviceCamera param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getCameraIndex(), param.getCameraPosition(), param.getSn()})) {
            boolean flag = this.priDeviceService.changeCamera(this.obtainPriProperties(), param);
            return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u673a\u573a\u76f8\u673a\u5207\u6362\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u98de\u673a\u955c\u5934\u5207\u6362")
    @ApiOperationSupport(order=5, ignoreParameters={"cameraPosition", "qualityType", "videoExpire"})
    @PostMapping(value={"/change/lens"})
    public ResponseEntity<BaseResponse> changeLens(@RequestBody SkDeviceCamera param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getSn(), param.getCameraIndex(), param.getLensType()})) {
            boolean flag = this.priDeviceService.changeLens(this.obtainPriProperties(), param);
            return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u98de\u673a\u955c\u5934\u5207\u6362\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u83b7\u53d6\u8d1f\u8f7d\u63a7\u6743")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/get/control"})
    public ResponseEntity<BaseResponse> getControl(@RequestBody SkDronePayload param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getDroneSn(), param.getPayloadIndex()})) {
            SkControls data = this.priDeviceService.getControl(this.obtainPriProperties(), null, param);
            return ObjectResponse.ok((Object)data);
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u91ca\u653e\u8d1f\u8f7d\u63a7\u6743")
    @ApiOperationSupport(order=7)
    @DeleteMapping(value={"/put/control"})
    public ResponseEntity<BaseResponse> putControl(@RequestBody SkDronePayload param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getDroneSn(), param.getPayloadIndex()})) {
            SkControls data = this.priDeviceService.putControl(this.obtainPriProperties(), null, param);
            return ObjectResponse.ok((Object)data);
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u56fe\u4f20\u6e05\u6670\u8bbe\u7f6e")
    @ApiOperationSupport(order=8, ignoreParameters={"lensType", "cameraPosition", "videoExpire"})
    @PutMapping(value={"/set/quality"})
    public ResponseEntity<BaseResponse> setStreamQuality(@RequestBody SkDeviceCamera param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getSn(), param.getCameraIndex(), param.getQualityType()})) {
            boolean flag = this.priDeviceService.setStreamQuality(this.obtainPriProperties(), null, param);
            return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u56fe\u4f20\u6e05\u6670\u8bbe\u7f6e\u5931\u8d25");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Operation(summary="\u7f51\u7edcRTK\u6807\u5b9a")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/set/rtk"})
    public ResponseEntity<BaseResponse> setRtk(@RequestBody SkSetRtk param) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getAccount(), param.getPort(), param.getHost(), param.getPassword(), param.getMountPoint()})) {
            Boolean data = this.priDeviceService.setRtk(this.obtainPriProperties(), null, param);
            return ObjectResponse.ok((Object)data);
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

