/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.djipri.DjiPriFlighthubApp;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.services.SkPriBaseService;
import com.geoway.fczx.djipri.services.SkPriFileService;
import com.geoway.fczx.djsk.data.call.SkMediaFileInfo;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=2)
@Component
@ConditionalOnMissingBean(value={DjiPriFlighthubApp.class})
public class DjiPriFileSyncHandler {
    private static final Logger log = LoggerFactory.getLogger(DjiPriFileSyncHandler.class);
    private static final String dji_pri_file_upload = "execution(* com.geoway.fczx.core.handler.mqtt.FileUploadHandler.doHandle(..))";
    @Resource
    private SkPriFileService priFileService;
    @Resource
    private SkPriBaseService priBaseService;

    @Pointcut(value="execution(* com.geoway.fczx.core.handler.mqtt.FileUploadHandler.doHandle(..))")
    public void djiPriFileUpload() {
    }

    @Before(value="djiPriFileUpload()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            JSONObject file;
            String flightId;
            DjiPriProperties properties;
            Object[] args = joinPoint.getArgs();
            String payload = (String)args[1];
            if (ObjectUtil.isNotEmpty((Object)payload) && ObjectUtil.isNotEmpty((Object)(properties = this.priBaseService.obtainPriPropertiesByJob(flightId = (String)(file = JSONUtil.parseObj((String)payload)).getByPath("data.file.ext.flight_id", String.class))))) {
                String objectKey = (String)file.getByPath("data.file.object_key", String.class);
                this.priFileService.syncFileUpload(properties, flightId, new SkMediaFileInfo(objectKey));
            }
        }
        catch (Exception e) {
            log.error("\u5927\u7586\u53f8\u7a7a\u79c1\u6709\u7248\u6210\u679c\u56de\u4f20\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }
}

