/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.djipri.data.SkPriWayline;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.handler.AbstractDjiPriToFczxHandler;
import com.geoway.fczx.djipri.services.SkPriBaseService;
import com.geoway.fczx.djipri.services.SkPriFileService;
import com.geoway.fczx.djipri.services.SkPriWaylineService;
import com.geoway.fczx.djsk.data.call.SkExitReturnCall;
import com.geoway.fczx.djsk.data.call.SkFileUploadCall;
import com.geoway.fczx.djsk.data.call.SkReturnHomeCall;
import com.geoway.fczx.djsk.data.call.SkTaskProgressCall;
import com.geoway.fczx.djsk.data.call.SkWaylineUploadCall;
import com.geoway.fczx.djsk.data.message.DjiBaseMessage;
import com.geoway.fczx.djsk.enums.DjskNoticeType;
import com.geoway.fczx.djsk.services.SkWhBaseService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkPriWebhookService
extends SkWhBaseService {
    private static final Logger log = LoggerFactory.getLogger(SkPriWebhookService.class);
    @Autowired(required=false)
    private AbstractDjiPriToFczxHandler priConvertHandler;
    @Resource
    private SkPriWaylineService priWaylineService;
    @Resource
    private SkPriFileService priFileService;
    @Resource
    private SkPriBaseService priBaseService;

    @Override
    public OpRes<Boolean> fileUploadCall(SkFileUploadCall data) {
        log.debug("\u63a5\u6536\u822a\u7ebf\u6210\u679c\u4e0a\u4f20\u6570\u636ebody{}", (Object)JSONUtil.toJsonStr((Object)data));
        if (this.priConvertHandler != null) {
            if (data != null && ObjectUtil.isNotEmpty((Object)data.getSn())) {
                DjiPriProperties properties = this.priBaseService.obtainPriProperties();
                properties.setProjectUuid(data.getProjectUuid());
                data.getFiles().get(0).setObjectKey(data.obtainObjectKey());
                this.priFileService.syncFileUpload(properties, data.getTaskInfo().getTask_id(), data.getFiles().get(0));
                String topic = String.format("thing/product/%s/events", data.getSn());
                if (ObjectUtil.equal((Object)data.getNotifyType(), (Object)DjskNoticeType.fileUpload.getType())) {
                    DjiBaseMessage<Map<String, Object>> message = data.convertFileUploadCallback(0);
                    this.priConvertHandler.sendDjiPriMessageToCloud(topic, message);
                    return new OpRes(null, (Object)true, true);
                }
                if (ObjectUtil.equal((Object)data.getNotifyType(), (Object)DjskNoticeType.drcUpload.getType())) {
                    DjiBaseMessage<Map<String, Object>> message = data.convertFileUploadCallback(1);
                    this.priConvertHandler.sendDjiPriMessageToCloud(topic, message);
                    return new OpRes(null, (Object)true, true);
                }
            }
            log.error("\u63a5\u6536\u5927\u7586\u53f8\u7a7a\u5a92\u4f53\u6587\u4ef6\u4e0a\u4f20\u901a\u77e5\u9519\u8bef");
            return new OpRes("", (Object)false, false);
        }
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5");
    }

    @Override
    public OpRes<Boolean> waylineUploadCall(SkWaylineUploadCall data) {
        if (this.priConvertHandler != null) {
            DjiPriProperties properties;
            SkPriWayline wayline;
            if (data != null && data.getFile() != null && ObjectUtil.isNotEmpty((Object)data.getFile().getId()) && ObjectUtil.equal((Object)data.getFile().getType(), (Object)5) && ObjectUtil.isNotEmpty((Object)(wayline = this.priWaylineService.getWaylineDetail(properties = this.priBaseService.obtainPriProperties(), data.getProjectUuid(), data.getFile().getId())))) {
                wayline.setProjectId(properties.getProjectUuid());
                wayline.setSameStorage(properties.getSameStorage());
                boolean flag = this.priConvertHandler.syncDjiPriWaylineFile(wayline);
                return new OpRes(flag ? null : "\u540c\u6b65\u822a\u7ebf\u6587\u4ef6\u9519\u8bef", (Object)flag, flag);
            }
            return new OpRes("", (Object)false, false);
        }
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5");
    }

    @Override
    public OpRes<Boolean> taskProgressCall(SkTaskProgressCall data) {
        log.info("\u63a5\u6536\u5927\u7586\u53f8\u7a7a\u4efb\u52a1\u8fdb\u5ea6\u6570\u636ebody{}", (Object)JSONUtil.toJsonStr((Object)data));
        if (this.priConvertHandler != null) {
            if (data != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{data.getSn(), data.getUuid()})) {
                String topic = String.format("thing/product/%s/events", data.getSn());
                if (ObjectUtil.equal((Object)data.getNotifyType(), (Object)DjskNoticeType.taskProgress.getType())) {
                    DjiBaseMessage<Map<String, Object>> message = data.convertTaskProgressCallback();
                    this.priConvertHandler.sendDjiPriMessageToCloud(topic, message);
                    return new OpRes(null, (Object)true, true);
                }
            }
            log.error("\u63a5\u6536\u5927\u7586\u53f8\u4efb\u52a1\u8fdb\u5ea6\u4e0a\u62a5\u9519\u8bef");
            return new OpRes("", (Object)false, false);
        }
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5");
    }

    @Override
    public OpRes<Boolean> returnHomeCall(SkReturnHomeCall data) {
        log.info("\u63a5\u6536\u5927\u7586\u53f8\u7a7a\u8fd4\u822a\u4fe1\u606f\u6570\u636ebody{}", (Object)JSONUtil.toJsonStr((Object)data));
        if (this.priConvertHandler != null) {
            return new OpRes("", (Object)false, false);
        }
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5");
    }

    @Override
    public OpRes<Boolean> exitReturnCall(SkExitReturnCall data) {
        if (this.priConvertHandler != null) {
            return new OpRes("", (Object)false, false);
        }
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5");
    }
}

