/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.controller;

import com.geoway.fczx.djsk.DjiFlighthubApp;
import com.geoway.fczx.djsk.controller.SkBaseController;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkDeviceTopo;
import com.geoway.fczx.djsk.data.SkElement;
import com.geoway.fczx.djsk.data.SkMediaFile;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkProject;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.data.SkWayline;
import com.geoway.fczx.djsk.data.SkWaylineFile;
import com.geoway.fczx.djsk.services.SkProjectService;
import com.geoway.ue.common.data.page.PageDto;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u9879\u76ee\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DjiFlighthubApp.class})
@RequestMapping(value={"/api/djsk/project/v1"})
public class SkProjectController
extends SkBaseController {
    @Resource
    private SkProjectService projectService;

    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u9875\u7801", required=true, defaultValue="1"), @ApiImplicitParam(name="pageSize", value="\u5206\u9875\u5927\u5c0f", required=true, defaultValue="10")})
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/org/projects"})
    public ResponseEntity<BaseResponse> getOrgProjects(PageDto param) {
        SkPageData<SkProject> data = this.projectService.getPageOrgProjects(this.obtainOrgKey(), param);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u8bbe\u5907", description="\u5c06\u5927\u7586\u53f8\u7a7a2\u6307\u5b9a\u7ec4\u7ec7\u8bbe\u5907\u5168\u90e8\u83b7\u53d6")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/org/devices"})
    public ResponseEntity<BaseResponse> getOrganDevices() {
        List<SkDevice> data = this.projectService.getOrganDevices(this.obtainOrgKey());
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u62d3\u6251", description="\u5c06\u5927\u7586\u53f8\u7a7a2\u6307\u5b9a\u7ec4\u7ec7\u8bbe\u5907\u5168\u90e8\u83b7\u53d6")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/topo/devices"})
    public ResponseEntity<BaseResponse> getOrganDeviceTopo(@RequestParam(required=false) String projectId, @RequestParam(required=false) String deviceSn) {
        List<SkDeviceTopo> data = this.projectService.getOrganDeviceTopo(this.obtainOrgKey(), projectId, deviceSn);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u9879\u76ee\u8bbe\u5907")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/{projectId}/devices"})
    public ResponseEntity<BaseResponse> getProjectDevices(@PathVariable String projectId) {
        SkPageData<SkDevice> data = this.projectService.getProjectDevices(this.obtainOrgKey(), projectId);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/files/{fileId}"})
    public ResponseEntity<BaseResponse> getFile(@PathVariable String fileId) {
        SkMediaFile data = this.projectService.getFile(this.obtainOrgKey(), fileId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u4e0a\u4f20\u51ed\u8bc1")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/{projectId}/token"})
    public ResponseEntity<BaseResponse> obtainProjectToken(@PathVariable String projectId) {
        SkToken data = this.projectService.obtainProjectToken(this.obtainOrgKey(), projectId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u53d1\u5e03\u521b\u5efa\u4fe1\u606f")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/{projectId}/deploy"})
    public ResponseEntity<BaseResponse> deployProjectElement(@PathVariable String projectId, @RequestBody SkElement params) {
        SkResultData data = this.projectService.deployProjectElement(this.obtainOrgKey(), projectId, params);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u822a\u7ebf\u4e0a\u4f20\u901a\u77e5")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/{projectId}/wayline"})
    public ResponseEntity<BaseResponse> callProjectWayline(@PathVariable String projectId, @RequestBody SkWaylineFile file) {
        SkWayline data = this.projectService.callProjectWayline(this.obtainOrgKey(), projectId, file);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u9879\u76ee\u822a\u7ebf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u9875\u7801", required=true), @ApiImplicitParam(name="size", value="\u5206\u9875\u5927\u5c0f", required=true)})
    @ApiOperationSupport(order=8, ignoreParameters={"param"})
    @GetMapping(value={"/{projectId}/waylines"})
    public ResponseEntity<BaseResponse> getProjectWaylines(@PathVariable String projectId, @RequestParam Map<String, Object> param) {
        SkPageData<SkWayline> data = this.projectService.getProjectWaylines(this.obtainOrgKey(), projectId, param);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u62d3\u6251")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/device/topo"})
    public ResponseEntity<BaseResponse> obtainDeviceTopo(@RequestParam String projectId) {
        List<SkDeviceTopo> data = this.projectService.obtainDeviceTopo(this.obtainOrgKey(), projectId);
        return ObjectResponse.ok(data);
    }
}

