/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.controller;

import com.geoway.fczx.djsk.DjiFlighthubApp;
import com.geoway.fczx.djsk.data.call.SkExitReturnCall;
import com.geoway.fczx.djsk.data.call.SkFileUploadCall;
import com.geoway.fczx.djsk.data.call.SkReturnHomeCall;
import com.geoway.fczx.djsk.data.call.SkTaskProgressCall;
import com.geoway.fczx.djsk.data.call.SkWaylineUploadCall;
import com.geoway.fczx.djsk.services.SkWebhookService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u56de\u8c03\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DjiFlighthubApp.class})
@RequestMapping(value={"/api/djsk/webhook/v1"})
public class SkWebhookController {
    @Resource
    private SkWebhookService webhookService;

    @Operation(summary="\u4efb\u52a1\u6210\u679c\u4e0a\u4f20\u901a\u77e5")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/file/upload"})
    public ResponseEntity<BaseResponse> fileUploadCall(@RequestBody SkFileUploadCall param) {
        OpRes<Boolean> res = this.webhookService.fileUploadCall(param);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @Operation(summary="\u822a\u7ebf\u6587\u4ef6\u4e0a\u4f20\u901a\u77e5", description="\u6a21\u578b\u540e\u91cd\u5efa/\u822a\u7ebf\u6587\u4ef6\u4e0a\u4f20\u901a\u77e5")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/wayline/upload"})
    public ResponseEntity<BaseResponse> waylineUploadCall(@RequestBody SkWaylineUploadCall param) {
        OpRes<Boolean> res = this.webhookService.waylineUploadCall(param);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @Operation(summary="\u4efb\u52a1\u8fdb\u5ea6\u4e0a\u62a5\u901a\u77e5")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/task/progress"})
    public ResponseEntity<BaseResponse> taskProgressCall(@RequestBody SkTaskProgressCall param) {
        OpRes<Boolean> res = this.webhookService.taskProgressCall(param);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @Operation(summary="\u8bbe\u5907\u8fd4\u822a\u4fe1\u606f\u63a8\u9001")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/return/home"})
    public ResponseEntity<BaseResponse> returnHomeCall(@RequestBody SkReturnHomeCall param) {
        OpRes<Boolean> res = this.webhookService.returnHomeCall(param);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }

    @Operation(summary="\u8bbe\u5907\u9000\u51fa\u8fd4\u822a\u901a\u77e5")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/exit/return"})
    public ResponseEntity<BaseResponse> exitReturnCall(@RequestBody SkExitReturnCall param) {
        OpRes<Boolean> res = this.webhookService.exitReturnCall(param);
        return res.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)res.getErrorDesc());
    }
}

