/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.enums;

import com.geoway.fczx.djsk.data.SkConverterState;
import com.geoway.fczx.djsk.data.SkConverters;
import com.geoway.fczx.djsk.data.SkMediaFile;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTaskDetail;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.data.SkTrack;
import com.geoway.fczx.djsk.data.SkWayline;
import org.springframework.http.HttpMethod;

public enum DjskRestApi {
    getProjectWaylines("/storage/api/v1.0/projects/{project_uuid}/wayline-files?page={page}&size={size}", HttpMethod.GET, SkPageData.class),
    obtainTaskTrack("/task/api/v1.0/projects/{project_uuid}/flight-tasks/track?task_uuid={task_uuid}", HttpMethod.GET, SkTrack.class),
    callProjectWayline("/storage/api/v1.0/projects/{project_uuid}/wayline-file-upload-callback", HttpMethod.POST, SkWayline.class),
    obtainTaskDetail("/task/api/v1.0/projects/{project_uuid}/flight-tasks/{task_uuid}", HttpMethod.GET, SkTaskDetail.class),
    getOrgProjects("/manage/api/v1.0/projects?page={page}&page_size={page_size}", HttpMethod.GET, SkPageData.class),
    obtainProjectToken("/storage/api/v1.0/projects/{project_uuid}/security-token", HttpMethod.POST, SkToken.class),
    createFlightTask("/task/api/v1.0/projects/{project_uuid}/flight-tasks", HttpMethod.POST, SkResultData.class),
    deployProjectElement("/map/api/v1.0/projects/{project_uuid}/elements", HttpMethod.POST, SkResultData.class),
    obtainDeviceTopo("/manage/api/v1.0/projects/{project_uuid}/topologies", HttpMethod.GET, SkResultData.class),
    getConverter("/manage/api/v1.0/stream-converters?channel={channel}", HttpMethod.GET, SkConverters.class),
    executeCommand("/manage/api/v1.0/projects/{project_uuid}/flight-commands", HttpMethod.POST, Void.class),
    getProjectDevices("/manage/api/v1.0/projects/{project_uuid}/devices", HttpMethod.GET, SkPageData.class),
    closeConverter("/manage/api/v1.0/stream-converters/{converter_id}", HttpMethod.DELETE, Void.class),
    startConverter("/manage/api/v1.0/stream-converters", HttpMethod.POST, SkConverterState.class),
    getFile("/storage/api/v1.0/files/{file_uuid}", HttpMethod.GET, SkMediaFile.class);

    private final String uri;
    private final HttpMethod method;
    private final Class<?> clazz;

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private DjskRestApi(String uri, HttpMethod method, Class<?> clazz) {
        this.uri = uri;
        this.method = method;
        this.clazz = clazz;
    }
}

