/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.fczx.djsk.constant.DjskConst;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkDeviceTopo;
import com.geoway.fczx.djsk.data.SkElement;
import com.geoway.fczx.djsk.data.SkMediaFile;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkProject;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.data.SkWayline;
import com.geoway.fczx.djsk.data.SkWaylineFile;
import com.geoway.fczx.djsk.enums.DjskRestApi;
import com.geoway.fczx.djsk.handler.AbstractDjskToFczxHandler;
import com.geoway.fczx.djsk.handler.AbstractDjskWhCallHandler;
import com.geoway.fczx.djsk.handler.DjskBaseHandler;
import com.geoway.ue.common.data.page.PageDto;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkProjectService {
    private static final Logger log = LoggerFactory.getLogger(SkProjectService.class);
    @Resource
    private DjskBaseHandler baseHandler;
    @Autowired(required=false)
    private AbstractDjskToFczxHandler convertHandler;
    @Autowired(required=false)
    private AbstractDjskWhCallHandler whCallHandler;

    public SkPageData<SkProject> getPageOrgProjects(String orgKey, PageDto param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", param.getPageNum());
        map.put("page_size", param.getPageSize());
        SkPageData pageData = (SkPageData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.getOrgProjects, map, MapUtil.empty());
        SkProjectService skProjectService = this;
        return pageData.setList((List)skProjectService.baseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkProject>>(){}));
    }

    public SkPageData<SkDevice> getProjectDevices(String orgKey, String projectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("project_uuid", projectId);
        SkPageData pageData = (SkPageData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.getProjectDevices, map, MapUtil.empty());
        SkProjectService skProjectService = this;
        return pageData.setList((List)skProjectService.baseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkDevice>>(){}));
    }

    public SkResultData deployProjectElement(String orgKey, String projectId, SkElement params) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        return (SkResultData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.deployProjectElement, map, (Map<String, Object>)JSONUtil.parseObj((Object)params));
    }

    public SkToken obtainProjectToken(String orgKey, String projectId) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        return (SkToken)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.obtainProjectToken, map, MapUtil.empty());
    }

    public SkWayline callProjectWayline(String orgKey, String projectId, SkWaylineFile file) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        log.debug("file{}", (Object)file);
        return (SkWayline)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.callProjectWayline, map, (Map<String, Object>)JSONUtil.parseObj((Object)file));
    }

    public SkMediaFile getFile(String orgKey, String fileId) {
        HashMap map = MapUtil.of((Object)"file_uuid", (Object)fileId);
        return (SkMediaFile)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.getFile, map, MapUtil.empty());
    }

    public SkPageData<SkWayline> getProjectWaylines(String orgKey, String projectId, Map<String, Object> param) {
        param.put("project_uuid", projectId);
        SkPageData pageData = (SkPageData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.getProjectWaylines, param, MapUtil.empty());
        SkProjectService skProjectService = this;
        return pageData.setList((List)skProjectService.baseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkWayline>>(){}));
    }

    public List<SkDeviceTopo> obtainDeviceTopo(String orgKey, String projectId) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        SkResultData data = (SkResultData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.obtainDeviceTopo, map, MapUtil.empty());
        if (data != null && ObjectUtil.isNotEmpty(data.getList())) {
            SkProjectService skProjectService = this;
            return (List)skProjectService.baseHandler.getObjectMapper().convertValue(data.getList(), (TypeReference)new TypeReference<List<SkDeviceTopo>>(){});
        }
        return Collections.emptyList();
    }

    public List<SkProject> getOrganProjects(String orgKey) {
        ArrayList<SkProject> projects = new ArrayList<SkProject>();
        int page = 1;
        long total = 0L;
        do {
            PageDto param = new PageDto();
            param.setPageNum(Integer.valueOf(page));
            param.setPageSize(Integer.valueOf(DjskConst.DJI_MAX_PAGE.intValue()));
            SkPageData<SkProject> res = this.getPageOrgProjects(orgKey, param);
            if (res != null && ObjectUtil.isNotEmpty(res.getList())) {
                projects.addAll(res.getList());
                total = res.getPagination().getTotal();
                ++page;
                continue;
            }
            page = 0;
        } while ((long)(page - 1) * DjskConst.DJI_MAX_PAGE < total);
        return projects;
    }

    public List<SkDevice> getOrganDevices(String orgKey) {
        ArrayList<SkDevice> devices = new ArrayList<SkDevice>();
        List<SkProject> projects = this.getOrganProjects(orgKey);
        for (SkProject project : projects) {
            SkPageData<SkDevice> res = this.getProjectDevices(orgKey, project.getUuid());
            if (res == null || !ObjectUtil.isNotEmpty(res.getList())) continue;
            devices.addAll(res.getList());
        }
        devices.removeIf(dev -> !BooleanUtil.isTrue((Boolean)dev.getIsOrgDevice()));
        return devices;
    }

    public List<SkDeviceTopo> getOrganDeviceTopo(String orgKey, String projectId, String deviceSn) {
        List<Object> deviceTopo = new ArrayList();
        if (projectId == null) {
            List<SkProject> projects = this.getOrganProjects(orgKey);
            for (SkProject project : projects) {
                List<SkDeviceTopo> res = this.obtainDeviceTopo(orgKey, project.getUuid());
                if (res == null || !ObjectUtil.isNotEmpty(res)) continue;
                res.forEach(data -> data.setProject(project));
                deviceTopo.addAll(res);
            }
        } else {
            deviceTopo = this.obtainDeviceTopo(orgKey, projectId);
        }
        if (deviceTopo.size() > 1 && ObjectUtil.isNotEmpty((Object)deviceSn)) {
            return deviceTopo.stream().filter(e -> e.containsSn(deviceSn)).collect(Collectors.toList());
        }
        return deviceTopo;
    }

    public boolean syncOrganDevices(String orgKey) {
        HashMap<String, SkDevice> devices = new HashMap<String, SkDevice>();
        List<SkDeviceTopo> list = this.getOrganDeviceTopo(orgKey, null, null);
        if (ObjectUtil.isNotEmpty(list)) {
            for (SkDeviceTopo topo : list) {
                if (!ObjectUtil.isNotEmpty((Object)topo.getHost())) continue;
                if (ObjectUtil.isNotEmpty((Object)topo.getHost().getDeviceSn())) {
                    topo.getHost().setProject(topo.getProject());
                    devices.put(topo.getHost().getDeviceSn(), topo.getHost());
                }
                if (!ObjectUtil.isNotEmpty(topo.getParents())) continue;
                for (SkDevice device : topo.getParents()) {
                    if (!ObjectUtil.isNotEmpty((Object)device.getDeviceSn())) continue;
                    device.setProject(topo.getProject());
                    devices.put(device.getDeviceSn(), device);
                }
            }
        }
        if (this.convertHandler != null && ObjectUtil.isNotEmpty(devices)) {
            OpRes<Boolean> res = this.convertHandler.syncDjskDevices(devices.values());
            if (this.whCallHandler != null) {
                this.whCallHandler.syncDevicesAfter(devices.values());
            }
            return res.isOpRes();
        }
        return false;
    }
}

