/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.djsk.data.SkConverter;
import com.geoway.fczx.djsk.data.SkConverterChannel;
import com.geoway.fczx.djsk.data.SkConverterState;
import com.geoway.fczx.djsk.data.SkConverters;
import com.geoway.fczx.djsk.enums.DjskRestApi;
import com.geoway.fczx.djsk.handler.DjskBaseHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SkStreamService {
    private static final Logger log = LoggerFactory.getLogger(SkStreamService.class);
    @Resource
    private DjskBaseHandler baseHandler;

    public SkConverterState startConverter(String orgKey, SkConverter param) {
        return (SkConverterState)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.startConverter, MapUtil.empty(), (Map<String, Object>)JSONUtil.parseObj((Object)param));
    }

    public boolean closeConverter(String orgKey, String convertId) {
        HashMap map = MapUtil.of((Object)"converter_id", (Object)convertId);
        this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.closeConverter, map, MapUtil.empty());
        return true;
    }

    public SkConverters getConverter(String orgKey, String channel) {
        HashMap map = MapUtil.of((Object)"channel", (Object)channel);
        return (SkConverters)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.getConverter, map, MapUtil.empty());
    }

    public boolean closeDeviceConvert(String orgKey, String deviceSn, String payload) {
        String channel = deviceSn + "_" + payload;
        SkConverters converters = this.getConverter(orgKey, channel);
        if (converters != null && ObjectUtil.isNotEmpty(converters.getMembers())) {
            for (SkConverterChannel converterChannel : converters.getMembers()) {
                if (!ObjectUtil.isNotEmpty((Object)converterChannel.getConverterId())) continue;
                this.closeConverter(orgKey, converterChannel.getConverterId());
            }
        }
        return true;
    }
}

