/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTask;
import com.geoway.fczx.djsk.data.SkTaskCmd;
import com.geoway.fczx.djsk.data.SkTaskDetail;
import com.geoway.fczx.djsk.data.SkTrack;
import com.geoway.fczx.djsk.enums.DjskRestApi;
import com.geoway.fczx.djsk.handler.DjskBaseHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SkTaskService {
    private static final Logger log = LoggerFactory.getLogger(SkTaskService.class);
    @Resource
    private DjskBaseHandler baseHandler;

    public SkResultData createFlightTask(String orgKey, String projectId, SkTask param) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        return (SkResultData)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.createFlightTask, map, (Map<String, Object>)JSONUtil.parseObj((Object)param));
    }

    public boolean executeCommand(String orgKey, String projectId, SkTaskCmd param) {
        HashMap map = MapUtil.of((Object)"project_uuid", (Object)projectId);
        this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.executeCommand, map, (Map<String, Object>)JSONUtil.parseObj((Object)param));
        return true;
    }

    public SkTrack obtainTaskTrack(String orgKey, String projectId, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("project_uuid", projectId);
        map.put("task_uuid", taskId);
        return (SkTrack)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.obtainTaskTrack, map, MapUtil.empty());
    }

    public SkTaskDetail obtainTaskDetail(String orgKey, String projectId, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("project_uuid", projectId);
        map.put("task_uuid", taskId);
        return (SkTaskDetail)this.baseHandler.forwardDjskRequest(orgKey, DjskRestApi.obtainTaskDetail, map, MapUtil.empty());
    }
}

