/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.jouav.data.param.GimbalControlForm;
import com.geoway.fczx.jouav.data.param.GimbalGeneraForm;
import com.geoway.fczx.jouav.data.param.GimbalManualTrackForm;
import com.geoway.fczx.jouav.data.param.JouavChargeDto;
import com.geoway.fczx.jouav.data.param.JouavPayloadDto;
import com.geoway.fczx.jouav.data.param.JouavServoDto;
import com.geoway.fczx.jouav.data.param.JouavSwitchDto;
import com.geoway.fczx.jouav.data.param.JouavVideoOperation;
import com.geoway.fczx.jouav.data.param.JouavWaypointDto;
import com.geoway.fczx.jouav.enmus.JouavRestApi;
import com.geoway.fczx.jouav.handler.JouavBaseHandler;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.util.Path;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import java.io.InputStream;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7eb5\u6a2a\u8bbe\u5907\u63a7\u5236"})
@RestController
@RequestMapping(value={"/api/jouav/control/v1"})
public class JoCommandController {
    @Resource
    private JouavBaseHandler jouavHandler;

    @Operation(summary="\u5145\u7535\u7ba1\u7406\u63a7\u5236")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/charge/manage"})
    public ResponseEntity<BaseResponse> chargeManagement(@RequestBody JouavChargeDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.chargeManagement, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u673a\u5e93\u4f3a\u670d\u63a7\u5236", description="\u6839\u636e\u9700\u8981\u6267\u884c\u7684\u6307\u4ee4\u4f20\u5165\u5bf9\u5e94\u53c2\u6570\uff0c\u5176\u4ed6\u6307\u4ee4\u53c2\u6570\u5219\u4e0d\u4f20")
    @ApiOperationSupport(order=2, ignoreParameters={"power"})
    @PostMapping(value={"/servo/control"})
    public ResponseEntity<BaseResponse> servoControl(@RequestBody JouavServoDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.servoControl, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u98de\u673a\u4e0a\u7535\u63a7\u5236")
    @ApiOperationSupport(order=3, includeParameters={"siteSn", "power"})
    @PostMapping(value={"/task/control"})
    public ResponseEntity<BaseResponse> taskControl(@RequestBody JouavServoDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.taskControl, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8fdb\u5165\u98de\u524d\u81ea\u68c0")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/flight/prepare"})
    public ResponseEntity<BaseResponse> flightPreparation(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.flightPreparation, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u63a8\u51fa\u98de\u524d\u81ea\u68c0")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/exit/prepare"})
    public ResponseEntity<BaseResponse> exitPreparation(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.exitFlightPreparation, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8bbe\u5907\u4e00\u952e\u8d77\u98de")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/takeoff"})
    public ResponseEntity<BaseResponse> takeOff(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.takeOff, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u5feb\u901f\u98de\u884c\u8ba1\u5212", description="\u53d1\u9001\u6307\u4ee4\uff0c\u8ba9\u65e0\u4eba\u673a\u5728\u6307\u5b9a\u4f4d\u7f6e\u76d8\u65cb")
    @ApiOperationSupport(order=7, ignoreParameters={"idx"})
    @PostMapping(value={"/quick/waypoint"})
    public ResponseEntity<BaseResponse> quickWayPoint(@RequestBody JouavWaypointDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.quickWayPoint, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u822a\u70b9\u65ad\u70b9\u7eed\u98de", description="\u5bfc\u822a\u5230\u8ba1\u5212\u822a\u7ebf\u5bf9\u5e94\u822a\u70b9\u7ee7\u7eed\u98de\u884c\uff0c\u5982\u679c idx\u4f20 0\uff0c\u5219\u4e3a\u8fd4\u822a")
    @ApiOperationSupport(order=8, ignoreParameters={"quickWayPointForm", "isOrbit"})
    @PostMapping(value={"/track/operation"})
    public ResponseEntity<BaseResponse> trackOperation(@RequestBody JouavWaypointDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.trackOperation, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8bbe\u5907\u4e91\u53f0\u63a7\u5236", description="\u7f29\u653e\uff0c\u7ea2\u5916\u5f00\u5173\uff0c\u76ee\u6807\u8ddf\u8e2a\u5f00\u5173")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/gimbal/control"})
    public ResponseEntity<BaseResponse> gimbalControl(@RequestBody JouavPayloadDto<GimbalControlForm> param) {
        System.out.println(JSONUtil.toJsonPrettyStr((Object)BeanUtil.beanToMap(param, (String[])new String[0])));
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.gimbalControl, MapUtil.empty(), BeanUtil.beanToMap(param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u4e91\u53f0\u89d2\u5ea6\u63a7\u5236")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/gimbal/genera"})
    public ResponseEntity<BaseResponse> gimbalGenera(@RequestBody JouavPayloadDto<GimbalGeneraForm> param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.gimbalGenera, MapUtil.empty(), BeanUtil.beanToMap(param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8bbe\u5907\u53bb\u96fe\u5f00\u5173")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/play/defog"})
    public ResponseEntity<BaseResponse> defogSwitch(@RequestBody JouavSwitchDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.defogSwitch, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8bbe\u5907\u7a33\u50cf\u5f00\u5173")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/play/electronic"})
    public ResponseEntity<BaseResponse> electronicSwitch(@RequestBody JouavSwitchDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.electronicSwitch, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u4e91\u53f0\u624b\u52a8\u8ddf\u8e2a")
    @ApiOperationSupport(order=13)
    @PostMapping(value={"/gimbal/track"})
    public ResponseEntity<BaseResponse> gimbalManualTrack(@RequestBody JouavPayloadDto<GimbalManualTrackForm> param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.gimbalTrack, MapUtil.empty(), BeanUtil.beanToMap(param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="\u89c6\u9891AIAR\u8bc6\u522b")
    @ApiOperationSupport(order=14)
    @PostMapping(value={"/video/operation"})
    public ResponseEntity<BaseResponse> videoOperation(JouavVideoOperation param) {
        String path = Path.mergePath((String[])new String[]{System.getProperty("user.dir"), "jouav", IdUtil.randomUUID()});
        try {
            String filename = "";
            if (ObjectUtil.isNotEmpty((Object)param.getFile())) {
                filename = Path.mergePath((String[])new String[]{path, param.getFile().getOriginalFilename()});
                FileUtil.writeFromStream((InputStream)param.getFile().getInputStream(), (String)filename);
            }
            Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.videoOperation, MapUtil.empty(), param.toFileMap(filename));
            ResponseEntity responseEntity = ObjectResponse.ok(data);
            return responseEntity;
        }
        catch (Exception e) {
            ResponseEntity responseEntity = BaseResponse.error((String)"\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25");
            return responseEntity;
        }
        finally {
            FileUtil.del((String)path);
        }
    }

    @Operation(summary="\u73af\u5883\u5f3a\u5236\u901a\u8fc7")
    @ApiOperationSupport(order=15)
    @GetMapping(value={"/env/force"})
    public ResponseEntity<BaseResponse> envForce(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.envForce, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8f7d\u8377\u5f3a\u5236\u901a\u8fc7")
    @ApiOperationSupport(order=16)
    @GetMapping(value={"/payload/force"})
    public ResponseEntity<BaseResponse> payloadForce(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.payloadForce, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }
}

