/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.fczx.jouav.data.JouavBaseList;
import com.geoway.fczx.jouav.data.JouavDevice;
import com.geoway.fczx.jouav.data.JouavMissionNotice;
import com.geoway.fczx.jouav.data.JouavMissionSub;
import com.geoway.fczx.jouav.data.JouavModel;
import com.geoway.fczx.jouav.data.JouavPilot;
import com.geoway.fczx.jouav.data.JouavPlanDetail;
import com.geoway.fczx.jouav.data.JouavPoint;
import com.geoway.fczx.jouav.data.JouavRecord;
import com.geoway.fczx.jouav.data.JouavRoute;
import com.geoway.fczx.jouav.data.JouavRouteHome;
import com.geoway.fczx.jouav.data.JouavRouteTarget;
import com.geoway.fczx.jouav.data.JouavSite;
import com.geoway.fczx.jouav.data.JouavToken;
import com.geoway.fczx.jouav.data.param.JouavElevationDto;
import com.geoway.fczx.jouav.data.param.JouavMissionDto;
import com.geoway.fczx.jouav.data.param.JouavRouteDto;
import com.geoway.fczx.jouav.data.param.JouavTaskParam;
import com.geoway.fczx.jouav.data.property.JouavProperties;
import com.geoway.fczx.jouav.enmus.JoMissionAction;
import com.geoway.fczx.jouav.enmus.JouavRestApi;
import com.geoway.fczx.jouav.handler.AbstractJouavToFczxHandler;
import com.geoway.fczx.jouav.handler.JouavBaseHandler;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JoFlightService {
    private static final Logger log = LoggerFactory.getLogger(JoFlightService.class);
    @Resource
    private JouavBaseHandler baseHandler;
    @Autowired(required=false)
    private AbstractJouavToFczxHandler convertHandler;

    public JouavBaseList<JouavDevice> getAccountSites() {
        JouavBaseList datalist = (JouavBaseList)this.baseHandler.forwardJouavRequest(JouavRestApi.siteList, MapUtil.empty(), null);
        JoFlightService joFlightService = this;
        datalist.setList((List)joFlightService.baseHandler.getObjectMapper().convertValue(datalist.getList(), (TypeReference)new TypeReference<List<JouavDevice>>(){}));
        return datalist;
    }

    public JouavBaseList<JouavPilot> getAccountFlights() {
        JouavBaseList datalist = (JouavBaseList)this.baseHandler.forwardJouavRequest(JouavRestApi.flightList, MapUtil.empty(), null);
        JoFlightService joFlightService = this;
        datalist.setList((List)joFlightService.baseHandler.getObjectMapper().convertValue(datalist.getList(), (TypeReference)new TypeReference<List<JouavPilot>>(){}));
        return datalist;
    }

    public JouavBaseList<JouavPlanDetail> getAccountPlans() {
        JouavBaseList datalist = (JouavBaseList)this.baseHandler.forwardJouavRequest(JouavRestApi.planList, MapUtil.empty(), null);
        JoFlightService joFlightService = this;
        datalist.setList((List)joFlightService.baseHandler.getObjectMapper().convertValue(datalist.getList(), (TypeReference)new TypeReference<List<JouavPlanDetail>>(){}));
        return datalist;
    }

    public JouavBaseList<JouavRecord> getPlanRecords(String planNo) {
        JouavBaseList datalist = (JouavBaseList)this.baseHandler.forwardJouavRequest(JouavRestApi.getRecords, MapUtil.of((Object)"planNo", (Object)planNo), null);
        JoFlightService joFlightService = this;
        datalist.setList((List)joFlightService.baseHandler.getObjectMapper().convertValue(datalist.getList(), (TypeReference)new TypeReference<List<JouavRecord>>(){}));
        return datalist;
    }

    public boolean syncAccountDevices() {
        JouavBaseList<JouavDevice> devList = this.getAccountSites();
        JouavBaseList<JouavPilot> pilotList = this.getAccountFlights();
        if (this.convertHandler != null && (ObjectUtil.isNotEmpty(devList.getList()) || ObjectUtil.isNotEmpty(pilotList.getList()))) {
            OpRes<Boolean> res = this.convertHandler.syncJouavDevices(devList.getList(), pilotList.getList());
            return res.isOpRes();
        }
        return false;
    }

    public boolean bindSiteWithAir(String siteSn, String pilotSn) {
        if (this.convertHandler != null) {
            return this.convertHandler.bindJouavDevice(siteSn, pilotSn);
        }
        return true;
    }

    public Object obtainDeviceLive(String sn, Integer type) {
        if (ObjectUtil.equal((Object)type, (Object)0)) {
            return this.baseHandler.forwardJouavRequest(JouavRestApi.getFlightPullUrl, MapUtil.of((Object)"autopliotSn", (Object)sn), null);
        }
        if (ObjectUtil.equal((Object)type, (Object)3)) {
            return this.baseHandler.forwardJouavRequest(JouavRestApi.getSitePullUrl, MapUtil.of((Object)"siteSn", (Object)sn), null);
        }
        return null;
    }

    public boolean accessPlatform(JouavProperties config, boolean force) {
        if (this.convertHandler != null) {
            return this.convertHandler.accessJouavPlatform(config, force);
        }
        return false;
    }

    public boolean releasePlatform(String name) {
        if (this.convertHandler != null) {
            return this.convertHandler.releaseJouavPlatform(name);
        }
        return false;
    }

    public boolean subscribeMission(JouavMissionSub param) {
        if (this.convertHandler != null) {
            return this.convertHandler.subscribeMission(param);
        }
        return false;
    }

    public boolean unsubscribeMission(String id) {
        if (this.convertHandler != null) {
            return this.convertHandler.unsubscribeMission(id);
        }
        return false;
    }

    public boolean noticeMission(JouavMissionNotice param) {
        if (this.convertHandler != null) {
            boolean flag = this.convertHandler.noticeMission(param);
            if (flag) {
                this.baseHandler.forwardJouavRequest(JouavRestApi.takeOff, MapUtil.of((Object)"planNo", (Object)param.getData().getPlanNo()), null);
            } else if (param != null && ObjectUtil.equal((Object)((Object)param.getAction()), (Object)((Object)JoMissionAction.takeOff)) && ObjectUtil.isNotEmpty((Object)param.getData().getPlanNo())) {
                OpRes<Boolean> opRes = this.convertDroneFlight(param.getData().getPlanNo(), new JSONObject());
                log.warn("\u65b0\u589eplanNo\uff1a{}", (Object)opRes.getErrorDesc());
            }
            return true;
        }
        return false;
    }

    public OpRes<Boolean> executePlan(String planNo, Integer executeType, JouavTaskParam taskParam) {
        Boolean flag;
        if (ObjectUtil.notEqual((Object)executeType, (Object)0) && BooleanUtil.isFalse((Boolean)(flag = (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.updateExecuteType, MapUtil.empty(), taskParam.toTaskParam(planNo))))) {
            return new OpRes("\u8bbe\u7f6e\u4efb\u52a1\u7c7b\u578b\u5931\u8d25", (Object)false, false);
        }
        flag = (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.flightPreparation, MapUtil.of((Object)"planNo", (Object)planNo), null);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            return new OpRes("\u4efb\u52a1\u81ea\u68c0\u5931\u8d25", (Object)false, false);
        }
        return new OpRes(null, (Object)true, true);
    }

    public OpRes<JouavMissionDto> generatingRoute(String name, Integer waylineType, JouavDevice device, List<JouavPoint> points) {
        String targetType;
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("parentModelIds", device.getUavModelId());
        query.put("realType", 1);
        JSONArray types = (JSONArray)this.baseHandler.forwardJouavRequest(JouavRestApi.getModelsByParent, query, null);
        JouavModel model = types.toList(JouavModel.class).stream().filter(e -> ObjectUtil.equal((Object)e.getTypeId(), (Object)8)).findFirst().orElse(null);
        if (model == null) {
            log.error("\u672a\u627e\u5230\u8bbe\u5907{}\u540a\u8231\u4fe1\u606f", (Object)device.getUavModelId());
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907\u540a\u8231\u4fe1\u606f", null, false);
        }
        JouavRouteDto routeDto = new JouavRouteDto();
        routeDto.setPlanName(name);
        routeDto.setCategoryType(1);
        routeDto.setLandSiteSn(device.getSiteSn());
        routeDto.setStartSiteSn(device.getSiteSn());
        routeDto.setUavModelId(device.getUavModelId());
        routeDto.setLoadModelId(model.getChildModelId());
        JouavSite site = (JouavSite)this.baseHandler.forwardJouavRequest(JouavRestApi.siteInfo, MapUtil.of((Object)"id", (Object)device.getId()), null);
        if (ObjectUtil.isEmpty((Object)site) || ObjectUtil.isEmpty((Object)site.getInfo())) {
            log.error("\u672a\u627e\u5230\u8bbe\u5907{}Home\u53ca\u5907\u964d\u70b9\u4fe1\u606f", (Object)device.getSiteSn());
            return new OpRes("\u672a\u627e\u5230\u8bbe\u5907Home\u53ca\u5907\u964d\u70b9\u4fe1\u606f", null, false);
        }
        JouavRouteHome home = new JouavRouteHome();
        home.setHeight(site.getInfo().getHeight());
        home.setOrbitRadius(device.getOrbitRadius());
        home.setLatitude(site.getInfo().getLatitude());
        home.setLongitude(site.getInfo().getLongitude());
        home.setAuxiliaryRoute("Hover");
        routeDto.setPlanHomeParamForm(home);
        JouavElevationDto elevationDto = new JouavElevationDto();
        HashMap<String, Object> geoJson = new HashMap<String, Object>();
        LinkedList coordinates = new LinkedList();
        LinkedList<Double> height = new LinkedList<Double>();
        LinkedList<Double> latitude = new LinkedList<Double>();
        LinkedList<Double> longitude = new LinkedList<Double>();
        geoJson.put("coordinates", coordinates);
        if (ObjectUtil.equal((Object)waylineType, (Object)0)) {
            targetType = "Line";
            geoJson.put("type", "LineString");
            points.forEach(p -> {
                height.add(p.getHeight());
                latitude.add(p.getLatitude());
                longitude.add(p.getLongitude());
                coordinates.add(Arrays.asList(p.getLongitude(), p.getLatitude(), p.getHeight()));
            });
        } else if (ObjectUtil.equal((Object)waylineType, (Object)1)) {
            targetType = "Polygon";
            geoJson.put("type", "Polygon");
            LinkedList list = new LinkedList();
            points.forEach(p -> {
                height.add(p.getHeight());
                latitude.add(p.getLatitude());
                longitude.add(p.getLongitude());
                list.add(Arrays.asList(p.getLongitude(), p.getLatitude(), p.getHeight()));
            });
            coordinates.add(list);
        } else {
            log.error("\u672a\u77e5\u822a\u7ebf\u7c7b\u578b\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1");
            return new OpRes("\u672a\u77e5\u822a\u7ebf\u7c7b\u578b\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1", null, false);
        }
        elevationDto.setDistance(200.0);
        elevationDto.setGeoJsonContent(geoJson);
        Double elevation = (Double)this.baseHandler.forwardJouavRequest(JouavRestApi.getMeanElevation, MapUtil.empty(), elevationDto);
        if (ObjectUtil.isEmpty((Object)elevation)) {
            log.error("\u83b7\u53d6\u5de1\u67e5\u76ee\u6807\u5e73\u5747\u9ad8\u7a0b\u5931\u8d25");
            return new OpRes("\u83b7\u53d6\u5de1\u67e5\u76ee\u6807\u5e73\u5747\u9ad8\u7a0b\u5931\u8d25", null, false);
        }
        JouavRouteTarget target = new JouavRouteTarget();
        target.setAdaptiveAltitude(false);
        target.setDatumElevation(elevation);
        target.setFrontalBearing(device.getFrontalBearing());
        target.setRelativeHeightMin(device.getRelativeHeightMin());
        target.setGroundSampleDistance(device.getGroundSampleDistance());
        target.setAscendMax(0.0);
        target.setDescendMax(0.0);
        target.setOrbitRadius(0.0);
        target.setHeight(height);
        target.setLatitude(latitude);
        target.setLongitude(longitude);
        target.setId(IdUtil.fastSimpleUUID());
        target.setIsRight(false);
        target.setIsEdit(false);
        target.setIsPuzzle(false);
        target.setIsRight(true);
        target.setTurningRight(true);
        target.setRelativeHeight(150.0);
        target.setLateralOverlap(device.getLateralOverlap());
        target.setRouteSpacing(device.getRouteSpacing());
        target.setStripeCount(1);
        target.setOrbitTime(device.getOrbitTime());
        target.setViewAngle(device.getViewAngle());
        target.setTargetType(targetType);
        target.setTargetName(name + "\u5de1\u67e5\u76ee\u6807");
        routeDto.setGenerationTargetForms(Collections.singletonList(target));
        JouavRoute route = (JouavRoute)this.baseHandler.forwardJouavRequest(JouavRestApi.generatingRoute, MapUtil.empty(), BeanUtil.beanToMap((Object)routeDto, (String[])new String[0]));
        if (ObjectUtil.isEmpty((Object)route)) {
            log.error("\u751f\u6210\u7eb5\u6a2a\u822a\u7ebf\u5931\u8d25");
            return new OpRes("\u751f\u6210\u7eb5\u6a2a\u822a\u7ebf\u5931\u8d25", null, false);
        }
        log.debug("\u6d4b\u8bd5{}", route.getTargetJson());
        JouavMissionDto missionDto = new JouavMissionDto();
        missionDto.setSwitchEntryPointVO(route.getSwitchEntryPointVO());
        missionDto.setMissionPlanParamVO(route.getMissionPlanParamVO());
        missionDto.setPlanHomeParamForm(route.getPlanHomeParamVO());
        missionDto.setPlanJsonUrl(route.getPlanJsonUrl());
        missionDto.setTargetJson(route.getTargetJson());
        missionDto.setRouteJson(route.getRouteJson());
        missionDto.setCategoryId(routeDto.getCategoryType());
        missionDto.setLoadModelId(model.getChildModelId());
        missionDto.setUavModelId(device.getUavModelId());
        missionDto.setStartSiteSn(device.getSiteSn());
        missionDto.setLandSiteSn(device.getSiteSn());
        missionDto.setPlanHomeParamForm(home);
        missionDto.setPlanName(name);
        missionDto.setPhotoMode(2);
        String planNo = (String)this.baseHandler.forwardJouavRequest(JouavRestApi.saveOrUpdatePlan, MapUtil.empty(), BeanUtil.beanToMap((Object)missionDto, (String[])new String[0]));
        missionDto.setPlanNo(planNo);
        return new OpRes(null, (Object)missionDto, true);
    }

    public boolean removeFailPlan(String planNo) {
        HashMap param = MapUtil.of((Object)"planNo", (Object)planNo);
        Boolean flag = (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.exitFlightPreparation, param, null);
        if (BooleanUtil.isTrue((Boolean)flag)) {
            return (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.deletePlan, param, null);
        }
        return false;
    }

    public boolean ExecuteDebug(String planNo, Boolean takeoff) {
        Boolean flag = (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.flightPreparation, MapUtil.of((Object)"planNo", (Object)planNo), null);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u4efb\u52a1\u81ea\u68c0\u5931\u8d25");
            return false;
        }
        if (BooleanUtil.isTrue((Boolean)takeoff) && BooleanUtil.isFalse((Boolean)(flag = (Boolean)this.baseHandler.forwardJouavRequest(JouavRestApi.takeOff, MapUtil.of((Object)"planNo", (Object)planNo), null)))) {
            log.error("\u4efb\u52a1\u8d77\u98de\u5931\u8d25");
            return false;
        }
        return true;
    }

    public JouavToken obtainToken() {
        return this.baseHandler.getToken(this.baseHandler.getJouavProperties().getName());
    }

    public JSONObject checkAccess() {
        if (this.convertHandler != null) {
            return this.convertHandler.queryJouavConfig();
        }
        return null;
    }

    public OpRes<Boolean> convertDroneFlight(String planNo, JSONObject param) {
        if (this.convertHandler != null) {
            JouavPlanDetail detail = (JouavPlanDetail)this.baseHandler.forwardJouavRequest(JouavRestApi.planInfo, MapUtil.of((Object)"planNo", (Object)planNo), null);
            if (ObjectUtil.isEmpty((Object)detail)) {
                return new OpRes(String.format("\u672a\u67e5\u8be2\u5230\u8ba1\u5212%s\u4fe1\u606f", planNo), (Object)false, false);
            }
            int status = 1;
            if (ObjectUtil.equal((Object)detail.getPlanStatus(), (Object)3)) {
                status = 2;
            } else {
                JouavBaseList<JouavRecord> records = this.getPlanRecords(planNo);
                if (records != null && ObjectUtil.isNotEmpty(records.getList())) {
                    status = 3;
                }
            }
            return this.convertHandler.saveJoDroneJob(detail.buildDroneMap(param, status));
        }
        return new OpRes("\u8702\u5de2\u6682\u672a\u5b9e\u73b0\u8be5\u65b9\u6cd5", (Object)false, false);
    }

    public boolean syncAccountPlans() {
        JouavBaseList<JouavPlanDetail> list;
        if (this.convertHandler != null && (list = this.getAccountPlans()) != null && ObjectUtil.isNotEmpty(list.getList())) {
            list.getList().forEach(data -> this.convertDroneFlight(data.getPlanNo(), new JSONObject()));
        }
        return true;
    }

    public String getLiveProvider() {
        return this.baseHandler.getJouavProperties().getProvider();
    }
}

