/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.interceptor.DynamicSchemaInterceptor;
import com.geoway.tenant.interceptor.TenantInterceptor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);
    @Resource
    private MultiTenantProperties tenantProperties;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)this.dataPermissionInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.dynamicSchemaInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.paginationInnerInterceptor());
        return interceptor;
    }

    public TenantInterceptor dataPermissionInterceptor() {
        return new TenantInterceptor(this.tenantProperties);
    }

    public DynamicTableNameInnerInterceptor dynamicSchemaInterceptor() {
        DynamicTableNameInnerInterceptor dynamicSchemaInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicSchemaInterceptor.setTableNameHandler((TableNameHandler)new DynamicSchemaInterceptor(this.tenantProperties));
        return dynamicSchemaInterceptor;
    }

    public PaginationInnerInterceptor paginationInnerInterceptor() {
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(DbType.POSTGRE_SQL);
        paginationInnerInterceptor.setOverflow(true);
        return paginationInnerInterceptor;
    }
}

