/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.config;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.handler.MqttTenantIdHandler;
import com.geoway.tenant.interceptor.MqttTenantPointCut;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.apache.commons.compress.utils.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ComponentScan(basePackages={"com.geoway.tenant.handler", "com.geoway.tenant.config", "com.geoway.tenant.thirdapi"})
@EnableConfigurationProperties(value={MultiTenantProperties.class})
public class TenantBaseConfig {
    private static final Logger log = LoggerFactory.getLogger(TenantBaseConfig.class);
    @Resource
    private MultiTenantProperties tenantProperties;

    @Bean
    public Pointcut mqttTenantPointCut() {
        MqttTenantPointCut mqttTenantPointCut = new MqttTenantPointCut();
        mqttTenantPointCut.setExpression(this.tenantProperties.getMqttPointCut().getPointcut());
        return mqttTenantPointCut;
    }

    @Bean
    public MqttTenantIdHandler mqttTenantIdHandler() {
        log.info("\u6ce8\u518cmqtt\u79df\u6237\u4fe1\u606f\u5904\u7406\u5668");
        String ignorePaths = System.getProperty("uis.sso.client.ignore-paths");
        if (ObjectUtil.isNotEmpty((Object)ignorePaths)) {
            this.tenantProperties.setExcludePaths(Sets.newHashSet((Object[])ignorePaths.split(",")));
        }
        if (BooleanUtil.isFalse((Boolean)this.tenantProperties.getEnableSsoAuthTest())) {
            System.setProperty("uis.sso.client.ignore-paths", String.join((CharSequence)",", this.tenantProperties.getExcludePaths()));
        }
        return new MqttTenantIdHandler();
    }

    @Bean
    public DefaultPointcutAdvisor mqttTenantPointCutAdvisor() {
        DefaultPointcutAdvisor mqttTenantPointCutAdvisor = new DefaultPointcutAdvisor();
        mqttTenantPointCutAdvisor.setPointcut(this.mqttTenantPointCut());
        mqttTenantPointCutAdvisor.setAdvice((Advice)this.mqttTenantIdHandler());
        mqttTenantPointCutAdvisor.setOrder(0);
        return mqttTenantPointCutAdvisor;
    }

    @Bean(name={"tenantRedisTemplate"})
    public RedisTemplate<String, String> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.setKeySerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate.setHashValueSerializer((RedisSerializer)this.stringRedisSerializer());
        return redisTemplate;
    }

    private StringRedisSerializer stringRedisSerializer() {
        return new StringRedisSerializer();
    }
}

