/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.data;

import com.geoway.tenant.constant.TenantConst;
import com.geoway.tenant.enmus.MqttPointCut;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="com.geoway.fczx.tenant")
public class MultiTenantProperties {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantProperties.class);
    private Set<String> nonTenantTables = TenantConst.NON_TENANT_TABLE;
    private Set<String> excludePaths = TenantConst.EXCLUDE_PATHS;
    private String ssoServer;
    private String uis3Server;
    private String uisDroneAppId = "c21b74e110f4447598e28bc118fcdd54";
    private String headerTokenKey = "satoken";
    private String contexts = "tenant";
    private String changeLog = "classpath:db/changelog-master.xml";
    private String bindCodePrefix = "FCZX";
    private Integer tokenTimeout = 86400;
    public MqttPointCut mqttPointCut = MqttPointCut.fczx;
    private Boolean enableSsoAuthTest = true;
    private Integer schedulePoolNum = 10;
    private String pilotMqttPwd = "geoway2025";
    private String pilotMqttUrl;
    private Boolean changeWorkspaceId = true;

    @Value(value="${com.geoway.fczx.tenant.non-tenant-tables:}")
    public void setNonTenantTables(Set<String> nonTenantTables) {
        this.nonTenantTables = nonTenantTables;
        this.nonTenantTables.addAll(TenantConst.NON_TENANT_TABLE);
    }

    @Value(value="${com.geoway.fczx.tenant.exclude-paths:}")
    public void setExcludePaths(Set<String> excludePaths) {
        this.excludePaths = excludePaths;
        this.excludePaths.addAll(TenantConst.EXCLUDE_PATHS);
    }

    public Set<String> getNonTenantTables() {
        return this.nonTenantTables;
    }

    public Set<String> getExcludePaths() {
        return this.excludePaths;
    }

    public String getSsoServer() {
        return this.ssoServer;
    }

    public String getUis3Server() {
        return this.uis3Server;
    }

    public String getUisDroneAppId() {
        return this.uisDroneAppId;
    }

    public String getHeaderTokenKey() {
        return this.headerTokenKey;
    }

    public String getContexts() {
        return this.contexts;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getBindCodePrefix() {
        return this.bindCodePrefix;
    }

    public Integer getTokenTimeout() {
        return this.tokenTimeout;
    }

    public MqttPointCut getMqttPointCut() {
        return this.mqttPointCut;
    }

    public Boolean getEnableSsoAuthTest() {
        return this.enableSsoAuthTest;
    }

    public Integer getSchedulePoolNum() {
        return this.schedulePoolNum;
    }

    public String getPilotMqttPwd() {
        return this.pilotMqttPwd;
    }

    public String getPilotMqttUrl() {
        return this.pilotMqttUrl;
    }

    public Boolean getChangeWorkspaceId() {
        return this.changeWorkspaceId;
    }

    public void setSsoServer(String ssoServer) {
        this.ssoServer = ssoServer;
    }

    public void setUis3Server(String uis3Server) {
        this.uis3Server = uis3Server;
    }

    public void setUisDroneAppId(String uisDroneAppId) {
        this.uisDroneAppId = uisDroneAppId;
    }

    public void setHeaderTokenKey(String headerTokenKey) {
        this.headerTokenKey = headerTokenKey;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public void setBindCodePrefix(String bindCodePrefix) {
        this.bindCodePrefix = bindCodePrefix;
    }

    public void setTokenTimeout(Integer tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    public void setMqttPointCut(MqttPointCut mqttPointCut) {
        this.mqttPointCut = mqttPointCut;
    }

    public void setEnableSsoAuthTest(Boolean enableSsoAuthTest) {
        this.enableSsoAuthTest = enableSsoAuthTest;
    }

    public void setSchedulePoolNum(Integer schedulePoolNum) {
        this.schedulePoolNum = schedulePoolNum;
    }

    public void setPilotMqttPwd(String pilotMqttPwd) {
        this.pilotMqttPwd = pilotMqttPwd;
    }

    public void setPilotMqttUrl(String pilotMqttUrl) {
        this.pilotMqttUrl = pilotMqttUrl;
    }

    public void setChangeWorkspaceId(Boolean changeWorkspaceId) {
        this.changeWorkspaceId = changeWorkspaceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiTenantProperties)) {
            return false;
        }
        MultiTenantProperties other = (MultiTenantProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tokenTimeout = this.getTokenTimeout();
        Integer other$tokenTimeout = other.getTokenTimeout();
        if (this$tokenTimeout == null ? other$tokenTimeout != null : !((Object)this$tokenTimeout).equals(other$tokenTimeout)) {
            return false;
        }
        Boolean this$enableSsoAuthTest = this.getEnableSsoAuthTest();
        Boolean other$enableSsoAuthTest = other.getEnableSsoAuthTest();
        if (this$enableSsoAuthTest == null ? other$enableSsoAuthTest != null : !((Object)this$enableSsoAuthTest).equals(other$enableSsoAuthTest)) {
            return false;
        }
        Integer this$schedulePoolNum = this.getSchedulePoolNum();
        Integer other$schedulePoolNum = other.getSchedulePoolNum();
        if (this$schedulePoolNum == null ? other$schedulePoolNum != null : !((Object)this$schedulePoolNum).equals(other$schedulePoolNum)) {
            return false;
        }
        Boolean this$changeWorkspaceId = this.getChangeWorkspaceId();
        Boolean other$changeWorkspaceId = other.getChangeWorkspaceId();
        if (this$changeWorkspaceId == null ? other$changeWorkspaceId != null : !((Object)this$changeWorkspaceId).equals(other$changeWorkspaceId)) {
            return false;
        }
        Set<String> this$nonTenantTables = this.getNonTenantTables();
        Set<String> other$nonTenantTables = other.getNonTenantTables();
        if (this$nonTenantTables == null ? other$nonTenantTables != null : !((Object)this$nonTenantTables).equals(other$nonTenantTables)) {
            return false;
        }
        Set<String> this$excludePaths = this.getExcludePaths();
        Set<String> other$excludePaths = other.getExcludePaths();
        if (this$excludePaths == null ? other$excludePaths != null : !((Object)this$excludePaths).equals(other$excludePaths)) {
            return false;
        }
        String this$ssoServer = this.getSsoServer();
        String other$ssoServer = other.getSsoServer();
        if (this$ssoServer == null ? other$ssoServer != null : !this$ssoServer.equals(other$ssoServer)) {
            return false;
        }
        String this$uis3Server = this.getUis3Server();
        String other$uis3Server = other.getUis3Server();
        if (this$uis3Server == null ? other$uis3Server != null : !this$uis3Server.equals(other$uis3Server)) {
            return false;
        }
        String this$uisDroneAppId = this.getUisDroneAppId();
        String other$uisDroneAppId = other.getUisDroneAppId();
        if (this$uisDroneAppId == null ? other$uisDroneAppId != null : !this$uisDroneAppId.equals(other$uisDroneAppId)) {
            return false;
        }
        String this$headerTokenKey = this.getHeaderTokenKey();
        String other$headerTokenKey = other.getHeaderTokenKey();
        if (this$headerTokenKey == null ? other$headerTokenKey != null : !this$headerTokenKey.equals(other$headerTokenKey)) {
            return false;
        }
        String this$contexts = this.getContexts();
        String other$contexts = other.getContexts();
        if (this$contexts == null ? other$contexts != null : !this$contexts.equals(other$contexts)) {
            return false;
        }
        String this$changeLog = this.getChangeLog();
        String other$changeLog = other.getChangeLog();
        if (this$changeLog == null ? other$changeLog != null : !this$changeLog.equals(other$changeLog)) {
            return false;
        }
        String this$bindCodePrefix = this.getBindCodePrefix();
        String other$bindCodePrefix = other.getBindCodePrefix();
        if (this$bindCodePrefix == null ? other$bindCodePrefix != null : !this$bindCodePrefix.equals(other$bindCodePrefix)) {
            return false;
        }
        MqttPointCut this$mqttPointCut = this.getMqttPointCut();
        MqttPointCut other$mqttPointCut = other.getMqttPointCut();
        if (this$mqttPointCut == null ? other$mqttPointCut != null : !((Object)((Object)this$mqttPointCut)).equals((Object)other$mqttPointCut)) {
            return false;
        }
        String this$pilotMqttPwd = this.getPilotMqttPwd();
        String other$pilotMqttPwd = other.getPilotMqttPwd();
        if (this$pilotMqttPwd == null ? other$pilotMqttPwd != null : !this$pilotMqttPwd.equals(other$pilotMqttPwd)) {
            return false;
        }
        String this$pilotMqttUrl = this.getPilotMqttUrl();
        String other$pilotMqttUrl = other.getPilotMqttUrl();
        return !(this$pilotMqttUrl == null ? other$pilotMqttUrl != null : !this$pilotMqttUrl.equals(other$pilotMqttUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiTenantProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tokenTimeout = this.getTokenTimeout();
        result = result * 59 + ($tokenTimeout == null ? 43 : ((Object)$tokenTimeout).hashCode());
        Boolean $enableSsoAuthTest = this.getEnableSsoAuthTest();
        result = result * 59 + ($enableSsoAuthTest == null ? 43 : ((Object)$enableSsoAuthTest).hashCode());
        Integer $schedulePoolNum = this.getSchedulePoolNum();
        result = result * 59 + ($schedulePoolNum == null ? 43 : ((Object)$schedulePoolNum).hashCode());
        Boolean $changeWorkspaceId = this.getChangeWorkspaceId();
        result = result * 59 + ($changeWorkspaceId == null ? 43 : ((Object)$changeWorkspaceId).hashCode());
        Set<String> $nonTenantTables = this.getNonTenantTables();
        result = result * 59 + ($nonTenantTables == null ? 43 : ((Object)$nonTenantTables).hashCode());
        Set<String> $excludePaths = this.getExcludePaths();
        result = result * 59 + ($excludePaths == null ? 43 : ((Object)$excludePaths).hashCode());
        String $ssoServer = this.getSsoServer();
        result = result * 59 + ($ssoServer == null ? 43 : $ssoServer.hashCode());
        String $uis3Server = this.getUis3Server();
        result = result * 59 + ($uis3Server == null ? 43 : $uis3Server.hashCode());
        String $uisDroneAppId = this.getUisDroneAppId();
        result = result * 59 + ($uisDroneAppId == null ? 43 : $uisDroneAppId.hashCode());
        String $headerTokenKey = this.getHeaderTokenKey();
        result = result * 59 + ($headerTokenKey == null ? 43 : $headerTokenKey.hashCode());
        String $contexts = this.getContexts();
        result = result * 59 + ($contexts == null ? 43 : $contexts.hashCode());
        String $changeLog = this.getChangeLog();
        result = result * 59 + ($changeLog == null ? 43 : $changeLog.hashCode());
        String $bindCodePrefix = this.getBindCodePrefix();
        result = result * 59 + ($bindCodePrefix == null ? 43 : $bindCodePrefix.hashCode());
        MqttPointCut $mqttPointCut = this.getMqttPointCut();
        result = result * 59 + ($mqttPointCut == null ? 43 : ((Object)((Object)$mqttPointCut)).hashCode());
        String $pilotMqttPwd = this.getPilotMqttPwd();
        result = result * 59 + ($pilotMqttPwd == null ? 43 : $pilotMqttPwd.hashCode());
        String $pilotMqttUrl = this.getPilotMqttUrl();
        result = result * 59 + ($pilotMqttUrl == null ? 43 : $pilotMqttUrl.hashCode());
        return result;
    }

    public String toString() {
        return "MultiTenantProperties(nonTenantTables=" + this.getNonTenantTables() + ", excludePaths=" + this.getExcludePaths() + ", ssoServer=" + this.getSsoServer() + ", uis3Server=" + this.getUis3Server() + ", uisDroneAppId=" + this.getUisDroneAppId() + ", headerTokenKey=" + this.getHeaderTokenKey() + ", contexts=" + this.getContexts() + ", changeLog=" + this.getChangeLog() + ", bindCodePrefix=" + this.getBindCodePrefix() + ", tokenTimeout=" + this.getTokenTimeout() + ", mqttPointCut=" + (Object)((Object)this.getMqttPointCut()) + ", enableSsoAuthTest=" + this.getEnableSsoAuthTest() + ", schedulePoolNum=" + this.getSchedulePoolNum() + ", pilotMqttPwd=" + this.getPilotMqttPwd() + ", pilotMqttUrl=" + this.getPilotMqttUrl() + ", changeWorkspaceId=" + this.getChangeWorkspaceId() + ")";
    }
}

