/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.exception.TenantException;
import com.geoway.tenant.util.SqlUtil;
import com.geoway.tenant.util.TenantUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantInterceptor
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantInterceptor.class);
    private MultiTenantProperties tenantProperties;

    public void beforePrepare(StatementHandler handler, Connection conn, Integer transactionTimeout) {
        String schema;
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)handler.getBoundSql());
        Set<String> tableNames = SqlUtil.getTableListName(mpBoundSql.sql());
        String current = this.getCurrentTenantId();
        boolean isNeed = false;
        try {
            schema = conn.getSchema();
            log.debug("\u5f53\u524d\u662f\u5426\u5207\u6362\u6570\u636e\u5e93\uff1a{}\uff0c\u5f53\u524d\u6570\u636e\u5e93{}-{}\nsql--{}\n\u5f53\u524d\u83b7\u53d6\u8868\u540d\uff1a{}", new Object[]{!this.isPlatform(tableNames), schema, current, mpBoundSql.sql(), tableNames});
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{tableNames, this.tenantProperties.getNonTenantTables()}) && this.isPlatform(tableNames) && ObjectUtil.notEqual((Object)schema, (Object)"public")) {
                isNeed = true;
                current = "public";
            }
        }
        catch (Exception e) {
            log.error("\u5f53\u524d\u6570\u636e\u5e93", (Throwable)e);
        }
        if (!this.isPlatform(tableNames) || isNeed || mpBoundSql.sql().contains("CREATE TABLE")) {
            try {
                schema = conn.getSchema();
                if (ObjectUtil.notEqual((Object)schema, (Object)current)) {
                    conn.setSchema(current);
                }
            }
            catch (SQLException e) {
                log.error("\u5207\u6362\u79df\u6237schema\u5f02\u5e38", (Throwable)e);
                throw new TenantException("\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        super.beforePrepare(handler, conn, transactionTimeout);
    }

    public String getCurrentTenantId() {
        return Optional.ofNullable(TenantUtil.getTenantId()).orElse("public");
    }

    public boolean isPlatform(Set<String> tableNames) {
        return CollectionUtil.containsAll(this.tenantProperties.getNonTenantTables(), tableNames);
    }

    public TenantInterceptor() {
    }

    public TenantInterceptor(MultiTenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

