/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller;

import com.geoway.drone.model.dto.DroneDto;
import com.geoway.drone.model.entity.AppServer;
import com.geoway.drone.model.entity.DroneInfo;
import com.geoway.drone.serface.AppConfigService;
import com.geoway.drone.serface.AppPermissionService;
import com.geoway.drone.serface.AppServerService;
import com.geoway.drone.serface.DroneInfoService;
import com.gw.base.data.result.GiResult;
import com.gw.base.data.result.GwEmAlertType;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dronecenter/third"})
public class ThirdController {
    @Autowired
    AppServerService appServerService;
    @Autowired
    AppConfigService appConfigService;
    @Autowired
    AppPermissionService appPermissionService;
    @Autowired
    DroneInfoService droneService;

    @PostMapping(value={"/register"})
    public GiResult<?> register(@RequestParam(value="appkey") String appkey, @RequestParam(value="model") String model, @RequestParam(value="sn") String sn, @RequestParam(value="username") String username, @RequestParam(value="userid") String userid, @RequestParam(value="rname", required=false) String rname, @RequestParam(value="phone", required=false) String phone, @RequestParam(value="company", required=false) String company, HttpServletRequest request) {
        DroneDto drone = new DroneDto();
        drone.setCompany(company);
        drone.setModelnum(model);
        drone.setSn(sn);
        drone.setState(Integer.valueOf(1));
        drone.setAppkey(appkey);
        drone.setUserid(userid);
        drone.setUsername(username);
        drone.setRname(rname);
        drone.setPhone(phone);
        drone.setDeviceName(model);
        drone.setDeviceCom(model);
        DroneDto drone1 = this.droneService.addOne(drone);
        if (drone1 == null) {
            return GiResult.failureMsg((String)"\u6ce8\u518c\u5931\u8d25");
        }
        return GiResult.successValue((Object)drone1);
    }

    @PostMapping(value={"/isreg"})
    public GiResult<?> isreg(@RequestParam(value="sn") String sn, HttpServletRequest request) {
        DroneInfo droneBySn = this.droneService.getDroneBySn(sn);
        if (droneBySn == null) {
            return GiResult.success();
        }
        return GiResult.successValue((Object)droneBySn);
    }

    @PostMapping(value={"/hasPermission"})
    public GiResult<?> hasPermission(@RequestParam(value="appkey") String appkey, @RequestParam(value="appkeySub") String appkeySub, @RequestParam(value="token") String token, HttpServletRequest request) {
        List allowList = this.appPermissionService.getAllowList(appkey, appkeySub);
        if (allowList == null || allowList.isEmpty()) {
            return GiResult.failureMsg((String)"\u65e0\u6743\u9650");
        }
        return GiResult.success();
    }

    @GetMapping(value={"/getWatermark"}, produces={"image/jpeg"})
    @ResponseBody
    public Object GetPhoto(@RequestParam(value="appkey") String appkey) {
        Object getPhoto = this.appServerService.getPhoto(appkey);
        if (getPhoto == null) {
            return null;
        }
        return getPhoto;
    }

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    public String getConfig(@RequestParam(value="appkey") String appkey) {
        AppServer server = this.appServerService.getServer(appkey);
        return server != null ? server.getConfig() : "";
    }

    @PostMapping(value={"/getServerUrl"})
    public GiResult<?> getServerUrl(@RequestParam(value="appkey") String appkey, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            return GiResult.failureSetMsgAndType((String)"appkey\u4e3a\u7a7a", (GwEmAlertType)GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u9519\u8bef3);
        }
        AppServer appServer = this.appServerService.getServer(appkey);
        return GiResult.successValue((Object)appServer);
    }

    @PostMapping(value={"/getAppNames"})
    public GiResult<?> getNames(@RequestParam(value="appkeys") String appkeys, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank((CharSequence)appkeys)) {
            return GiResult.failureSetMsgAndType((String)"appkey\u4e3a\u7a7a", (GwEmAlertType)GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u9519\u8bef3);
        }
        List<String> appkeyList = Arrays.asList(appkeys.split(","));
        List mapList = this.appServerService.selectNameByAppkeys(appkeyList);
        return GiResult.successValue((Object)mapList);
    }
}

