/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller;

import com.geoway.drone.model.entity.AppServer;
import com.geoway.drone.serface.AppServerService;
import com.gw.base.data.result.GiResult;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dronecenter/drone/appserver"})
public class AppServerController {
    @Autowired
    private AppServerService appServerService;

    @GetMapping(value={"/listByPage"})
    public GiResult<?> listByPage(@RequestParam(name="appkey", required=false) String appkey, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows) {
        return GiResult.successValue((Object)this.appServerService.listByPage(appkey, page, rows));
    }

    @PostMapping(value={"/update"})
    public GiResult<?> update(@RequestBody AppServer appServer) {
        this.appServerService.update(appServer);
        return GiResult.success();
    }

    @PostMapping(value={"/save"})
    public GiResult<?> insert(@RequestBody AppServer appServer) {
        this.appServerService.insert(appServer);
        return GiResult.success();
    }

    @GetMapping(value={"/getServer"})
    public GiResult<?> getServer(String appkey) {
        return GiResult.successValue((Object)this.appServerService.getServer(appkey));
    }

    @PostMapping(value={"/setPhoto"})
    public GiResult<?> setPhoto(String appkey, MultipartFile file) throws IOException {
        this.appServerService.setPhoto(appkey, file);
        return GiResult.success();
    }

    @GetMapping(value={"/getPhotoBase64"})
    public GiResult<?> getPhotoBase64(String appkey) {
        return GiResult.successValue((Object)this.appServerService.getPhotoBase64(appkey));
    }

    @GetMapping(value={"/getPhoto"})
    public GiResult<?> getPhoto(String appkey) {
        return GiResult.successValue((Object)this.appServerService.getPhoto(appkey));
    }
}

